/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.naming;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.naming.Util;
import org.jboss.logging.Logger;

public class JndiBinder
implements ObjectFactory {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)JndiBinder.class.getName());
    private static ConcurrentMap<String, Object> objs = new ConcurrentHashMap<String, Object>();
    private String name;
    private Object obj;

    public void setName(String v) {
        this.name = v;
    }

    public void setObject(Object v) {
        this.obj = v;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String objName = (String)ref.get("name").getContent();
        return objs.get(objName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws Throwable {
        if (this.name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (this.obj == null) {
            throw new IllegalArgumentException("Obj is null");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Binding %s under %s", this.obj.getClass().getName(), this.name);
        }
        InitialContext context = new InitialContext();
        try {
            String className = this.obj.getClass().getName();
            Reference ref = new Reference(className, new StringRefAddr("class", className), JndiBinder.class.getName(), null);
            ref.add(new StringRefAddr("name", this.name));
            objs.put(this.name, this.obj);
            Util.bind((Context)context, this.name, (Object)ref);
            if (log.isDebugEnabled()) {
                log.debug("Bound " + this.obj.getClass().getName() + " under " + this.name);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() throws Throwable {
        if (this.name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        log.tracef("Unbinding %s", this.name);
        InitialContext context = null;
        try {
            context = new InitialContext();
            Util.unbind((Context)context, this.name);
            objs.remove(this.name);
            if (log.isDebugEnabled()) {
                log.debug("Unbound " + this.name);
            }
        }
        catch (Throwable t) {
            log.exceptionDuringUnbind(t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {}
            }
        }
    }
}

