/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.sts.token.validator.SubjectRoleParser;

public class DefaultSubjectRoleParser
implements SubjectRoleParser {
    private String roleClassifier;
    private String roleClassifierType = "prefix";

    @Override
    public Set<Principal> parseRolesFromSubject(Principal principal, Subject subject) {
        if (subject != null) {
            if (this.roleClassifier != null && !"".equals(this.roleClassifier)) {
                RolePrefixSecurityContextImpl securityContext = new RolePrefixSecurityContextImpl(subject, this.roleClassifier, this.roleClassifierType);
                return securityContext.getUserRoles();
            }
            return new DefaultSecurityContext(principal, subject).getUserRoles();
        }
        return Collections.emptySet();
    }

    public String getRoleClassifier() {
        return this.roleClassifier;
    }

    public void setRoleClassifier(String roleClassifier) {
        this.roleClassifier = roleClassifier;
    }

    public String getRoleClassifierType() {
        return this.roleClassifierType;
    }

    public void setRoleClassifierType(String roleClassifierType) {
        this.roleClassifierType = roleClassifierType;
    }
}

