/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.hawkular.wildfly.agent.installer.AgentInstaller;
import org.hawkular.wildfly.agent.installer.EncoderDecoder;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedCommandBuilder;
import org.jboss.aesh.cl.internal.ProcessedOptionBuilder;
import org.jboss.logging.Logger;

public class InstallerConfiguration {
    private static final Logger log = Logger.getLogger(AgentInstaller.class);
    static final String COMMAND_NAME = "hawkular-wildfly-agent-installer";
    static final String OPTION_INSTALLER_CONFIG = "installer-config";
    static final String OPTION_ENCRYPTION_KEY = "encryption-key";
    static final String OPTION_ENCRYPTION_SALT = "encryption-salt";
    static final String OPTION_ENABLED = "enabled";
    static final String OPTION_CONFIG_ONLY = "config-only";
    static final String OPTION_TARGET_LOCATION = "target-location";
    static final String OPTION_MODULE_DISTRIBUTION = "module-dist";
    static final String OPTION_TARGET_CONFIG = "target-config";
    static final String OPTION_SUBSYSTEM_SNIPPET = "subsystem-snippet";
    static final String OPTION_SERVER_URL = "server-url";
    static final String OPTION_DOWNLOAD_SERVER_URL = "download-server-url";
    static final String OPTION_KEYSTORE_PATH = "keystore-path";
    static final String OPTION_KEYSTORE_PASSWORD = "keystore-password";
    static final String OPTION_USERNAME = "username";
    static final String OPTION_PASSWORD = "password";
    static final String OPTION_MANAGED_SERVER_NAME = "managed-server-name";
    static final String OPTION_FEED_ID = "feed-id";
    static final String OPTION_TENANT_ID = "tenant-id";
    static final String OPTION_METRICS_ONLY_MODE = "metrics-only";
    static final String OPTION_MANAGED_RESOURCE_TYPE_SETS = "managed-server-resource-type-sets";
    private final Properties properties;

    static ProcessedCommand<?> buildCommandLineOptions() throws Exception {
        ProcessedCommandBuilder cmd = new ProcessedCommandBuilder();
        cmd.name(COMMAND_NAME);
        cmd.addOption(new ProcessedOptionBuilder().name("D").shortName('D').optionType(OptionType.GROUP).type(String.class).valueSeparator('=').description("Defines system properties to set").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_INSTALLER_CONFIG).optionType(OptionType.NORMAL).type(String.class).description("Installer .properties configuration file").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_ENCRYPTION_KEY).optionType(OptionType.NORMAL).type(String.class).addDefaultValue("").description("If specified, this is used to decode the properties that were encrypted. If you do not provide a value with the option, you will be prompted for one.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_ENCRYPTION_SALT).optionType(OptionType.NORMAL).type(String.class).addDefaultValue("").description("The salt used for generating the key. Recommended, if encryption is used. If not specified, the same value as the key will be used.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_ENABLED).optionType(OptionType.NORMAL).type(String.class).description("Indicates if the agent should be enabled at startup").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_CONFIG_ONLY).optionType(OptionType.BOOLEAN).type(Boolean.class).description("Skip installation of the add-ons modules, and only update the server config (e.g. standalone.xml).").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_TARGET_LOCATION).optionType(OptionType.NORMAL).type(String.class).description("Target home directory of the application server where the agent is to be installed").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_MODULE_DISTRIBUTION).optionType(OptionType.NORMAL).type(String.class).description("Hawkular WildFly Agent Module distribution zip file - can be a file path or URL").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_SERVER_URL).optionType(OptionType.NORMAL).type(String.class).description("Server URL where the agent will send its monitoring data. This is a string to be set as the storage adapter URL.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_DOWNLOAD_SERVER_URL).optionType(OptionType.NORMAL).type(String.class).description("Server URL from which the installer will download content it may need. If not specified and the installer needs to download something then --server-url will be used.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_TARGET_CONFIG).optionType(OptionType.NORMAL).type(String.class).description("The target configuration file to write to. Can be either absolute path or relative to target-location").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_SUBSYSTEM_SNIPPET).optionType(OptionType.NORMAL).type(String.class).description("Customized subsystem XML content that overrides the default subsystem configuration").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_MANAGED_SERVER_NAME).optionType(OptionType.NORMAL).type(String.class).description("The agent will use this name to refer to the server where it is deployed and locally managing.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_FEED_ID).optionType(OptionType.NORMAL).type(String.class).description("The feed ID that the agent will use to identify its data.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_TENANT_ID).optionType(OptionType.NORMAL).type(String.class).description("The tenant ID that the agent will ask to be used. Usually only used when in metrics-only mode.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_METRICS_ONLY_MODE).optionType(OptionType.NORMAL).type(String.class).description("If true, the agent will be configured to run in metrics-only mode (inventory will not be stored and no websocket connection to a Hawkular Server will be made.) If true, you must specify a tenant-id.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_MANAGED_RESOURCE_TYPE_SETS).optionType(OptionType.NORMAL).type(String.class).description("If true, the agent will be configured to monitor these resource type sets. If not provided, a default set will be used based on the type of application server where the agent is being installed into (standalone or domain).").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_KEYSTORE_PATH).optionType(OptionType.NORMAL).type(String.class).description("Keystore file. Required when server-url protocol is https").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_KEYSTORE_PASSWORD).optionType(OptionType.NORMAL).type(String.class).description("Keystore password. When server-url protocol is https and this option is not passed, installer will ask for password").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_USERNAME).optionType(OptionType.NORMAL).type(String.class).description("User the agent will use when connecting to Hawkular Server.").create());
        cmd.addOption(new ProcessedOptionBuilder().name(OPTION_PASSWORD).optionType(OptionType.NORMAL).type(String.class).description("Credentials agent will use when connecting to Hawkular Server.").create());
        return cmd.create();
    }

    public InstallerConfiguration(CommandLine<?> commandLine) throws Exception {
        if (commandLine.getParserException() != null) {
            throw commandLine.getParserException();
        }
        this.properties = new Properties();
        Map<String, String> sysprops = commandLine.getOptionProperties("D");
        for (Map.Entry<String, String> sysprop : sysprops.entrySet()) {
            System.setProperty(sysprop.getKey(), sysprop.getValue());
        }
        String installerConfig = commandLine.getOptionValue(OPTION_INSTALLER_CONFIG, "classpath:/hawkular-wildfly-agent-installer.properties");
        log.debug("Installer configuration file: " + installerConfig);
        if (installerConfig.startsWith("classpath:")) {
            if (!(installerConfig = installerConfig.substring(10)).startsWith("/")) {
                installerConfig = "/" + installerConfig;
            }
            this.properties.load(InstallerConfiguration.class.getResourceAsStream(installerConfig));
        } else {
            if (installerConfig.matches("(http|https|file):.*")) {
                URL installerConfigUrl = new URL(installerConfig);
                try (InputStream is = installerConfigUrl.openStream();){
                    this.properties.load(is);
                }
            }
            File installerConfigFile = new File(installerConfig);
            try (FileInputStream fis = new FileInputStream(installerConfigFile);){
                this.properties.load(fis);
            }
        }
        this.setProperty(this.properties, commandLine, OPTION_ENABLED);
        this.setProperty(this.properties, commandLine, OPTION_CONFIG_ONLY);
        this.setProperty(this.properties, commandLine, OPTION_TARGET_LOCATION);
        this.setProperty(this.properties, commandLine, OPTION_MODULE_DISTRIBUTION);
        this.setProperty(this.properties, commandLine, OPTION_TARGET_CONFIG);
        this.setProperty(this.properties, commandLine, OPTION_SUBSYSTEM_SNIPPET);
        this.setProperty(this.properties, commandLine, OPTION_MANAGED_SERVER_NAME);
        this.setProperty(this.properties, commandLine, OPTION_FEED_ID);
        this.setProperty(this.properties, commandLine, OPTION_TENANT_ID);
        this.setProperty(this.properties, commandLine, OPTION_METRICS_ONLY_MODE);
        this.setProperty(this.properties, commandLine, OPTION_SERVER_URL);
        this.setProperty(this.properties, commandLine, OPTION_DOWNLOAD_SERVER_URL);
        this.setProperty(this.properties, commandLine, OPTION_KEYSTORE_PATH);
        this.setProperty(this.properties, commandLine, OPTION_KEYSTORE_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_USERNAME);
        this.setProperty(this.properties, commandLine, OPTION_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_MANAGED_RESOURCE_TYPE_SETS);
    }

    private void setProperty(Properties props, CommandLine<?> commandLine, String option) {
        String value = commandLine.getOptionValue(option);
        if (value != null) {
            this.properties.setProperty(option, value);
        }
    }

    public void decodeProperties(String encryptionKey, byte[] salt) throws Exception {
        this.decodeProperty(this.properties, OPTION_KEYSTORE_PASSWORD, encryptionKey, salt);
        this.decodeProperty(this.properties, OPTION_PASSWORD, encryptionKey, salt);
    }

    private void decodeProperty(Properties prop, String option, String key, byte[] salt) throws Exception {
        String value = this.properties.getProperty(option, null);
        if (value != null) {
            value = EncoderDecoder.decode(value, key, salt);
            this.properties.setProperty(option, value);
        }
    }

    public String getInstallerConfig() {
        return this.properties.getProperty(OPTION_INSTALLER_CONFIG);
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(OPTION_ENABLED, "true"));
    }

    public boolean isConfigOnly() {
        return Boolean.parseBoolean(this.properties.getProperty(OPTION_CONFIG_ONLY, "false"));
    }

    public String getTargetLocation() {
        return this.properties.getProperty(OPTION_TARGET_LOCATION);
    }

    public String getModuleDistribution() {
        return this.properties.getProperty(OPTION_MODULE_DISTRIBUTION);
    }

    public String getTargetConfig() {
        return this.properties.getProperty(OPTION_TARGET_CONFIG);
    }

    public String getSubsystemSnippet() {
        return this.properties.getProperty(OPTION_SUBSYSTEM_SNIPPET);
    }

    public String getServerUrl() {
        return this.properties.getProperty(OPTION_SERVER_URL);
    }

    public String getDownloadServerUrl() {
        String url = this.properties.getProperty(OPTION_DOWNLOAD_SERVER_URL);
        return url != null ? url : this.getServerUrl();
    }

    public String getKeystorePath() {
        return this.properties.getProperty(OPTION_KEYSTORE_PATH);
    }

    public String getKeystorePassword() {
        return this.properties.getProperty(OPTION_KEYSTORE_PASSWORD);
    }

    public String getUsername() {
        return this.properties.getProperty(OPTION_USERNAME);
    }

    public String getPassword() {
        return this.properties.getProperty(OPTION_PASSWORD);
    }

    public String getManagedServerName() {
        return this.properties.getProperty(OPTION_MANAGED_SERVER_NAME);
    }

    public String getFeedId() {
        return this.properties.getProperty(OPTION_FEED_ID);
    }

    public String getTenantId() {
        return this.properties.getProperty(OPTION_TENANT_ID);
    }

    public boolean isMetricsOnlyMode() {
        return Boolean.parseBoolean(this.properties.getProperty(OPTION_METRICS_ONLY_MODE, "false"));
    }

    public String getManagedResourceTypeSets() {
        return this.properties.getProperty(OPTION_MANAGED_RESOURCE_TYPE_SETS);
    }
}

