/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.accesscontrol.BaseAccessRequirement;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.parsing.ParserUtil;

public abstract class AddressAccessRequirement
extends BaseAccessRequirement {
    protected final OperationRequestAddress address;

    AddressAccessRequirement() {
        this.address = new DefaultOperationRequestAddress();
    }

    AddressAccessRequirement(String address) {
        this.address = new DefaultOperationRequestAddress();
        if (address != null) {
            DefaultCallbackHandler handler = new DefaultCallbackHandler(this.address);
            try {
                ParserUtil.parseOperationRequest(address, handler);
            }
            catch (CommandFormatException e) {
                throw new IllegalArgumentException("Failed to parse path '" + address + "': " + e.getMessage());
            }
        }
    }

    AddressAccessRequirement(OperationRequestAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        this.address = address;
    }

    protected OperationRequestAddress getAddress() {
        return this.address;
    }
}

