/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecUtils;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Either;
import org.infinispan.commons.util.Util;

public class Codec10
implements Codec {
    private static final Log log = LogFactory.getLog(Codec10.class, Log.class);
    protected final boolean trace = this.getLog().isTraceEnabled();
    static final AtomicLong MSG_ID = new AtomicLong();

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)10);
    }

    @Override
    public void writeClientListenerParams(Transport transport, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
    }

    @Override
    public void writeExpirationParams(Transport transport, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        if (!CodecUtils.isIntCompatible(lifespan)) {
            this.getLog().warn("Lifespan value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        if (!CodecUtils.isIntCompatible(maxIdle)) {
            this.getLog().warn("MaxIdle value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        transport.writeVInt(lifespanSeconds);
        transport.writeVInt(maxIdleSeconds);
    }

    protected HeaderParams writeHeader(Transport transport, HeaderParams params, byte version) {
        transport.writeByte((short)160);
        transport.writeVLong(params.messageId((long)Codec10.MSG_ID.incrementAndGet()).messageId);
        transport.writeByte(version);
        transport.writeByte(params.opCode);
        transport.writeArray(params.cacheName);
        int flagInt = params.flags & Flag.FORCE_RETURN_VALUE.getFlagInt();
        transport.writeVInt(flagInt);
        transport.writeByte(params.clientIntel);
        transport.writeVInt(params.topologyId.get());
        transport.writeByte(params.txMarker);
        if (this.trace) {
            this.getLog().tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", params.messageId, params.opCode, flagInt);
        }
        return params;
    }

    @Override
    public short readHeader(Transport transport, HeaderParams params) {
        short magic = transport.readByte();
        Log localLog = this.getLog();
        if (magic != 161) {
            String message = "Invalid magic number. Expected %#x and received %#x";
            localLog.invalidMagicNumber((short)161, magic);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        long receivedMessageId = transport.readVLong();
        if (receivedMessageId != params.messageId && receivedMessageId != 0L) {
            String message = "Invalid message id. Expected %d and received %d";
            localLog.invalidMessageId(params.messageId, receivedMessageId);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, params.messageId, receivedMessageId));
        }
        if (this.trace) {
            localLog.tracef("Received response for message id: %d", receivedMessageId);
        }
        short receivedOpCode = transport.readByte();
        short status = transport.readByte();
        this.readNewTopologyIfPresent(transport, params);
        if (receivedOpCode != params.opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport, params, status);
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", params.opRespCode, receivedOpCode));
        }
        if (this.trace) {
            localLog.tracef("Received operation code is: %#04x", receivedOpCode);
        }
        return status;
    }

    @Override
    public ClientEvent readEvent(Transport transport, byte[] expectedListenerId, Marshaller marshaller) {
        return null;
    }

    @Override
    public Either<Short, ClientEvent> readHeaderOrEvent(Transport transport, HeaderParams params, byte[] expectedListenerId, Marshaller marshaller) {
        return null;
    }

    @Override
    public Object returnPossiblePrevValue(Transport transport, short status, int flags) {
        Marshaller marshaller = transport.getTransportFactory().getMarshaller();
        if (this.hasForceReturn(flags)) {
            byte[] bytes = transport.readArray();
            if (this.trace) {
                this.getLog().tracef("Previous value bytes is: %s", Util.printArray((byte[])bytes, (boolean)false));
            }
            return bytes.length == 0 ? null : MarshallerUtil.bytes2obj(marshaller, bytes, status);
        }
        return null;
    }

    private boolean hasForceReturn(int flags) {
        return (flags & Flag.FORCE_RETURN_VALUE.getFlagInt()) != 0;
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public <T> T readUnmarshallByteArray(Transport transport, short status) {
        return CodecUtils.readUnmarshallByteArray(transport, status);
    }

    protected void checkForErrorsInResponseStatus(Transport transport, HeaderParams params, short status) {
        Log localLog = this.getLog();
        if (this.trace) {
            localLog.tracef("Received operation status: %#x", status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = transport.readString();
                    if (status == 134 && this.trace) {
                        localLog.tracef("Server-side timeout performing operation: %s", msgFromServer);
                    }
                    if (msgFromServer.contains("SuspectException") || msgFromServer.contains("SuspectedException")) {
                        if (this.trace) {
                            localLog.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", params.messageId, msgFromServer);
                        }
                        throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                    }
                    localLog.errorFromServer(msgFromServer);
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    transport.invalidate();
                }
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(Transport transport, HeaderParams params) {
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, params.topologyId, params.cacheName);
        }
    }

    protected void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId, byte[] cacheName) {
        Log localLog = this.getLog();
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int numKeyOwners = transport.readUnsignedShort();
        short hashFunctionVersion = transport.readByte();
        int hashSpace = transport.readVInt();
        int clusterSize = transport.readVInt();
        Map<SocketAddress, Set<Integer>> servers2Hash = this.computeNewHashes(transport, localLog, newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize);
        Set<SocketAddress> socketAddresses = servers2Hash.keySet();
        int topologyAge = transport.getTransportFactory().getTopologyAge();
        if (localLog.isInfoEnabled()) {
            localLog.newTopology(transport.getRemoteSocketAddress(), newTopologyId, topologyAge, socketAddresses.size(), socketAddresses);
        }
        transport.getTransportFactory().updateServers(socketAddresses, cacheName, false);
        if (hashFunctionVersion == 0) {
            localLog.trace("Not using a consistent hash function (hash function version == 0).");
        } else {
            transport.getTransportFactory().updateHashFunction(servers2Hash, numKeyOwners, hashFunctionVersion, hashSpace, cacheName, topologyId);
        }
    }

    protected Map<SocketAddress, Set<Integer>> computeNewHashes(Transport transport, Log localLog, int newTopologyId, int numKeyOwners, short hashFunctionVersion, int hashSpace, int clusterSize) {
        if (this.trace) {
            localLog.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d", new Object[]{newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize});
        }
        LinkedHashMap<SocketAddress, Set<Integer>> servers2Hash = new LinkedHashMap<SocketAddress, Set<Integer>>();
        for (int i = 0; i < clusterSize; ++i) {
            InetSocketAddress address;
            HashSet<Integer> hashes;
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            int hashCode = transport.read4ByteInt();
            if (this.trace) {
                localLog.tracef("Server read: %s:%d - hash code is %d", host, port, hashCode);
            }
            if ((hashes = (HashSet<Integer>)servers2Hash.get(address = new InetSocketAddress(host, port))) == null) {
                hashes = new HashSet<Integer>();
                servers2Hash.put(address, hashes);
            }
            hashes.add(hashCode);
            if (!this.trace) continue;
            localLog.tracef("Hash code is: %d", hashCode);
        }
        return servers2Hash;
    }
}

