/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.wildfly.extension.undertow.Handler;
import org.wildfly.extension.undertow.UndertowExtension;

public abstract class AbstractHandlerDefinition
extends PersistentResourceDefinition
implements Handler {
    private static final List<AccessConstraintDefinition> CONSTRAINTS = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("undertow", "undertow-filter", false, false, false)).wrapAsList();
    protected final String name;

    protected AbstractHandlerDefinition(String name, AbstractAddStepHandler addHandler, AbstractRemoveStepHandler removeHandler) {
        this(name, "handler", addHandler, removeHandler);
    }

    protected AbstractHandlerDefinition(String name) {
        this(name, "handler");
    }

    protected AbstractHandlerDefinition(String name, String prefix, AbstractAddStepHandler addHandler, AbstractRemoveStepHandler removeHandler) {
        super(PathElement.pathElement((String)name), (ResourceDescriptionResolver)UndertowExtension.getResolver(prefix, name), (OperationStepHandler)addHandler, (OperationStepHandler)removeHandler);
        this.name = name;
    }

    protected AbstractHandlerDefinition(String name, String prefix) {
        super(PathElement.pathElement((String)name), (ResourceDescriptionResolver)UndertowExtension.getResolver(prefix, name));
        this.name = name;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (resourceRegistration.getOperationEntry(PathAddress.EMPTY_ADDRESS, "add") == null) {
            this.registerAddOperation(resourceRegistration, new AbstractAddStepHandler(this.getAttributes()), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        }
        if (resourceRegistration.getOperationEntry(PathAddress.EMPTY_ADDRESS, "remove") == null) {
            this.registerRemoveOperation(resourceRegistration, new DefaultHandlerRemove(), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        }
    }

    @Override
    public Class<? extends HttpHandler> getHandlerClass() {
        return null;
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return CONSTRAINTS;
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptyList();
    }

    @Override
    public String getXmlElementName() {
        return this.name;
    }

    protected static class DefaultHandlerRemove
    extends AbstractRemoveStepHandler {
        private DefaultHandlerRemove() {
        }
    }
}

