/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class InterceptorChain {
    private static final Log log = LogFactory.getLog(InterceptorChain.class);
    private volatile CommandInterceptor firstInChain;
    final ReentrantLock lock = new ReentrantLock();
    final ComponentMetadataRepo componentMetadataRepo;

    public InterceptorChain(ComponentMetadataRepo componentMetadataRepo) {
        this.componentMetadataRepo = componentMetadataRepo;
    }

    @Start
    private void printChainInfo() {
        if (log.isDebugEnabled()) {
            log.debugf("Interceptor chain size: %d", this.size());
            log.debugf("Interceptor chain is: %s", this.toString());
        }
    }

    private void validateCustomInterceptor(Class<? extends CommandInterceptor> i) {
        if (!(ReflectionUtil.getAllMethodsShallow(i, Inject.class).isEmpty() && ReflectionUtil.getAllMethodsShallow(i, Start.class).isEmpty() && ReflectionUtil.getAllMethodsShallow(i, Stop.class).isEmpty() || this.componentMetadataRepo.findComponentMetadata(i.getName()) != null)) {
            log.customInterceptorExpectsInjection(i.getName());
        }
    }

    private void assertNotAdded(Class<? extends CommandInterceptor> clazz) {
        if (this.containsInterceptorType(clazz)) {
            throw new CacheConfigurationException("Detected interceptor of type [" + clazz.getName() + "] being added to the interceptor chain " + System.identityHashCode(this) + " more than once!");
        }
    }

    public void addInterceptor(CommandInterceptor interceptor, int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = interceptor.getClass();
            this.assertNotAdded(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            if (position == 0) {
                interceptor.setNext(this.firstInChain);
                this.firstInChain = interceptor;
                return;
            }
            if (this.firstInChain == null) {
                return;
            }
            int index = 0;
            for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
                if (++index != position) continue;
                interceptor.setNext(it.getNext());
                it.setNext(interceptor);
                return;
            }
            throw new IllegalArgumentException("Invalid index: " + index + " !");
        }
        finally {
            lock.unlock();
        }
    }

    public void removeInterceptor(int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.firstInChain == null) {
                return;
            }
            if (position == 0) {
                this.firstInChain = this.firstInChain.getNext();
                return;
            }
            int index = 0;
            for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
                if (++index != position) continue;
                if (it.getNext() == null) {
                    return;
                }
                it.setNext(it.getNext().getNext());
                return;
            }
            throw new IllegalArgumentException("Invalid position: " + position + " !");
        }
        finally {
            lock.unlock();
        }
    }

    public int size() {
        int size = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            ++size;
        }
        return size;
    }

    public List<CommandInterceptor> asList() {
        if (this.firstInChain == null) {
            return InfinispanCollections.emptyList();
        }
        LinkedList<CommandInterceptor> retval = new LinkedList<CommandInterceptor>();
        CommandInterceptor tmp = this.firstInChain;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return Collections.unmodifiableList(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterceptor(Class<? extends CommandInterceptor> clazz) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.isFirstInChain(clazz)) {
                this.firstInChain = this.firstInChain.getNext();
            }
            CommandInterceptor prevIt = this.firstInChain;
            for (CommandInterceptor it = this.firstInChain.getNext(); it != null; it = it.getNext()) {
                if (it.getClass() == clazz) {
                    prevIt.setNext(it.getNext());
                }
                prevIt = it;
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean isFirstInChain(Class<? extends CommandInterceptor> clazz) {
        return this.firstInChain.getClass() == clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInterceptorAfter(CommandInterceptor toAdd, Class<? extends CommandInterceptor> afterInterceptor) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.assertNotAdded(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
                if (!it.getClass().equals(afterInterceptor)) continue;
                toAdd.setNext(it.getNext());
                it.setNext(toAdd);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    public boolean addInterceptorBefore(CommandInterceptor toAdd, Class<? extends CommandInterceptor> beforeInterceptor, boolean isCustom) {
        if (isCustom) {
            this.validateCustomInterceptor(toAdd.getClass());
        }
        return this.addInterceptorBefore(toAdd, beforeInterceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInterceptorBefore(CommandInterceptor toAdd, Class<? extends CommandInterceptor> beforeInterceptor) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.assertNotAdded(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            if (this.firstInChain.getClass().equals(beforeInterceptor)) {
                toAdd.setNext(this.firstInChain);
                this.firstInChain = toAdd;
                boolean bl = true;
                return bl;
            }
            CommandInterceptor it = this.firstInChain;
            while (it.getNext() != null) {
                if (it.getNext().getClass().equals(beforeInterceptor)) {
                    toAdd.setNext(it.getNext());
                    it.setNext(toAdd);
                    boolean bl = true;
                    return bl;
                }
                it = it.getNext();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceInterceptor(CommandInterceptor replacingInterceptor, Class<? extends CommandInterceptor> toBeReplacedInterceptorType) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = replacingInterceptor.getClass();
            this.assertNotAdded(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            if (this.firstInChain.getClass().equals(toBeReplacedInterceptorType)) {
                replacingInterceptor.setNext(this.firstInChain.getNext());
                this.firstInChain = replacingInterceptor;
                boolean bl = true;
                return bl;
            }
            CommandInterceptor it = this.firstInChain;
            CommandInterceptor previous = this.firstInChain;
            while (it.getNext() != null) {
                CommandInterceptor current = it.getNext();
                if (current.getClass().equals(toBeReplacedInterceptorType)) {
                    replacingInterceptor.setNext(current.getNext());
                    previous.setNext(replacingInterceptor);
                    boolean bl = true;
                    return bl;
                }
                previous = current;
                it = current;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void appendInterceptor(CommandInterceptor ci, boolean isCustom) {
        Class<?> interceptorClass = ci.getClass();
        if (isCustom) {
            this.validateCustomInterceptor(interceptorClass);
        }
        this.assertNotAdded(interceptorClass);
        if (this.firstInChain == null) {
            this.firstInChain = ci;
        } else {
            CommandInterceptor it = this.firstInChain;
            while (it.hasNext()) {
                it = it.getNext();
            }
            it.setNext(ci);
        }
        ci.setNext(null);
    }

    public Object invoke(InvocationContext ctx, VisitableCommand command) {
        try {
            return command.acceptVisitor(ctx, this.firstInChain);
        }
        catch (CacheException e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public CommandInterceptor getFirstInChain() {
        return this.firstInChain;
    }

    public void setFirstInChain(CommandInterceptor interceptor) {
        this.firstInChain = interceptor;
    }

    public List<CommandInterceptor> getInterceptorsWhichExtend(Class<? extends CommandInterceptor> interceptorClass) {
        LinkedList<CommandInterceptor> result = new LinkedList<CommandInterceptor>();
        for (CommandInterceptor interceptor : this.asList()) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            result.add(interceptor);
        }
        return result;
    }

    public List<CommandInterceptor> getInterceptorsWithClass(Class clazz) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>(2);
        for (CommandInterceptor iterator = this.firstInChain; iterator != null; iterator = iterator.getNext()) {
            if (iterator.getClass() != clazz) continue;
            result.add(iterator);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CommandInterceptor i = this.firstInChain; i != null; i = i.getNext()) {
            sb.append("\n\t>> ");
            sb.append(i.getClass().getName());
        }
        return sb.toString();
    }

    public boolean containsInstance(CommandInterceptor interceptor) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (it != interceptor) continue;
            return true;
        }
        return false;
    }

    public boolean containsInterceptorType(Class<? extends CommandInterceptor> interceptorType) {
        return this.containsInterceptorType(interceptorType, false);
    }

    public boolean containsInterceptorType(Class<? extends CommandInterceptor> interceptorType, boolean alsoMatchSubClasses) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (!(alsoMatchSubClasses ? interceptorType.isAssignableFrom(it.getClass()) : it.getClass().equals(interceptorType))) continue;
            return true;
        }
        return false;
    }
}

