/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.FieldCacheType;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.EntitySpatialMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.IndexedClassBridgeMapping;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.ProvidedIdMapping;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;

public class IndexedMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final Map<String, Object> indexed;

    public IndexedMapping(SearchMapping mapping, EntityDescriptor entity) {
        this.mapping = mapping;
        this.entity = entity;
        this.indexed = new HashMap<String, Object>();
        entity.setIndexed(this.indexed);
    }

    public IndexedMapping indexName(String indexName) {
        this.indexed.put("index", indexName);
        return this;
    }

    public IndexedMapping interceptor(Class<? extends EntityIndexingInterceptor> interceptor) {
        this.indexed.put("interceptor", interceptor);
        return this;
    }

    @Deprecated
    public IndexedMapping cacheFromIndex(FieldCacheType ... type) {
        return this;
    }

    public IndexedMapping boost(float boost) {
        HashMap<String, Object> boostAnn = new HashMap<String, Object>();
        boostAnn.put("value", Float.valueOf(boost));
        this.entity.setBoost(boostAnn);
        return this;
    }

    public IndexedMapping dynamicBoost(Class<? extends BoostStrategy> impl) {
        HashMap<String, Object> dynamicBoost = new HashMap<String, Object>();
        dynamicBoost.put("impl", impl);
        this.entity.setDynamicBoost(dynamicBoost);
        return this;
    }

    public IndexedMapping analyzerDiscriminator(Class<? extends Discriminator> discriminator) {
        HashMap<String, Object> discriminatorAnn = new HashMap<String, Object>();
        discriminatorAnn.put("impl", discriminator);
        this.entity.setAnalyzerDiscriminator(discriminatorAnn);
        return this;
    }

    public IndexedClassBridgeMapping classBridge(Class<?> impl) {
        return new IndexedClassBridgeMapping(this.mapping, this.entity, impl, this);
    }

    public IndexedClassBridgeMapping classBridgeInstance(FieldBridge instance) {
        return new IndexedClassBridgeMapping(this.mapping, this.entity, instance, this);
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.mapping, name, impl);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public ProvidedIdMapping providedId() {
        return new ProvidedIdMapping(this.mapping, this.entity);
    }

    public EntitySpatialMapping spatial() {
        return new EntitySpatialMapping(this.mapping, this.entity);
    }
}

