/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialException;

public class SerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -1662519690087375313L;

    public SerialClob(char[] ch) throws SerialException, SQLException {
        this.len = ch.length;
        this.buf = new char[(int)this.len];
        int i = 0;
        while ((long)i < this.len) {
            this.buf[i] = ch[i];
            ++i;
        }
        this.origLen = this.len;
        this.clob = null;
    }

    public SerialClob(Clob clob) throws SerialException, SQLException {
        if (clob == null) {
            throw new SQLException("Cannot instantiate a SerialClob object with a null Clob object");
        }
        this.len = clob.length();
        this.clob = clob;
        this.buf = new char[(int)this.len];
        int read = 0;
        int offset = 0;
        try (Reader charStream = clob.getCharacterStream();){
            if (charStream == null) {
                throw new SQLException("Invalid Clob object. The call to getCharacterStream returned null which cannot be serialized.");
            }
            try (InputStream asciiStream = clob.getAsciiStream();){
                if (asciiStream == null) {
                    throw new SQLException("Invalid Clob object. The call to getAsciiStream returned null which cannot be serialized.");
                }
            }
            var7_10 = null;
            try (BufferedReader reader = new BufferedReader(charStream);){
                do {
                    read = ((Reader)reader).read(this.buf, offset, (int)(this.len - (long)offset));
                    offset += read;
                } while (read > 0);
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new SerialException("SerialClob: " + ex.getMessage());
        }
        this.origLen = this.len;
    }

    @Override
    public long length() throws SerialException {
        this.isValid();
        return this.len;
    }

    @Override
    public Reader getCharacterStream() throws SerialException {
        this.isValid();
        return new CharArrayReader(this.buf);
    }

    @Override
    public InputStream getAsciiStream() throws SerialException, SQLException {
        this.isValid();
        if (this.clob != null) {
            return this.clob.getAsciiStream();
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a the CLOB value as an ascii stream, unless instantiated with a fully implemented Clob object.");
    }

    @Override
    public String getSubString(long pos, int length) throws SerialException {
        this.isValid();
        if (pos < 1L || pos > this.length()) {
            throw new SerialException("Invalid position in SerialClob object set");
        }
        if (pos - 1L + (long)length > this.length()) {
            throw new SerialException("Invalid position and substring length");
        }
        try {
            return new String(this.buf, (int)pos - 1, length);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SerialException("StringIndexOutOfBoundsException: " + e.getMessage());
        }
    }

    @Override
    public long position(String searchStr, long start) throws SerialException, SQLException {
        this.isValid();
        if (start < 1L || start > this.len) {
            return -1L;
        }
        char[] pattern = searchStr.toCharArray();
        int pos = (int)start - 1;
        int i = 0;
        long patlen = pattern.length;
        while ((long)pos < this.len) {
            if (pattern[i] == this.buf[pos]) {
                if ((long)(i + 1) == patlen) {
                    return (long)(pos + 1) - (patlen - 1L);
                }
                ++i;
                ++pos;
                continue;
            }
            if (pattern[i] == this.buf[pos]) continue;
            ++pos;
        }
        return -1L;
    }

    @Override
    public long position(Clob searchStr, long start) throws SerialException, SQLException {
        this.isValid();
        return this.position(searchStr.getSubString(1L, (int)searchStr.length()), start);
    }

    @Override
    public int setString(long pos, String str) throws SerialException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int length) throws SerialException {
        int i;
        this.isValid();
        String temp = str.substring(offset);
        char[] cPattern = temp.toCharArray();
        if (offset < 0 || offset > str.length()) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (pos < 1L || pos > this.length()) {
            throw new SerialException("Invalid position in Clob object set");
        }
        if ((long)length > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (length + offset > str.length()) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset  and length that is greater that the Blob buffer");
        }
        --pos;
        for (i = 0; i < length || offset + i + 1 < str.length() - offset; ++i) {
            this.buf[(int)pos + i] = cPattern[offset + i];
        }
        return i;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SerialException, SQLException {
        this.isValid();
        if (this.clob != null) {
            return this.clob.setAsciiStream(pos);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable ascii stream\n unless instantiated with a Clob object that has a setAsciiStream() implementation");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SerialException, SQLException {
        this.isValid();
        if (this.clob != null) {
            return this.clob.setCharacterStream(pos);
        }
        throw new SerialException("Unsupported operation. SerialClob cannot return a writable character stream\n unless instantiated with a Clob object that has a setCharacterStream implementation");
    }

    @Override
    public void truncate(long length) throws SerialException {
        this.isValid();
        if (length > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        this.len = length;
        this.buf = this.len == 0L ? new char[0] : this.getSubString(1L, (int)this.len).toCharArray();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.isValid();
        if (pos < 1L || pos > this.len) {
            throw new SerialException("Invalid position in Clob object set");
        }
        if (pos - 1L + length > this.len) {
            throw new SerialException("Invalid position and substring length");
        }
        if (length <= 0L) {
            throw new SerialException("Invalid length specified");
        }
        return new CharArrayReader(this.buf, (int)pos, (int)length);
    }

    @Override
    public void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
            if (this.clob != null) {
                this.clob.free();
            }
            this.clob = null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SerialClob) {
            SerialClob sc = (SerialClob)obj;
            if (this.len == sc.len) {
                return Arrays.equals(this.buf, sc.buf);
            }
        }
        return false;
    }

    public int hashCode() {
        return ((31 + Arrays.hashCode(this.buf)) * 31 + (int)this.len) * 31 + (int)this.origLen;
    }

    public Object clone() {
        try {
            SerialClob sc = (SerialClob)super.clone();
            sc.buf = this.buf != null ? Arrays.copyOf(this.buf, (int)this.len) : null;
            sc.clob = null;
            return sc;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        char[] tmp = (char[])fields.get("buf", null);
        if (tmp == null) {
            throw new InvalidObjectException("buf is null and should not be!");
        }
        this.buf = (char[])tmp.clone();
        this.len = fields.get("len", 0L);
        if ((long)this.buf.length != this.len) {
            throw new InvalidObjectException("buf is not the expected size");
        }
        this.origLen = fields.get("origLen", 0L);
        this.clob = (Clob)fields.get("clob", null);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("buf", this.buf);
        fields.put("len", this.len);
        fields.put("origLen", this.origLen);
        fields.put("clob", this.clob instanceof Serializable ? this.clob : null);
        s.writeFields();
    }

    private void isValid() throws SerialException {
        if (this.buf == null) {
            throw new SerialException("Error: You cannot call a method on a SerialClob instance once free() has been called.");
        }
    }
}

