/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAMLAssertionParser;
import org.picketlink.identity.federation.core.parsers.saml.SAMLStatusResponseTypeParser;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Element;

public class SAMLResponseParser
extends SAMLStatusResponseTypeParser
implements ParserNamespaceSupport {
    private final String RESPONSE = JBossSAMLConstants.RESPONSE.get();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)this.RESPONSE);
        ResponseType response = (ResponseType)this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.ISSUER.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                NameIDType issuer = new NameIDType();
                issuer.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                response.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                Element sig = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                response.setSignature(sig);
                continue;
            }
            if (JBossSAMLConstants.ASSERTION.get().equals(elementName)) {
                SAMLAssertionParser assertionParser = new SAMLAssertionParser();
                response.addAssertion(new ResponseType.RTChoiceType((AssertionType)assertionParser.parse(xmlEventReader)));
                continue;
            }
            if (JBossSAMLConstants.STATUS.get().equals(elementName)) {
                response.setStatus(this.parseStatus(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ENCRYPTED_ASSERTION.get().equals(elementName)) {
                Element encryptedAssertion = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                response.addAssertion(new ResponseType.RTChoiceType(new EncryptedAssertionType(encryptedAssertion)));
                continue;
            }
            throw logger.parserUnknownTag(elementName, startElement.getLocation());
        }
        return response;
    }

    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI()) && this.RESPONSE.equals(qname.getLocalPart());
    }

    @Override
    protected StatusResponseType parseBaseAttributes(StartElement startElement) throws ParsingException {
        ResponseType response = new ResponseType(super.parseBaseAttributes(startElement));
        return response;
    }
}

