/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.converter;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aesh.cl.converter.BooleanConverter;
import org.jboss.aesh.cl.converter.ByteConverter;
import org.jboss.aesh.cl.converter.CharacterConverter;
import org.jboss.aesh.cl.converter.Converter;
import org.jboss.aesh.cl.converter.DoubleConverter;
import org.jboss.aesh.cl.converter.FileConverter;
import org.jboss.aesh.cl.converter.FileResourceConverter;
import org.jboss.aesh.cl.converter.FloatConverter;
import org.jboss.aesh.cl.converter.IntegerConverter;
import org.jboss.aesh.cl.converter.LongConverter;
import org.jboss.aesh.cl.converter.ShortConverter;
import org.jboss.aesh.cl.converter.StringConverter;
import org.jboss.aesh.io.Resource;

public class CLConverterManager {
    private Map<Class, Converter> converters;

    public static CLConverterManager getInstance() {
        return CLConvertManagerHolder.INSTANCE;
    }

    private CLConverterManager() {
        this.initMap();
    }

    private void initMap() {
        this.converters = new HashMap<Class, Converter>();
        this.converters.put(Integer.class, new IntegerConverter());
        this.converters.put(Integer.TYPE, this.converters.get(Integer.class));
        this.converters.put(Boolean.class, new BooleanConverter());
        this.converters.put(Boolean.TYPE, this.converters.get(Boolean.class));
        this.converters.put(Character.class, new CharacterConverter());
        this.converters.put(Character.TYPE, this.converters.get(Character.class));
        this.converters.put(Double.class, new DoubleConverter());
        this.converters.put(Double.TYPE, this.converters.get(Double.class));
        this.converters.put(Float.class, new FloatConverter());
        this.converters.put(Float.TYPE, this.converters.get(Float.class));
        this.converters.put(Long.class, new LongConverter());
        this.converters.put(Long.TYPE, this.converters.get(Long.class));
        this.converters.put(Short.class, new ShortConverter());
        this.converters.put(Short.TYPE, this.converters.get(Short.class));
        this.converters.put(Byte.class, new ByteConverter());
        this.converters.put(Byte.TYPE, this.converters.get(Byte.class));
        this.converters.put(String.class, new StringConverter());
        this.converters.put(File.class, new FileConverter());
        this.converters.put(Resource.class, new FileResourceConverter());
    }

    public boolean hasConverter(Class clazz) {
        return this.converters.containsKey(clazz);
    }

    public Converter getConverter(Class clazz) {
        return this.converters.get(clazz);
    }

    private static class CLConvertManagerHolder {
        static final CLConverterManager INSTANCE = new CLConverterManager();

        private CLConvertManagerHolder() {
        }
    }
}

