/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.GlobalConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.KeyAffinityServiceFactoryBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupAliasBuilderProvider;

public class CacheContainerServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathElement ejbPath;
        Resource rootResource;
        String name = context.getCurrentAddressValue();
        if (context.getProcessType().isServer() && !context.isBooting() && name.equals("ejb") && (rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS)).hasChild(ejbPath = PathElement.pathElement((String)"subsystem", (String)"ejb3")) && rootResource.getChild(ejbPath).hasChild(PathElement.pathElement((String)"service", (String)"remote"))) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            return;
        }
        ServiceTarget target = context.getServiceTarget();
        new GlobalConfigurationBuilder(name).configure(context, model).build(target).install();
        String defaultCache = ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.getDefinition().resolveModelAttribute(context, model));
        new CacheContainerBuilder(name).setDefaultCache(defaultCache).configure(context, model).build(target).install();
        new KeyAffinityServiceFactoryBuilder(name).build(target).install();
        String jndiName = ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.Attribute.JNDI_NAME.getDefinition().resolveModelAttribute(context, model));
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(InfinispanBindingFactory.createCacheContainerBinding(name), CacheContainerServiceName.CACHE_CONTAINER.getServiceName(name), CacheContainer.class);
        if (jndiName != null) {
            bindingBuilder.alias(ContextNames.bindInfoFor((String)JndiNameFactory.parse((String)jndiName).getAbsoluteName()));
        }
        bindingBuilder.build(target).install();
        if (defaultCache != null && !defaultCache.equals("default")) {
            for (CacheServiceName nameFactory : CacheServiceName.values()) {
                new AliasServiceBuilder(nameFactory.getServiceName(name), nameFactory.getServiceName(name, defaultCache), Object.class).build(target).install();
            }
            new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(name, "default"), CacheServiceName.CACHE.getServiceName(name), Cache.class).build(target).install();
            for (CacheGroupAliasBuilderProvider provider : ServiceLoader.load(CacheGroupAliasBuilderProvider.class, CacheGroupAliasBuilderProvider.class.getClassLoader())) {
                for (Builder builder : provider.getBuilders(name, "default", defaultCache)) {
                    builder.build(target).install();
                }
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        String defaultCache = ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.getDefinition().resolveModelAttribute(context, model));
        if (defaultCache != null && !defaultCache.equals("default")) {
            for (CacheGroupAliasBuilderProvider provider : ServiceLoader.load(CacheGroupAliasBuilderProvider.class, CacheGroupAliasBuilderProvider.class.getClassLoader())) {
                for (Builder builder : provider.getBuilders(name, "default", defaultCache)) {
                    context.removeService(builder.getServiceName());
                }
            }
            context.removeService(new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(name, "default"), CacheServiceName.CACHE.getServiceName(name), Cache.class).getServiceName());
            for (CacheServiceName nameFactory : CacheServiceName.values()) {
                context.removeService(nameFactory.getServiceName(name));
            }
        }
        context.removeService(InfinispanBindingFactory.createCacheContainerBinding(name).getBinderServiceName());
        for (CacheContainerServiceName factory : CacheContainerServiceName.values()) {
            context.removeService(factory.getServiceName(name));
        }
    }
}

