/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.interceptor.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bean.proxy.EnterpriseBeanInstance;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.SessionBeanInjectionPoint;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.ejb.SessionBeanProxyInstantiator;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.reflection.Formats;

public class SessionBean<T>
extends AbstractClassBean<T> {
    private final InternalEjbDescriptor<T> ejbDescriptor;
    private Instantiator<T> proxyInstantiator;

    public static <T> SessionBean<T> of(BeanAttributes<T> attributes, InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl beanManager, EnhancedAnnotatedType<T> type) {
        return new SessionBean<T>(attributes, type, ejbDescriptor, new StringBeanIdentifier(BeanIdentifiers.forSessionBean(type, ejbDescriptor)), beanManager);
    }

    protected SessionBean(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, InternalEjbDescriptor<T> ejbDescriptor, BeanIdentifier identifier, BeanManagerImpl manager) {
        super(attributes, type, identifier, manager);
        this.ejbDescriptor = ejbDescriptor;
        this.setProducer(this.beanManager.getLocalInjectionTargetFactory(type).createInjectionTarget(type, this, false));
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.checkEJBTypeAllowed();
        this.checkConflictingRoles();
        this.checkObserverMethods();
        this.checkScopeAllowed();
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw BeanLogger.LOG.ejbCannotBeInterceptor(this.getType());
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw BeanLogger.LOG.ejbCannotBeDecorator(this.getType());
        }
    }

    protected void checkScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.isDependent()) {
            throw BeanLogger.LOG.scopeNotAllowedOnStatelessSessionBean(this.getScope(), this.getType());
        }
        if (this.ejbDescriptor.isSingleton() && !this.isDependent() && !this.getScope().equals(ApplicationScoped.class)) {
            throw BeanLogger.LOG.scopeNotAllowedOnSingletonBean(this.getScope(), this.getType());
        }
    }

    @Override
    protected void specialize() {
        Set<AbstractBean<?, ?>> specializedBeans = this.getSpecializedBeans();
        if (specializedBeans.isEmpty()) {
            throw BeanLogger.LOG.specializingEnterpriseBeanMustExtendAnEnterpriseBean(this);
        }
        for (AbstractBean<?, ?> specializedBean : specializedBeans) {
            if (specializedBean instanceof SessionBean) continue;
            throw BeanLogger.LOG.specializingEnterpriseBeanMustExtendAnEnterpriseBean(this);
        }
    }

    public T create(CreationalContext<T> creationalContext) {
        return this.proxyInstantiator.newInstance(creationalContext, this.beanManager);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        super.destroy(instance, creationalContext);
        if (instance == null) {
            throw BeanLogger.LOG.cannotDestroyNullBean(this);
        }
        if (!(instance instanceof EnterpriseBeanInstance)) {
            throw BeanLogger.LOG.cannotDestroyEnterpriseBeanNotCreated(instance);
        }
        EnterpriseBeanInstance enterpriseBeanInstance = (EnterpriseBeanInstance)instance;
        enterpriseBeanInstance.destroy(Marker.INSTANCE, this, creationalContext);
        creationalContext.release();
    }

    private void checkEJBTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw BeanLogger.LOG.messageDrivenBeansCannotBeManaged(this);
        }
    }

    @Override
    protected void checkType() {
        if (!this.isDependent() && this.getEnhancedAnnotated().isGeneric()) {
            throw BeanLogger.LOG.genericSessionBeanMustBeDependent(this);
        }
        boolean passivating = ((MetaAnnotationStore)this.beanManager.getServices().get(MetaAnnotationStore.class)).getScopeModel(this.getScope()).isPassivating();
        if (passivating && !this.isPassivationCapableBean()) {
            throw BeanLogger.LOG.passivatingBeanNeedsSerializableImpl(this);
        }
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isClientCanCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    protected void checkObserverMethods() {
        Collection observerMethods = BeanMethods.getObserverMethods(this.getEnhancedAnnotated());
        if (!observerMethods.isEmpty()) {
            Set<MethodSignature> businessMethodSignatures = this.getBusinessMethodSignatures();
            for (EnhancedAnnotatedMethod observerMethod : observerMethods) {
                if (observerMethod.isStatic() || businessMethodSignatures.contains(observerMethod.getSignature())) continue;
                throw BeanLogger.LOG.observerMethodMustBeStaticOrBusiness(observerMethod, Formats.formatAsStackTraceElement(observerMethod.getJavaMember()));
            }
        }
    }

    protected Set<MethodSignature> getBusinessMethodSignatures() {
        HashSet<MethodSignatureImpl> businessMethodSignatures = new HashSet<MethodSignatureImpl>();
        for (BusinessInterfaceDescriptor businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
            for (Method m : businessInterfaceDescriptor.getInterface().getMethods()) {
                businessMethodSignatures.add(new MethodSignatureImpl(m));
            }
        }
        for (BusinessInterfaceDescriptor businessInterfaceDescriptor : this.ejbDescriptor.getRemoteBusinessInterfaces()) {
            for (Method m : businessInterfaceDescriptor.getInterface().getMethods()) {
                businessMethodSignatures.add(new MethodSignatureImpl(m));
            }
        }
        return Collections.unmodifiableSet(businessMethodSignatures);
    }

    public SessionObjectReference createReference() {
        try {
            SessionBeanInjectionPoint.registerContextualInstance(this.getEjbDescriptor());
            SessionObjectReference sessionObjectReference = ((EjbServices)this.beanManager.getServices().get(EjbServices.class)).resolveEjb(this.getEjbDescriptor().delegate());
            return sessionObjectReference;
        }
        finally {
            SessionBeanInjectionPoint.unregisterContextualInstance(this.getEjbDescriptor());
        }
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return true;
    }

    @Override
    public String toString() {
        return "Session bean [" + this.getBeanClass() + " with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]; local interfaces are [" + Formats.formatBusinessInterfaceDescriptors(this.getEjbDescriptor().getLocalBusinessInterfaces()) + "]";
    }

    @Override
    public boolean isProxyable() {
        return true;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.ejbDescriptor.isPassivationCapable();
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.ejbDescriptor.isStateful() && this.isPassivationCapableBean() || this.ejbDescriptor.isSingleton() || this.ejbDescriptor.isStateless();
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        this.proxyInstantiator = new SessionBeanProxyInstantiator(this.enhancedAnnotatedItem, this);
        this.registerInterceptors();
    }

    protected void registerInterceptors() {
        InterceptionModel model = (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.getAnnotated());
        if (model != null) {
            ((EjbServices)this.getBeanManager().getServices().get(EjbServices.class)).registerInterceptors(this.getEjbDescriptor(), (InterceptorBindings)new InterceptorBindingsAdapter(model));
        }
    }
}

