/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityNameRegister;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.configuration.internal.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.CollectionMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.ComponentMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityXmlMappingData;
import org.hibernate.envers.configuration.internal.metadata.IdMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.InheritanceType;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.ToOneRelationMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SubclassPropertyMapper;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.Triple;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.ValidityAuditStrategy;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class AuditMetadataGenerator {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)AuditMetadataGenerator.class.getName());
    private final MetadataImplementor metadata;
    private final ServiceRegistry serviceRegistry;
    private final GlobalConfiguration globalCfg;
    private final AuditEntitiesConfiguration verEntCfg;
    private final AuditStrategy auditStrategy;
    private final Element revisionInfoRelationMapping;
    private final ClassLoaderService classLoaderService;
    private final BasicMetadataGenerator basicMetadataGenerator;
    private final ComponentMetadataGenerator componentMetadataGenerator;
    private final IdMetadataGenerator idMetadataGenerator;
    private final ToOneRelationMetadataGenerator toOneRelationMetadataGenerator;
    private final Map<String, EntityConfiguration> entitiesConfigurations;
    private final Map<String, EntityConfiguration> notAuditedEntitiesConfigurations;
    private final AuditEntityNameRegister auditEntityNameRegister;
    private final Map<String, Map<Join, Element>> entitiesJoins;

    public AuditMetadataGenerator(MetadataImplementor metadata, ServiceRegistry serviceRegistry, GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, Element revisionInfoRelationMapping, AuditEntityNameRegister auditEntityNameRegister) {
        this.metadata = metadata;
        this.serviceRegistry = serviceRegistry;
        this.globalCfg = globalCfg;
        this.verEntCfg = verEntCfg;
        this.auditStrategy = auditStrategy;
        this.revisionInfoRelationMapping = revisionInfoRelationMapping;
        this.basicMetadataGenerator = new BasicMetadataGenerator();
        this.componentMetadataGenerator = new ComponentMetadataGenerator(this);
        this.idMetadataGenerator = new IdMetadataGenerator(this);
        this.toOneRelationMetadataGenerator = new ToOneRelationMetadataGenerator(this);
        this.auditEntityNameRegister = auditEntityNameRegister;
        this.entitiesConfigurations = new HashMap<String, EntityConfiguration>();
        this.notAuditedEntitiesConfigurations = new HashMap<String, EntityConfiguration>();
        this.entitiesJoins = new HashMap<String, Map<Join, Element>>();
        this.classLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
    }

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    private Element cloneAndSetupRevisionInfoRelationMapping() {
        Element revMapping = (Element)this.revisionInfoRelationMapping.clone();
        revMapping.addAttribute("name", this.verEntCfg.getRevisionFieldName());
        if (this.globalCfg.isCascadeDeleteRevision()) {
            revMapping.addAttribute("on-delete", "cascade");
        }
        MetadataTools.addOrModifyColumn(revMapping, this.verEntCfg.getRevisionFieldName());
        return revMapping;
    }

    void addRevisionInfoRelation(Element anyMapping) {
        anyMapping.add(this.cloneAndSetupRevisionInfoRelationMapping());
    }

    void addRevisionType(Element anyMapping, Element anyMappingEnd) {
        this.addRevisionType(anyMapping, anyMappingEnd, false);
    }

    void addRevisionType(Element anyMapping, Element anyMappingEnd, boolean isKey) {
        Element revTypeProperty = MetadataTools.addProperty(anyMapping, this.verEntCfg.getRevisionTypePropName(), this.verEntCfg.getRevisionTypePropType(), true, isKey);
        revTypeProperty.addAttribute("type", "org.hibernate.envers.internal.entities.RevisionTypeType");
        this.addEndRevision(anyMappingEnd);
    }

    private void addEndRevision(Element anyMapping) {
        if (this.auditStrategy instanceof ValidityAuditStrategy) {
            Element endRevMapping = (Element)this.revisionInfoRelationMapping.clone();
            endRevMapping.setName("many-to-one");
            endRevMapping.addAttribute("name", this.verEntCfg.getRevisionEndFieldName());
            MetadataTools.addOrModifyColumn(endRevMapping, this.verEntCfg.getRevisionEndFieldName());
            anyMapping.add(endRevMapping);
            if (this.verEntCfg.isRevisionEndTimestampEnabled()) {
                String revisionInfoTimestampSqlType = TimestampType.INSTANCE.getName();
                Element timestampProperty = MetadataTools.addProperty(anyMapping, this.verEntCfg.getRevisionEndTimestampFieldName(), revisionInfoTimestampSqlType, true, true, false);
                MetadataTools.addColumn(timestampProperty, this.verEntCfg.getRevisionEndTimestampFieldName(), null, null, null, null, null, null);
            }
        }
    }

    private void addValueInFirstPass(Element parent, Value value, CompositeMapperBuilder currentMapper, String entityName, EntityXmlMappingData xmlMappingData, PropertyAuditingData propertyAuditingData, boolean insertable, boolean processModifiedFlag) {
        Type type = value.getType();
        boolean isBasic = this.basicMetadataGenerator.addBasic(parent, propertyAuditingData, value, currentMapper, insertable, false);
        if (!isBasic) {
            if (type instanceof ComponentType) {
                this.componentMetadataGenerator.addComponent(parent, propertyAuditingData, value, currentMapper, entityName, xmlMappingData, true);
            } else {
                if (!this.processedInSecondPass(type)) {
                    this.throwUnsupportedTypeException(type, entityName, propertyAuditingData.getName());
                }
                return;
            }
        }
        this.addModifiedFlagIfNeeded(parent, propertyAuditingData, processModifiedFlag);
    }

    private boolean processedInSecondPass(Type type) {
        return type instanceof ComponentType || type instanceof ManyToOneType || type instanceof OneToOneType || type instanceof CollectionType;
    }

    private void addValueInSecondPass(Element parent, Value value, CompositeMapperBuilder currentMapper, String entityName, EntityXmlMappingData xmlMappingData, PropertyAuditingData propertyAuditingData, boolean insertable, boolean processModifiedFlag) {
        Type type = value.getType();
        if (type instanceof ComponentType) {
            this.componentMetadataGenerator.addComponent(parent, propertyAuditingData, value, currentMapper, entityName, xmlMappingData, false);
            return;
        }
        if (type instanceof ManyToOneType) {
            this.toOneRelationMetadataGenerator.addToOne(parent, propertyAuditingData, value, currentMapper, entityName, insertable);
        } else if (type instanceof OneToOneType) {
            OneToOne oneToOne = (OneToOne)value;
            if (oneToOne.getReferencedPropertyName() != null) {
                this.toOneRelationMetadataGenerator.addOneToOneNotOwning(propertyAuditingData, value, currentMapper, entityName);
            } else {
                this.toOneRelationMetadataGenerator.addOneToOnePrimaryKeyJoinColumn(propertyAuditingData, value, currentMapper, entityName, insertable);
            }
        } else if (type instanceof CollectionType) {
            CollectionMetadataGenerator collectionMetadataGenerator = new CollectionMetadataGenerator(this, (Collection)value, currentMapper, entityName, xmlMappingData, propertyAuditingData);
            collectionMetadataGenerator.addCollection();
        } else {
            return;
        }
        this.addModifiedFlagIfNeeded(parent, propertyAuditingData, processModifiedFlag);
    }

    private void addModifiedFlagIfNeeded(Element parent, PropertyAuditingData propertyAuditingData, boolean processModifiedFlag) {
        if (processModifiedFlag && propertyAuditingData.isUsingModifiedFlag()) {
            MetadataTools.addModifiedFlagProperty(parent, propertyAuditingData.getName(), this.globalCfg.getModifiedFlagSuffix(), propertyAuditingData.getModifiedFlagName());
        }
    }

    void addValue(Element parent, Value value, CompositeMapperBuilder currentMapper, String entityName, EntityXmlMappingData xmlMappingData, PropertyAuditingData propertyAuditingData, boolean insertable, boolean firstPass, boolean processModifiedFlag) {
        if (firstPass) {
            this.addValueInFirstPass(parent, value, currentMapper, entityName, xmlMappingData, propertyAuditingData, insertable, processModifiedFlag);
        } else {
            this.addValueInSecondPass(parent, value, currentMapper, entityName, xmlMappingData, propertyAuditingData, insertable, processModifiedFlag);
        }
    }

    private void addProperties(Element parent, Iterator<Property> properties, CompositeMapperBuilder currentMapper, ClassAuditingData auditingData, String entityName, EntityXmlMappingData xmlMappingData, boolean firstPass) {
        while (properties.hasNext()) {
            Property property = properties.next();
            String propertyName = property.getName();
            PropertyAuditingData propertyAuditingData = auditingData.getPropertyAuditingData(propertyName);
            if (propertyAuditingData == null) continue;
            this.addValue(parent, property.getValue(), currentMapper, entityName, xmlMappingData, propertyAuditingData, property.isInsertable(), firstPass, true);
        }
    }

    private boolean checkPropertiesAudited(Iterator<Property> properties, ClassAuditingData auditingData) {
        while (properties.hasNext()) {
            Property property = properties.next();
            String propertyName = property.getName();
            PropertyAuditingData propertyAuditingData = auditingData.getPropertyAuditingData(propertyName);
            if (propertyAuditingData != null) continue;
            return false;
        }
        return true;
    }

    protected String getSchema(String schemaFromAnnotation, Table table) {
        String schema = schemaFromAnnotation;
        if (StringTools.isEmpty(schema) && StringTools.isEmpty(schema = this.globalCfg.getDefaultSchemaName())) {
            schema = table.getSchema();
        }
        return schema;
    }

    protected String getCatalog(String catalogFromAnnotation, Table table) {
        String catalog = catalogFromAnnotation;
        if (StringTools.isEmpty(catalog) && StringTools.isEmpty(catalog = this.globalCfg.getDefaultCatalogName())) {
            catalog = table.getCatalog();
        }
        return catalog;
    }

    private void createJoins(PersistentClass pc, Element parent, ClassAuditingData auditingData) {
        Iterator joins = pc.getJoinIterator();
        HashMap<Join, Element> joinElements = new HashMap<Join, Element>();
        this.entitiesJoins.put(pc.getEntityName(), joinElements);
        while (joins.hasNext()) {
            Join join = (Join)joins.next();
            if (!this.checkPropertiesAudited(join.getPropertyIterator(), auditingData)) continue;
            String originalTableName = join.getTable().getName();
            String auditTableName = auditingData.getSecondaryTableDictionary().get(originalTableName);
            if (auditTableName == null) {
                auditTableName = this.verEntCfg.getAuditEntityName(originalTableName);
            }
            String schema = this.getSchema(auditingData.getAuditTable().schema(), join.getTable());
            String catalog = this.getCatalog(auditingData.getAuditTable().catalog(), join.getTable());
            Element joinElement = MetadataTools.createJoin(parent, auditTableName, schema, catalog);
            joinElements.put(join, joinElement);
            Element joinKey = joinElement.addElement("key");
            MetadataTools.addColumns(joinKey, join.getKey().getColumnIterator());
            MetadataTools.addColumn(joinKey, this.verEntCfg.getRevisionFieldName(), null, null, null, null, null, null);
        }
    }

    private void addJoins(PersistentClass pc, CompositeMapperBuilder currentMapper, ClassAuditingData auditingData, String entityName, EntityXmlMappingData xmlMappingData, boolean firstPass) {
        Iterator joins = pc.getJoinIterator();
        while (joins.hasNext()) {
            Join join = (Join)joins.next();
            Element joinElement = this.entitiesJoins.get(entityName).get(join);
            if (joinElement == null) continue;
            this.addProperties(joinElement, join.getPropertyIterator(), currentMapper, auditingData, entityName, xmlMappingData, firstPass);
        }
    }

    private Triple<Element, ExtendedPropertyMapper, String> generateMappingData(PersistentClass pc, EntityXmlMappingData xmlMappingData, AuditTableData auditTableData, IdMappingData idMapper) {
        Element classMapping = MetadataTools.createEntity(xmlMappingData.getMainXmlMapping(), auditTableData, pc.getDiscriminatorValue(), pc.isAbstract());
        MultiPropertyMapper propertyMapper = new MultiPropertyMapper();
        if (pc.getDiscriminator() != null) {
            Element discriminatorElement = classMapping.addElement("discriminator");
            MetadataTools.addColumnsOrFormulas(discriminatorElement, pc.getDiscriminator().getColumnIterator());
            discriminatorElement.addAttribute("type", pc.getDiscriminator().getType().getName());
        }
        classMapping.add((Element)idMapper.getXmlMapping().clone());
        this.addRevisionType(classMapping, classMapping);
        return Triple.make(classMapping, propertyMapper, null);
    }

    private Triple<Element, ExtendedPropertyMapper, String> generateInheritanceMappingData(PersistentClass pc, EntityXmlMappingData xmlMappingData, AuditTableData auditTableData, String inheritanceMappingType) {
        String extendsEntityName = this.verEntCfg.getAuditEntityName(pc.getSuperclass().getEntityName());
        Element classMapping = MetadataTools.createSubclassEntity(xmlMappingData.getMainXmlMapping(), inheritanceMappingType, auditTableData, extendsEntityName, pc.getDiscriminatorValue(), pc.isAbstract());
        String parentEntityName = pc.getSuperclass().getEntityName();
        EntityConfiguration parentConfiguration = this.entitiesConfigurations.get(parentEntityName);
        if (parentConfiguration == null) {
            throw new MappingException("Entity '" + pc.getEntityName() + "' is audited, but its superclass: '" + parentEntityName + "' is not.");
        }
        ExtendedPropertyMapper parentPropertyMapper = parentConfiguration.getPropertyMapper();
        SubclassPropertyMapper propertyMapper = new SubclassPropertyMapper(new MultiPropertyMapper(), parentPropertyMapper);
        return Triple.make(classMapping, propertyMapper, parentEntityName);
    }

    public void generateFirstPass(PersistentClass pc, ClassAuditingData auditingData, EntityXmlMappingData xmlMappingData, boolean isAudited) {
        Triple<Element, ExtendedPropertyMapper, String> mappingData;
        String schema = this.getSchema(auditingData.getAuditTable().schema(), pc.getTable());
        String catalog = this.getCatalog(auditingData.getAuditTable().catalog(), pc.getTable());
        if (!isAudited) {
            String entityName = pc.getEntityName();
            IdMappingData idMapper = this.idMetadataGenerator.addId(pc, false);
            if (idMapper == null) {
                LOG.debugf("Unable to create auditing id mapping for entity %s, because of an unsupported Hibernate id mapping (e.g. key-many-to-one)", entityName);
                return;
            }
            ExtendedPropertyMapper propertyMapper = null;
            String parentEntityName = null;
            EntityConfiguration entityCfg = new EntityConfiguration(entityName, pc.getClassName(), idMapper, propertyMapper, parentEntityName);
            this.notAuditedEntitiesConfigurations.put(entityName, entityCfg);
            return;
        }
        String entityName = pc.getEntityName();
        LOG.debugf("Generating first-pass auditing mapping for entity %s", entityName);
        String auditEntityName = this.verEntCfg.getAuditEntityName(entityName);
        String auditTableName = this.verEntCfg.getAuditTableName(entityName, pc.getTable().getName());
        this.auditEntityNameRegister.register(auditEntityName);
        AuditTableData auditTableData = new AuditTableData(auditEntityName, auditTableName, schema, catalog);
        IdMappingData idMapper = this.idMetadataGenerator.addId(pc, true);
        InheritanceType inheritanceType = InheritanceType.get(pc);
        switch (inheritanceType) {
            case NONE: {
                mappingData = this.generateMappingData(pc, xmlMappingData, auditTableData, idMapper);
                break;
            }
            case SINGLE: {
                mappingData = this.generateInheritanceMappingData(pc, xmlMappingData, auditTableData, "subclass");
                break;
            }
            case JOINED: {
                mappingData = this.generateInheritanceMappingData(pc, xmlMappingData, auditTableData, "joined-subclass");
                Element keyMapping = mappingData.getFirst().addElement("key");
                MetadataTools.addColumns(keyMapping, pc.getTable().getPrimaryKey().columnIterator());
                keyMapping.add((Element)this.cloneAndSetupRevisionInfoRelationMapping().element("column").clone());
                break;
            }
            case TABLE_PER_CLASS: {
                mappingData = this.generateInheritanceMappingData(pc, xmlMappingData, auditTableData, "union-subclass");
                break;
            }
            default: {
                throw new AssertionError((Object)"Impossible enum value.");
            }
        }
        Element classMapping = mappingData.getFirst();
        ExtendedPropertyMapper propertyMapper = mappingData.getSecond();
        String parentEntityName = mappingData.getThird();
        xmlMappingData.setClassMapping(classMapping);
        this.addProperties(classMapping, pc.getUnjoinedPropertyIterator(), propertyMapper, auditingData, pc.getEntityName(), xmlMappingData, true);
        this.createJoins(pc, classMapping, auditingData);
        this.addJoins(pc, propertyMapper, auditingData, pc.getEntityName(), xmlMappingData, true);
        EntityConfiguration entityCfg = new EntityConfiguration(auditEntityName, pc.getClassName(), idMapper, propertyMapper, parentEntityName);
        this.entitiesConfigurations.put(pc.getEntityName(), entityCfg);
    }

    public void generateSecondPass(PersistentClass pc, ClassAuditingData auditingData, EntityXmlMappingData xmlMappingData) {
        String entityName = pc.getEntityName();
        LOG.debugf("Generating second-pass auditing mapping for entity %s", entityName);
        ExtendedPropertyMapper propertyMapper = this.entitiesConfigurations.get(entityName).getPropertyMapper();
        Element parent = xmlMappingData.getClassMapping();
        this.addProperties(parent, pc.getUnjoinedPropertyIterator(), propertyMapper, auditingData, entityName, xmlMappingData, false);
        this.addJoins(pc, propertyMapper, auditingData, entityName, xmlMappingData, false);
    }

    public Map<String, EntityConfiguration> getEntitiesConfigurations() {
        return this.entitiesConfigurations;
    }

    BasicMetadataGenerator getBasicMetadataGenerator() {
        return this.basicMetadataGenerator;
    }

    GlobalConfiguration getGlobalCfg() {
        return this.globalCfg;
    }

    AuditEntitiesConfiguration getVerEntCfg() {
        return this.verEntCfg;
    }

    AuditStrategy getAuditStrategy() {
        return this.auditStrategy;
    }

    AuditEntityNameRegister getAuditEntityNameRegister() {
        return this.auditEntityNameRegister;
    }

    void throwUnsupportedTypeException(Type type, String entityName, String propertyName) {
        String message = "Type not supported for auditing: " + type.getClass().getName() + ", on entity " + entityName + ", property '" + propertyName + "'.";
        throw new MappingException(message);
    }

    IdMappingData getReferencedIdMappingData(String entityName, String referencedEntityName, PropertyAuditingData propertyAuditingData, boolean allowNotAuditedTarget) {
        EntityConfiguration configuration = this.getEntitiesConfigurations().get(referencedEntityName);
        if (configuration == null) {
            RelationTargetAuditMode relationTargetAuditMode = propertyAuditingData.getRelationTargetAuditMode();
            configuration = this.getNotAuditedEntitiesConfigurations().get(referencedEntityName);
            if (configuration == null || !allowNotAuditedTarget || !RelationTargetAuditMode.NOT_AUDITED.equals((Object)relationTargetAuditMode)) {
                throw new MappingException("An audited relation from " + entityName + "." + propertyAuditingData.getName() + " to a not audited entity " + referencedEntityName + "!" + (allowNotAuditedTarget ? " Such mapping is possible, but has to be explicitly defined using @Audited(targetAuditMode = NOT_AUDITED)." : ""));
            }
        }
        return configuration.getIdMappingData();
    }

    public Map<String, EntityConfiguration> getNotAuditedEntitiesConfigurations() {
        return this.notAuditedEntitiesConfigurations;
    }
}

