/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Set;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientTransactionContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.logging.Logger;

public final class ReceiverInterceptor
implements EJBClientInterceptor {
    private static final Logger logger = Logger.getLogger(ReceiverInterceptor.class);

    @Override
    public void handleInvocation(EJBClientInvocationContext invocationContext) throws Exception {
        EJBReceiverContext receiverContext;
        String transactionNode;
        EJBClientContext clientContext = invocationContext.getClientContext();
        EJBLocator<?> locator = invocationContext.getLocator();
        Set<String> excludedNodes = invocationContext.getExcludedNodes();
        EJBClientTransactionContext transactionContext = EJBClientTransactionContext.getCurrent();
        String string = transactionNode = transactionContext == null ? null : transactionContext.getTransactionNode();
        if (transactionNode != null) {
            if (excludedNodes.contains(transactionNode)) {
                throw Logs.MAIN.txNodeIsExcludedForInvocation(transactionNode, invocationContext);
            }
            receiverContext = clientContext.requireNodeEJBReceiverContext(transactionNode);
            if (!receiverContext.getReceiver().acceptsModule(locator.getAppName(), locator.getModuleName(), locator.getDistinctName())) {
                throw Logs.MAIN.nodeDoesNotAcceptLocator(transactionNode, locator);
            }
            Affinity affinity = locator.getAffinity();
            if (affinity instanceof NodeAffinity ? !transactionNode.equals(((NodeAffinity)affinity).getNodeName()) : affinity instanceof ClusterAffinity && !clientContext.clusterContains(((ClusterAffinity)affinity).getClusterName(), transactionNode)) {
                throw Logs.MAIN.nodeDoesNotAcceptLocator(transactionNode, locator);
            }
        } else {
            Affinity affinity = locator.getAffinity();
            if (affinity instanceof NodeAffinity) {
                String nodeName = ((NodeAffinity)affinity).getNodeName();
                if (excludedNodes.contains(nodeName)) {
                    throw Logs.MAIN.requiredNodeExcludedFromInvocation(locator, nodeName, invocationContext);
                }
                receiverContext = clientContext.requireNodeEJBReceiverContext(nodeName);
            } else if (affinity instanceof ClusterAffinity) {
                Affinity weakAffinity = invocationContext.getInvocationHandler().getWeakAffinity();
                if (weakAffinity instanceof NodeAffinity) {
                    EJBReceiver nodeReceiver;
                    String nodeName = ((NodeAffinity)weakAffinity).getNodeName();
                    if (excludedNodes.contains(nodeName)) {
                        logger.debugf("Ignoring weak affinity on node %s since that node has been marked as excluded for invocation context %s", (Object)nodeName, (Object)invocationContext);
                        nodeReceiver = null;
                    } else {
                        nodeReceiver = clientContext.getNodeEJBReceiver(nodeName);
                        if (nodeReceiver != null && !nodeReceiver.acceptsModule(locator.getAppName(), locator.getModuleName(), locator.getDistinctName())) {
                            logger.debugf("Ignoring weak affinity on node %s since that node does not currently accept %s", (Object)nodeName, (Object)locator);
                            invocationContext.markNodeAsExcluded(nodeName);
                            nodeReceiver = null;
                        }
                    }
                    receiverContext = nodeReceiver != null && clientContext.clusterContains(((ClusterAffinity)affinity).getClusterName(), nodeReceiver.getNodeName()) ? clientContext.requireEJBReceiverContext(nodeReceiver) : clientContext.requireClusterEJBReceiverContext(invocationContext, ((ClusterAffinity)affinity).getClusterName());
                } else {
                    receiverContext = clientContext.requireClusterEJBReceiverContext(invocationContext, ((ClusterAffinity)affinity).getClusterName());
                }
            } else if (affinity == Affinity.NONE) {
                Affinity weakAffinity = invocationContext.getInvocationHandler().getWeakAffinity();
                if (weakAffinity instanceof NodeAffinity) {
                    EJBReceiver nodeReceiver;
                    String nodeName = ((NodeAffinity)weakAffinity).getNodeName();
                    if (excludedNodes.contains(nodeName)) {
                        logger.debugf("Ignoring weak affinity on node %s since that node has been marked as excluded for invocation context %s", (Object)nodeName, (Object)invocationContext);
                        nodeReceiver = null;
                    } else {
                        nodeReceiver = clientContext.getNodeEJBReceiver(nodeName);
                        if (nodeReceiver != null && !nodeReceiver.acceptsModule(locator.getAppName(), locator.getModuleName(), locator.getDistinctName())) {
                            logger.debugf("Ignoring weak affinity on node %s since that node does not currently accept %s", (Object)nodeName, (Object)locator);
                            invocationContext.markNodeAsExcluded(nodeName);
                            nodeReceiver = null;
                        }
                    }
                    if (nodeReceiver != null) {
                        receiverContext = clientContext.requireEJBReceiverContext(nodeReceiver);
                    } else {
                        EJBReceiver receiver = clientContext.requireEJBReceiver(invocationContext, locator.getAppName(), locator.getModuleName(), locator.getDistinctName());
                        receiverContext = clientContext.requireEJBReceiverContext(receiver);
                    }
                } else if (weakAffinity instanceof ClusterAffinity) {
                    EJBReceiverContext clusterReceiverContext = clientContext.getClusterEJBReceiverContext(invocationContext, ((ClusterAffinity)weakAffinity).getClusterName());
                    if (clusterReceiverContext != null) {
                        receiverContext = clusterReceiverContext;
                    } else {
                        EJBReceiver receiver = clientContext.requireEJBReceiver(invocationContext, locator.getAppName(), locator.getModuleName(), locator.getDistinctName());
                        receiverContext = clientContext.requireEJBReceiverContext(receiver);
                    }
                } else {
                    EJBReceiver receiver = clientContext.requireEJBReceiver(invocationContext, locator.getAppName(), locator.getModuleName(), locator.getDistinctName());
                    receiverContext = clientContext.requireEJBReceiverContext(receiver);
                }
            } else {
                throw new IllegalStateException("Unknown affinity type");
            }
        }
        logger.debug("Sending invocation to node " + receiverContext.getReceiver().getNodeName());
        invocationContext.setReceiverInvocationContext(new EJBReceiverInvocationContext(invocationContext, receiverContext));
        invocationContext.sendRequest();
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        return context.getResult();
    }
}

