/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.security.metadata.EJBBoundSecurityMetaData;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class MissingMethodPermissionsDenyAccessMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    private volatile boolean denyAccessByDefault = false;

    public MissingMethodPermissionsDenyAccessMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        List securityMetaDatas;
        AssemblyDescriptorMetaData assemblyMetadata;
        Boolean missingMethodPermissionsDenyAccess = null;
        Boolean missingMethodPermissionsDenyAccessApplicableForAllBeans = null;
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData != null && (assemblyMetadata = ejbJarMetaData.getAssemblyDescriptor()) != null && (securityMetaDatas = assemblyMetadata.getAny(EJBBoundSecurityMetaData.class)) != null) {
            for (EJBBoundSecurityMetaData securityMetaData : securityMetaDatas) {
                if (securityMetaData.getEjbName().equals(description.getComponentName())) {
                    missingMethodPermissionsDenyAccess = securityMetaData.getMissingMethodPermissionsDenyAccess();
                    break;
                }
                if (!securityMetaData.getEjbName().equals("*")) continue;
                missingMethodPermissionsDenyAccessApplicableForAllBeans = securityMetaData.getMissingMethodPermissionsDenyAccess();
            }
        }
        if (missingMethodPermissionsDenyAccess != null) {
            description.setMissingMethodPermissionsDenyAccess(missingMethodPermissionsDenyAccess);
        } else if (missingMethodPermissionsDenyAccessApplicableForAllBeans != null) {
            description.setMissingMethodPermissionsDenyAccess(missingMethodPermissionsDenyAccessApplicableForAllBeans);
        } else {
            description.setMissingMethodPermissionsDenyAccess(this.denyAccessByDefault);
        }
    }

    public boolean isDenyAccessByDefault() {
        return this.denyAccessByDefault;
    }

    public void setDenyAccessByDefault(boolean denyAccessByDefault) {
        this.denyAccessByDefault = denyAccessByDefault;
    }
}

