/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Stack;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.XmlWriter;

public class WebRowSetXmlWriter
implements XmlWriter,
Serializable {
    private transient Writer writer;
    private Stack<String> stack;
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = 7163134986189677641L;

    public WebRowSetXmlWriter() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void writeXML(WebRowSet caller, Writer wrt) throws SQLException {
        this.stack = new Stack();
        this.writer = wrt;
        this.writeRowSet(caller);
    }

    public void writeXML(WebRowSet caller, OutputStream oStream) throws SQLException {
        this.stack = new Stack();
        this.writer = new OutputStreamWriter(oStream);
        this.writeRowSet(caller);
    }

    private void writeRowSet(WebRowSet caller) throws SQLException {
        try {
            this.startHeader();
            this.writeProperties(caller);
            this.writeMetaData(caller);
            this.writeData(caller);
            this.endHeader();
        }
        catch (IOException ex) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.ioex").toString(), ex.getMessage()));
        }
    }

    private void startHeader() throws IOException {
        this.setTag("webRowSet");
        this.writer.write("<?xml version=\"1.0\"?>\n");
        this.writer.write("<webRowSet xmlns=\"http://java.sun.com/xml/ns/jdbc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        this.writer.write("xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc http://java.sun.com/xml/ns/jdbc/webrowset.xsd\">\n");
    }

    private void endHeader() throws IOException {
        this.endTag("webRowSet");
    }

    private void writeProperties(WebRowSet caller) throws IOException {
        this.beginSection("properties");
        try {
            this.propString("command", this.processSpecialCharacters(caller.getCommand()));
            this.propInteger("concurrency", caller.getConcurrency());
            this.propString("datasource", caller.getDataSourceName());
            this.propBoolean("escape-processing", caller.getEscapeProcessing());
            try {
                this.propInteger("fetch-direction", caller.getFetchDirection());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.propInteger("fetch-size", caller.getFetchSize());
            this.propInteger("isolation-level", caller.getTransactionIsolation());
            this.beginSection("key-columns");
            int[] kc = caller.getKeyColumns();
            for (int i = 0; kc != null && i < kc.length; ++i) {
                this.propInteger("column", kc[i]);
            }
            this.endSection("key-columns");
            this.beginSection("map");
            Map<String, Class<?>> typeMap = caller.getTypeMap();
            if (typeMap != null) {
                for (Map.Entry<String, Class<?>> mm : typeMap.entrySet()) {
                    this.propString("type", mm.getKey());
                    this.propString("class", mm.getValue().getName());
                }
            }
            this.endSection("map");
            this.propInteger("max-field-size", caller.getMaxFieldSize());
            this.propInteger("max-rows", caller.getMaxRows());
            this.propInteger("query-timeout", caller.getQueryTimeout());
            this.propBoolean("read-only", caller.isReadOnly());
            int itype = caller.getType();
            String strType = "";
            if (itype == 1003) {
                strType = "ResultSet.TYPE_FORWARD_ONLY";
            } else if (itype == 1004) {
                strType = "ResultSet.TYPE_SCROLL_INSENSITIVE";
            } else if (itype == 1005) {
                strType = "ResultSet.TYPE_SCROLL_SENSITIVE";
            }
            this.propString("rowset-type", strType);
            this.propBoolean("show-deleted", caller.getShowDeleted());
            this.propString("table-name", caller.getTableName());
            this.propString("url", caller.getUrl());
            this.beginSection("sync-provider");
            String strProviderInstance = caller.getSyncProvider().toString();
            String strProvider = strProviderInstance.substring(0, caller.getSyncProvider().toString().indexOf("@"));
            this.propString("sync-provider-name", strProvider);
            this.propString("sync-provider-vendor", "Oracle Corporation");
            this.propString("sync-provider-version", "1.0");
            this.propInteger("sync-provider-grade", caller.getSyncProvider().getProviderGrade());
            this.propInteger("data-source-lock", caller.getSyncProvider().getDataSourceLock());
            this.endSection("sync-provider");
        }
        catch (SQLException ex) {
            throw new IOException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.sqlex").toString(), ex.getMessage()));
        }
        this.endSection("properties");
    }

    private void writeMetaData(WebRowSet caller) throws IOException {
        this.beginSection("metadata");
        try {
            ResultSetMetaData rsmd = caller.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.propInteger("column-count", columnCount);
            for (int colIndex = 1; colIndex <= columnCount; ++colIndex) {
                this.beginSection("column-definition");
                this.propInteger("column-index", colIndex);
                this.propBoolean("auto-increment", rsmd.isAutoIncrement(colIndex));
                this.propBoolean("case-sensitive", rsmd.isCaseSensitive(colIndex));
                this.propBoolean("currency", rsmd.isCurrency(colIndex));
                this.propInteger("nullable", rsmd.isNullable(colIndex));
                this.propBoolean("signed", rsmd.isSigned(colIndex));
                this.propBoolean("searchable", rsmd.isSearchable(colIndex));
                this.propInteger("column-display-size", rsmd.getColumnDisplaySize(colIndex));
                this.propString("column-label", rsmd.getColumnLabel(colIndex));
                this.propString("column-name", rsmd.getColumnName(colIndex));
                this.propString("schema-name", rsmd.getSchemaName(colIndex));
                this.propInteger("column-precision", rsmd.getPrecision(colIndex));
                this.propInteger("column-scale", rsmd.getScale(colIndex));
                this.propString("table-name", rsmd.getTableName(colIndex));
                this.propString("catalog-name", rsmd.getCatalogName(colIndex));
                this.propInteger("column-type", rsmd.getColumnType(colIndex));
                this.propString("column-type-name", rsmd.getColumnTypeName(colIndex));
                this.endSection("column-definition");
            }
        }
        catch (SQLException ex) {
            throw new IOException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.sqlex").toString(), ex.getMessage()));
        }
        this.endSection("metadata");
    }

    private void writeData(WebRowSet caller) throws IOException {
        try {
            ResultSetMetaData rsmd = caller.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.beginSection("data");
            caller.beforeFirst();
            caller.setShowDeleted(true);
            while (caller.next()) {
                if (caller.rowDeleted() && caller.rowInserted()) {
                    this.beginSection("modifyRow");
                } else if (caller.rowDeleted()) {
                    this.beginSection("deleteRow");
                } else if (caller.rowInserted()) {
                    this.beginSection("insertRow");
                } else {
                    this.beginSection("currentRow");
                }
                for (int i = 1; i <= columnCount; ++i) {
                    if (caller.columnUpdated(i)) {
                        ResultSet rs = caller.getOriginalRow();
                        rs.next();
                        this.beginTag("columnValue");
                        this.writeValue(i, (RowSet)rs);
                        this.endTag("columnValue");
                        this.beginTag("updateRow");
                        this.writeValue(i, caller);
                        this.endTag("updateRow");
                        continue;
                    }
                    this.beginTag("columnValue");
                    this.writeValue(i, caller);
                    this.endTag("columnValue");
                }
                this.endSection();
            }
            this.endSection("data");
        }
        catch (SQLException ex) {
            throw new IOException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.sqlex").toString(), ex.getMessage()));
        }
    }

    private void writeValue(int idx, RowSet caller) throws IOException {
        try {
            int type = caller.getMetaData().getColumnType(idx);
            switch (type) {
                case -7: 
                case 16: {
                    boolean b = caller.getBoolean(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeBoolean(b);
                    break;
                }
                case -6: 
                case 5: {
                    short s = caller.getShort(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeShort(s);
                    break;
                }
                case 4: {
                    int i = caller.getInt(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeInteger(i);
                    break;
                }
                case -5: {
                    long l = caller.getLong(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(l);
                    break;
                }
                case 6: 
                case 7: {
                    float f = caller.getFloat(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeFloat(f);
                    break;
                }
                case 8: {
                    double d = caller.getDouble(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeDouble(d);
                    break;
                }
                case 2: 
                case 3: {
                    this.writeBigDecimal(caller.getBigDecimal(idx));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    break;
                }
                case 91: {
                    Date date = caller.getDate(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(date.getTime());
                    break;
                }
                case 92: {
                    Time time = caller.getTime(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(time.getTime());
                    break;
                }
                case 93: {
                    Timestamp ts = caller.getTimestamp(idx);
                    if (caller.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(ts.getTime());
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.writeStringData(caller.getString(idx));
                    break;
                }
                default: {
                    System.out.println(this.resBundle.handleGetObject("wsrxmlwriter.notproper").toString());
                    break;
                }
            }
        }
        catch (SQLException ex) {
            throw new IOException(this.resBundle.handleGetObject("wrsxmlwriter.failedwrite").toString() + ex.getMessage());
        }
    }

    private void beginSection(String tag) throws IOException {
        this.setTag(tag);
        this.writeIndent(this.stack.size());
        this.writer.write("<" + tag + ">\n");
    }

    private void endSection(String tag) throws IOException {
        this.writeIndent(this.stack.size());
        String beginTag = this.getTag();
        if (beginTag.indexOf("webRowSet") != -1) {
            beginTag = "webRowSet";
        }
        if (tag.equals(beginTag)) {
            this.writer.write("</" + beginTag + ">\n");
        }
        this.writer.flush();
    }

    private void endSection() throws IOException {
        this.writeIndent(this.stack.size());
        String beginTag = this.getTag();
        this.writer.write("</" + beginTag + ">\n");
        this.writer.flush();
    }

    private void beginTag(String tag) throws IOException {
        this.setTag(tag);
        this.writeIndent(this.stack.size());
        this.writer.write("<" + tag + ">");
    }

    private void endTag(String tag) throws IOException {
        String beginTag = this.getTag();
        if (tag.equals(beginTag)) {
            this.writer.write("</" + beginTag + ">\n");
        }
        this.writer.flush();
    }

    private void emptyTag(String tag) throws IOException {
        this.writer.write("<" + tag + "/>");
    }

    private void setTag(String tag) {
        this.stack.push(tag);
    }

    private String getTag() {
        return this.stack.pop();
    }

    private void writeNull() throws IOException {
        this.emptyTag("null");
    }

    private void writeStringData(String s) throws IOException {
        if (s == null) {
            this.writeNull();
        } else if (s.equals("")) {
            this.writeEmptyString();
        } else {
            s = this.processSpecialCharacters(s);
            this.writer.write(s);
        }
    }

    private void writeString(String s) throws IOException {
        if (s != null) {
            this.writer.write(s);
        } else {
            this.writeNull();
        }
    }

    private void writeShort(short s) throws IOException {
        this.writer.write(Short.toString(s));
    }

    private void writeLong(long l) throws IOException {
        this.writer.write(Long.toString(l));
    }

    private void writeInteger(int i) throws IOException {
        this.writer.write(Integer.toString(i));
    }

    private void writeBoolean(boolean b) throws IOException {
        this.writer.write(Boolean.valueOf(b).toString());
    }

    private void writeFloat(float f) throws IOException {
        this.writer.write(Float.toString(f));
    }

    private void writeDouble(double d) throws IOException {
        this.writer.write(Double.toString(d));
    }

    private void writeBigDecimal(BigDecimal bd) throws IOException {
        if (bd != null) {
            this.writer.write(bd.toString());
        } else {
            this.emptyTag("null");
        }
    }

    private void writeIndent(int tabs) throws IOException {
        for (int i = 1; i < tabs; ++i) {
            this.writer.write("  ");
        }
    }

    private void propString(String tag, String s) throws IOException {
        this.beginTag(tag);
        this.writeString(s);
        this.endTag(tag);
    }

    private void propInteger(String tag, int i) throws IOException {
        this.beginTag(tag);
        this.writeInteger(i);
        this.endTag(tag);
    }

    private void propBoolean(String tag, boolean b) throws IOException {
        this.beginTag(tag);
        this.writeBoolean(b);
        this.endTag(tag);
    }

    private void writeEmptyString() throws IOException {
        this.emptyTag("emptyString");
    }

    @Override
    public boolean writeData(RowSetInternal caller) {
        return false;
    }

    private String processSpecialCharacters(String s) {
        if (s == null) {
            return null;
        }
        char[] charStr = s.toCharArray();
        String specialStr = "";
        for (int i = 0; i < charStr.length; ++i) {
            specialStr = charStr[i] == '&' ? specialStr.concat("&amp;") : (charStr[i] == '<' ? specialStr.concat("&lt;") : (charStr[i] == '>' ? specialStr.concat("&gt;") : (charStr[i] == '\'' ? specialStr.concat("&apos;") : (charStr[i] == '\"' ? specialStr.concat("&quot;") : specialStr.concat(String.valueOf(charStr[i]))))));
        }
        s = specialStr;
        return s;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

