/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationImpl;
import org.jboss.as.controller.client.impl.InputStreamEntry;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class OperationBuilder {
    private final ModelNode operation;
    private volatile List<InputStream> inputStreams;
    private boolean autoCloseStreams = false;

    public OperationBuilder(ModelNode operation) {
        this(operation, false);
    }

    public OperationBuilder(ModelNode operation, boolean autoCloseStreams) {
        if (operation == null) {
            throw ControllerClientLogger.ROOT_LOGGER.nullVar("operation");
        }
        this.operation = operation;
        this.autoCloseStreams = autoCloseStreams;
    }

    public OperationBuilder addFileAsAttachment(File file) {
        if (file == null) {
            throw ControllerClientLogger.ROOT_LOGGER.nullVar("file");
        }
        try {
            FileStreamEntry entry = new FileStreamEntry(file);
            if (this.inputStreams == null) {
                this.inputStreams = new ArrayList<InputStream>();
            }
            this.inputStreams.add(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public OperationBuilder addInputStream(InputStream in) {
        if (in == null) {
            throw ControllerClientLogger.ROOT_LOGGER.nullVar("input-stream");
        }
        if (this.inputStreams == null) {
            this.inputStreams = new ArrayList<InputStream>();
        }
        this.inputStreams.add(in);
        return this;
    }

    public int getInputStreamCount() {
        List<InputStream> list = this.inputStreams;
        return list == null ? 0 : list.size();
    }

    public void setAutoCloseStreams(boolean autoCloseStreams) {
        this.autoCloseStreams = autoCloseStreams;
    }

    public Operation build() {
        return new OperationImpl(this.operation, this.inputStreams, this.autoCloseStreams);
    }

    public static OperationBuilder create(ModelNode operation) {
        return new OperationBuilder(operation);
    }

    public static OperationBuilder create(ModelNode operation, boolean autoCloseStreams) {
        return new OperationBuilder(operation, autoCloseStreams);
    }

    private static class FileStreamEntry
    extends FilterInputStream
    implements InputStreamEntry {
        private final File file;

        private FileStreamEntry(File file) throws IOException {
            super(new FileInputStream(file));
            this.file = file;
        }

        @Override
        public int initialize() throws IOException {
            return (int)this.file.length();
        }

        @Override
        public void copyStream(DataOutput output) throws IOException {
            FileInputStream is = new FileInputStream(this.file);
            try {
                StreamUtils.copyStream((InputStream)is, output);
                is.close();
            }
            finally {
                StreamUtils.safeClose(is);
            }
        }
    }
}

