/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.google.common.base.Joiner;
import com.thinkaurelius.titan.BerkeleyStorageSetup;
import com.thinkaurelius.titan.StorageSetup;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TitanIndexTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.io.File;
import org.junit.Test;

public class BerkeleyElasticsearchTest
extends TitanIndexTest {
    public BerkeleyElasticsearchTest() {
        super(true, true, true);
    }

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = BerkeleyStorageSetup.getBerkeleyJEConfiguration();
        config.set(GraphDatabaseConfiguration.INDEX_BACKEND, (Object)"elasticsearch", new String[]{"search"});
        config.set(ElasticSearchIndex.LOCAL_MODE, (Object)true, new String[]{"search"});
        config.set(ElasticSearchIndex.CLIENT_ONLY, (Object)false, new String[]{"search"});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)StorageSetup.getHomeDir((String)"es"), new String[]{"search"});
        return config.getConfiguration();
    }

    public boolean supportsLuceneStyleQueries() {
        return true;
    }

    @Test
    public void testGraphOfTheGodsFactoryCreate() {
        String bdbtmp = Joiner.on((String)File.separator).join((Object)"target", (Object)"gotgfactory", new Object[0]);
        TitanGraph gotg = GraphOfTheGodsFactory.create((String)bdbtmp);
        TitanIndexTest.assertGraphOfTheGods((TitanGraph)gotg);
        gotg.shutdown();
    }
}

