/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.google.common.base.Joiner;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.CommonsConfiguration;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchSetup;
import com.thinkaurelius.titan.diskstorage.es.ElasticsearchRunner;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProviderTest;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.BaseConfiguration;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.client.internal.InternalGenericClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElasticSearchConfigTest {
    private static final String INDEX_NAME = "escfg";

    @BeforeClass
    public static void killElasticsearch() {
        ElasticsearchRunner esr = new ElasticsearchRunner();
        esr.stop();
    }

    @Test
    public void testTransportClient() throws BackendException, InterruptedException {
        ElasticsearchRunner esr = new ElasticsearchRunner();
        esr.start();
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.TRANSPORT_CLIENT, new String[]{INDEX_NAME});
        config.set(GraphDatabaseConfiguration.INDEX_HOSTS, (Object)new String[]{"127.0.0.1"}, new String[]{INDEX_NAME});
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        this.simpleWriteAndQuery((IndexProvider)idx);
        idx.close();
        config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.TRANSPORT_CLIENT, new String[]{INDEX_NAME});
        config.set(GraphDatabaseConfiguration.INDEX_HOSTS, (Object)new String[]{"10.11.12.13"}, new String[]{INDEX_NAME});
        indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        Throwable failure = null;
        try {
            idx = new ElasticSearchIndex(indexConfig);
        }
        catch (Throwable t) {
            failure = t;
        }
        Assert.assertNotNull((String)"ES client failed to throw exception on connection failure", (Object)failure);
        esr.stop();
    }

    @Test
    public void testLocalNodeUsingExt() throws BackendException, InterruptedException {
        String baseDir = Joiner.on((String)"/").join((Object)"target", (Object)"es", new Object[]{"jvmlocal_ext"});
        Assert.assertFalse((boolean)new File(baseDir + File.separator + "data").exists());
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration());
        cc.set("index.escfg.elasticsearch.ext.node.data", (Object)"true");
        cc.set("index.escfg.elasticsearch.ext.node.client", (Object)"false");
        cc.set("index.escfg.elasticsearch.ext.node.local", (Object)"true");
        cc.set("index.escfg.elasticsearch.ext.path.data", (Object)(baseDir + File.separator + "data"));
        cc.set("index.escfg.elasticsearch.ext.path.work", (Object)(baseDir + File.separator + "work"));
        cc.set("index.escfg.elasticsearch.ext.path.logs", (Object)(baseDir + File.separator + "logs"));
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE);
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        this.simpleWriteAndQuery((IndexProvider)idx);
        idx.close();
        Assert.assertTrue((boolean)new File(baseDir + File.separator + "data").exists());
    }

    @Test
    public void testLocalNodeUsingExtAndIndexDirectory() throws BackendException, InterruptedException {
        String baseDir = Joiner.on((String)"/").join((Object)"target", (Object)"es", new Object[]{"jvmlocal_ext2"});
        Assert.assertFalse((boolean)new File(baseDir + File.separator + "data").exists());
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration());
        cc.set("index.escfg.elasticsearch.ext.node.data", (Object)"true");
        cc.set("index.escfg.elasticsearch.ext.node.client", (Object)"false");
        cc.set("index.escfg.elasticsearch.ext.node.local", (Object)"true");
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE);
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)baseDir, new String[]{INDEX_NAME});
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        this.simpleWriteAndQuery((IndexProvider)idx);
        idx.close();
        Assert.assertTrue((boolean)new File(baseDir + File.separator + "data").exists());
    }

    @Test
    public void testLocalNodeUsingYaml() throws BackendException, InterruptedException {
        String baseDir = Joiner.on((String)"/").join((Object)"target", (Object)"es", new Object[]{"jvmlocal_yml"});
        Assert.assertFalse((boolean)new File(baseDir + File.separator + "data").exists());
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        config.set(GraphDatabaseConfiguration.INDEX_CONF_FILE, (Object)Joiner.on((String)File.separator).join((Object)"target", (Object)"test-classes", new Object[]{"es_jvmlocal.yml"}), new String[]{INDEX_NAME});
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        this.simpleWriteAndQuery((IndexProvider)idx);
        idx.close();
        Assert.assertTrue((boolean)new File(baseDir + File.separator + "data").exists());
    }

    @Test
    public void testNetworkNodeUsingExt() throws BackendException, InterruptedException {
        ElasticsearchRunner esr = new ElasticsearchRunner();
        esr.start();
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration());
        cc.set("index.escfg.elasticsearch.ext.node.data", (Object)"false");
        cc.set("index.escfg.elasticsearch.ext.node.client", (Object)"true");
        cc.set("index.escfg.elasticsearch.ext.discovery.zen.ping.multicast.enabled", (Object)"false");
        cc.set("index.escfg.elasticsearch.ext.discovery.zen.ping.unicast.hosts", (Object)"localhost,127.0.0.1:9300");
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE);
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        this.simpleWriteAndQuery((IndexProvider)idx);
        idx.close();
        cc.set("index.escfg.elasticsearch.ext.discovery.zen.ping.unicast.hosts", (Object)"10.11.12.13");
        config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE);
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        config.set(ElasticSearchIndex.HEALTH_REQUEST_TIMEOUT, (Object)"5s", new String[]{INDEX_NAME});
        indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        Throwable failure = null;
        try {
            idx = new ElasticSearchIndex(indexConfig);
        }
        catch (Throwable t) {
            failure = t;
        }
        Assert.assertNotNull((String)"ES client failed to throw exception on connection failure", (Object)failure);
        esr.stop();
    }

    @Test
    public void testNetworkNodeUsingYaml() throws BackendException, InterruptedException {
        ElasticsearchRunner esr = new ElasticsearchRunner();
        esr.start();
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        config.set(GraphDatabaseConfiguration.INDEX_CONF_FILE, (Object)Joiner.on((String)File.separator).join((Object)"target", (Object)"test-classes", new Object[]{"es_cfg_nodeclient.yml"}), new String[]{INDEX_NAME});
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        this.simpleWriteAndQuery((IndexProvider)idx);
        idx.close();
        config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        config.set(ElasticSearchIndex.HEALTH_REQUEST_TIMEOUT, (Object)"5s", new String[]{INDEX_NAME});
        config.set(GraphDatabaseConfiguration.INDEX_CONF_FILE, (Object)Joiner.on((String)File.separator).join((Object)"target", (Object)"test-classes", new Object[]{"es_cfg_bogus_nodeclient.yml"}), new String[]{INDEX_NAME});
        indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        Throwable failure = null;
        try {
            idx = new ElasticSearchIndex(indexConfig);
        }
        catch (Throwable t) {
            failure = t;
        }
        Assert.assertNotNull((String)"ES client failed to throw exception on connection failure", (Object)failure);
        esr.stop();
    }

    @Test
    public void testIndexCreationOptions() throws InterruptedException, BackendException {
        int shards = 77;
        ElasticsearchRunner esr = new ElasticsearchRunner();
        esr.start();
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration());
        cc.set("index.escfg.elasticsearch.create.ext.number_of_shards", (Object)String.valueOf(77));
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE);
        config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.NODE, new String[]{INDEX_NAME});
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        this.simpleWriteAndQuery((IndexProvider)idx);
        idx.close();
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        settingsBuilder.put("discovery.zen.ping.multicast.enabled", "false");
        settingsBuilder.put("discovery.zen.ping.unicast.hosts", "localhost,127.0.0.1:9300");
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder().settings(settingsBuilder.build());
        nodeBuilder.client(true).data(false).local(false);
        Node n = nodeBuilder.build().start();
        GetSettingsRequest request = (GetSettingsRequest)new GetSettingsRequestBuilder((InternalGenericClient)((NodeClient)n.client()), new String[]{"titan"}).request();
        GetSettingsResponse response = (GetSettingsResponse)n.client().admin().indices().getSettings(request).actionGet();
        Assert.assertEquals((Object)String.valueOf(77), (Object)response.getSetting("titan", "index.number_of_shards"));
        n.stop();
        esr.stop();
    }

    private void simpleWriteAndQuery(IndexProvider idx) throws BackendException, InterruptedException {
        StandardDuration maxWrite = new StandardDuration(2000L, TimeUnit.MILLISECONDS);
        String storeName = "jvmlocal_test_store";
        KeyInformation.IndexRetriever indexRetriever = IndexProviderTest.getIndexRetriever((Map)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures()));
        StandardBaseTransactionConfig txConfig = StandardBaseTransactionConfig.of((TimestampProvider)Timestamps.MILLI);
        IndexTransaction itx = new IndexTransaction(idx, indexRetriever, (BaseTransactionConfig)txConfig, (Duration)maxWrite);
        Assert.assertEquals((long)0L, (long)itx.query(new IndexQuery("jvmlocal_test_store", (Condition)PredicateCondition.of((Object)"name", (TitanPredicate)Text.PREFIX, (Object)"ali"))).size());
        itx.add("jvmlocal_test_store", "doc", "name", (Object)"alice", false);
        itx.commit();
        Thread.sleep(1500L);
        itx = new IndexTransaction(idx, indexRetriever, (BaseTransactionConfig)txConfig, (Duration)maxWrite);
        Assert.assertEquals((long)0L, (long)itx.query(new IndexQuery("jvmlocal_test_store", (Condition)PredicateCondition.of((Object)"name", (TitanPredicate)Text.PREFIX, (Object)"zed"))).size());
        Assert.assertEquals((long)1L, (long)itx.query(new IndexQuery("jvmlocal_test_store", (Condition)PredicateCondition.of((Object)"name", (TitanPredicate)Text.PREFIX, (Object)"ali"))).size());
        itx.rollback();
    }
}

