/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.google.common.base.Joiner;
import com.thinkaurelius.titan.StorageSetup;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProviderTest;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class ElasticSearchIndexTest
extends IndexProviderTest {
    public IndexProvider openIndex() throws BackendException {
        return new ElasticSearchIndex(ElasticSearchIndexTest.getLocalESTestConfig());
    }

    public boolean supportsLuceneStyleQueries() {
        return true;
    }

    public static final Configuration getLocalESTestConfig() {
        String index = "es";
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.LOCAL_MODE, (Object)true, new String[]{"es"});
        config.set(ElasticSearchIndex.CLIENT_ONLY, (Object)false, new String[]{"es"});
        config.set(ElasticSearchIndex.TTL_INTERVAL, (Object)"5s", new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)StorageSetup.getHomeDir((String)"es"), new String[]{"es"});
        return config.restrictTo(new String[]{"es"});
    }

    @Test
    public void testSupport() {
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[0]), (TitanPredicate)Text.CONTAINS));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.TEXT)}), (TitanPredicate)Text.CONTAINS_PREFIX));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.TEXT)}), (TitanPredicate)Text.CONTAINS_REGEX));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.TEXT)}), (TitanPredicate)Text.REGEX));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)}), (TitanPredicate)Text.CONTAINS));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)}), (TitanPredicate)Text.PREFIX));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)}), (TitanPredicate)Text.REGEX));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)}), (TitanPredicate)Cmp.EQUAL));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)ElasticSearchIndexTest.of(String.class, (Parameter[])new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)}), (TitanPredicate)Cmp.NOT_EQUAL));
    }

    @Test
    public void testConfiguration() throws BackendException {
        String index = "es";
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.LOCAL_MODE, (Object)true, new String[]{"es"});
        config.set(ElasticSearchIndex.CLIENT_ONLY, (Object)true, new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_HOSTS, (Object)new String[]{"10.0.0.1"}, new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)StorageSetup.getHomeDir((String)"es"), new String[]{"es"});
        Configuration indexConfig = config.restrictTo(new String[]{"es"});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        idx.close();
        config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.LOCAL_MODE, (Object)false, new String[]{"es"});
        config.set(ElasticSearchIndex.CLIENT_ONLY, (Object)true, new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_HOSTS, (Object)new String[]{"10.0.0.1"}, new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)StorageSetup.getHomeDir((String)"es"), new String[]{"es"});
        indexConfig = config.restrictTo(new String[]{"es"});
        RuntimeException expectedException = null;
        try {
            idx = new ElasticSearchIndex(indexConfig);
            idx.close();
        }
        catch (RuntimeException re) {
            expectedException = re;
        }
        Assert.assertNotNull((Object)expectedException);
    }

    @Test
    public void testConfigurationFile() throws BackendException {
        String index = "es";
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.LOCAL_MODE, (Object)true, new String[]{"es"});
        config.set(ElasticSearchIndex.CLIENT_ONLY, (Object)true, new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_CONF_FILE, (Object)Joiner.on((String)File.separator).join((Object)"target", (Object)"test-classes", new Object[]{"es_nodename_foo.yml"}), new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)StorageSetup.getHomeDir((String)"es"), new String[]{"es"});
        Configuration indexConfig = config.restrictTo(new String[]{"es"});
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        idx.close();
        Assert.assertEquals((Object)"foo", (Object)idx.getNode().settings().get("node.name"));
        config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(ElasticSearchIndex.LOCAL_MODE, (Object)true, new String[]{"es"});
        config.set(ElasticSearchIndex.CLIENT_ONLY, (Object)true, new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_CONF_FILE, (Object)Joiner.on((String)File.separator).join((Object)"target", (Object)"test-classes", new Object[]{"es_nodename_bar.yml"}), new String[]{"es"});
        config.set(GraphDatabaseConfiguration.INDEX_DIRECTORY, (Object)StorageSetup.getHomeDir((String)"es"), new String[]{"es"});
        indexConfig = config.restrictTo(new String[]{"es"});
        idx = new ElasticSearchIndex(indexConfig);
        idx.close();
        Assert.assertEquals((Object)"bar", (Object)idx.getNode().settings().get("node.name"));
    }
}

