/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.thinkaurelius.titan.DaemonRunner;
import com.thinkaurelius.titan.diskstorage.es.ElasticsearchStatus;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchRunner
extends DaemonRunner<ElasticsearchStatus> {
    private final String homedir;
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchRunner.class);
    public static final String ES_PID_FILE = "/tmp/titan-test-es.pid";

    public ElasticsearchRunner() {
        this.homedir = ".";
    }

    public ElasticsearchRunner(String esHome) {
        this.homedir = esHome;
    }

    protected String getDaemonShortName() {
        return "Elasticsearch";
    }

    protected void killImpl(ElasticsearchStatus stat) throws IOException {
        log.info("Killing {} pid {}...", (Object)this.getDaemonShortName(), (Object)stat.getPid());
        ElasticsearchRunner.runCommand((String[])new String[]{"/bin/kill", String.valueOf(stat.getPid())});
        log.info("Sent SIGTERM to {} pid {}", (Object)this.getDaemonShortName(), (Object)stat.getPid());
        stat.getFile().delete();
        log.info("Deleted {}", (Object)stat.getFile());
    }

    protected ElasticsearchStatus startImpl() throws IOException {
        File data = new File(this.homedir + File.separator + "target" + File.separator + "es-data");
        File logs = new File(this.homedir + File.separator + "target" + File.separator + "es-logs");
        if (data.exists() && data.isDirectory()) {
            log.info("Deleting {}", (Object)data);
            FileUtils.deleteDirectory((File)data);
        }
        if (logs.exists() && logs.isDirectory()) {
            log.info("Deleting {}", (Object)logs);
            FileUtils.deleteDirectory((File)logs);
        }
        ElasticsearchRunner.runCommand((String[])new String[]{this.homedir + File.separator + "bin/elasticsearch", "-d", "-p", ES_PID_FILE});
        try {
            this.watchLogForStartup(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.readStatusFromDisk();
    }

    protected ElasticsearchStatus readStatusFromDisk() {
        return ElasticsearchStatus.read(ES_PID_FILE);
    }

    /*
     * Exception decompiling
     */
    private void watchLogForStartup(long duration, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

