/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.compat.h1;

import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.h1.MemoryMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class MapSequence {
    public static final String MAP_CLASSES = Tokens.makeNamespace(MapSequence.class) + ".mapClasses";

    public static class Map
    extends MemoryMapper<Writable, Writable, Writable, Writable> {
        private List<Mapper<Writable, Writable, Writable, Writable>> mappers = new ArrayList<Mapper<Writable, Writable, Writable, Writable>>();
        private List<Method> mapMethods = new ArrayList<Method>();
        private List<Method> cleanupMethods = new ArrayList<Method>();
        private int size = 0;
        private MemoryMapper.MemoryMapContext memoryContext;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.mappers.size() == 0) {
                try {
                    MemoryMapper.MemoryMapContext memoryContext = new MemoryMapper.MemoryMapContext(context);
                    String[] mapClassNames = context.getConfiguration().getStrings(MAP_CLASSES, new String[0]);
                    if (mapClassNames.length > 0) {
                        for (int i = 0; i < mapClassNames.length; ++i) {
                            memoryContext.stageConfiguration(i);
                            Class<?> mapClass = Class.forName(mapClassNames[i]);
                            Mapper mapper = (Mapper)mapClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                            try {
                                mapClass.getMethod("setup", Mapper.Context.class).invoke((Object)mapper, new Object[]{memoryContext});
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            this.mappers.add((Mapper<Writable, Writable, Writable, Writable>)mapper);
                            for (Method method : mapClass.getMethods()) {
                                if (!method.getName().equals("map")) continue;
                                this.mapMethods.add(method);
                                break;
                            }
                            try {
                                this.cleanupMethods.add(mapClass.getMethod("cleanup", Mapper.Context.class));
                                continue;
                            }
                            catch (NoSuchMethodException e) {
                                this.cleanupMethods.add(null);
                            }
                        }
                    }
                    this.size = this.mappers.size();
                    this.memoryContext = new MemoryMapper.MemoryMapContext(context);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }

        public void map(Writable key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.memoryContext.setContext(context);
                this.memoryContext.write(key, value);
                for (int i = 0; i < this.size - 1; ++i) {
                    this.mapMethods.get(i).invoke(this.mappers.get(i), new Object[]{this.memoryContext.getCurrentKey(), this.memoryContext.getCurrentValue(), this.memoryContext});
                    if (!this.memoryContext.nextKeyValue()) break;
                }
                if (this.memoryContext.nextKeyValue()) {
                    this.mapMethods.get(this.size - 1).invoke(this.mappers.get(this.size - 1), this.memoryContext.getCurrentKey(), this.memoryContext.getCurrentValue(), context);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                for (int i = 0; i < this.mappers.size(); ++i) {
                    Method cleanup = this.cleanupMethods.get(i);
                    if (null == cleanup) continue;
                    cleanup.invoke(this.mappers.get(i), context);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

