/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexQuery;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.io.WritableComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FaunusPathElement
extends FaunusElement
implements WritableComparable<FaunusElement>,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(FaunusPathElement.class);
    static final Tracker DEFAULT_TRACK = new Tracker();
    protected Tracker tracker;
    protected long pathCounter = 0L;
    protected Configuration configuration;
    private org.apache.hadoop.conf.Configuration hadoopConf;

    public FaunusPathElement(long id) {
        this((Configuration)ModifiableHadoopConfiguration.immutableWithResources(), id);
    }

    public FaunusPathElement(Configuration configuration, long id) {
        super(id);
        this.configuration = configuration;
        this.tracker = (Boolean)this.configuration.get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0]) != false ? new Tracker(this instanceof FaunusVertex ? new FaunusVertex.MicroVertex(this.id) : new StandardFaunusEdge.MicroEdge(this.id)) : DEFAULT_TRACK;
    }

    public void setConf(org.apache.hadoop.conf.Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        this.configuration = ModifiableHadoopConfiguration.of(hadoopConf);
        boolean trackPaths = (Boolean)this.configuration.get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0]);
        if (trackPaths) {
            this.tracker = new Tracker(this instanceof FaunusVertex ? new FaunusVertex.MicroVertex(this.id) : new StandardFaunusEdge.MicroEdge(this.id));
        }
    }

    public org.apache.hadoop.conf.Configuration getConf() {
        return this.hadoopConf;
    }

    public Configuration getFaunusConf() {
        return this.configuration;
    }

    @Override
    public FaunusSchemaManager getTypeManager() {
        return FaunusSchemaManager.getTypeManager(this.configuration);
    }

    @Override
    public FaunusVertexQuery query() {
        return new FaunusVertexQuery(this);
    }

    public boolean hasTrackPaths() {
        return this.tracker.trackPaths;
    }

    private void checkPathsEnabled() {
        Preconditions.checkState((boolean)this.hasTrackPaths(), (Object)"Path calculations are not enabled");
    }

    public void addPath(List<MicroElement> path, boolean append) throws IllegalStateException {
        this.checkPathsEnabled();
        if (append) {
            path.add(this.tracker.microVersion);
        }
        this.tracker.paths.add(path);
        log.trace("Added path {} to {} (append={})", new Object[]{path, this, append});
    }

    public void addPaths(List<List<MicroElement>> paths, boolean append) throws IllegalStateException {
        this.checkPathsEnabled();
        if (append) {
            for (List<MicroElement> path : paths) {
                this.addPath(path, append);
            }
        } else {
            this.tracker.paths.addAll(paths);
            log.trace("Adding all paths in list {} to {} (append={})", new Object[]{paths, this, append});
        }
    }

    public List<List<MicroElement>> getPaths() throws IllegalStateException {
        this.checkPathsEnabled();
        return this.tracker.paths;
    }

    public void getPaths(FaunusElement element, boolean append) {
        Preconditions.checkArgument((boolean)(element instanceof FaunusPathElement));
        if (this.hasTrackPaths()) {
            this.addPaths(((FaunusPathElement)element).getPaths(), append);
        } else {
            this.pathCounter += ((FaunusPathElement)element).pathCount();
        }
    }

    public long incrPath(long amount) throws IllegalStateException {
        if (this.hasTrackPaths()) {
            throw new IllegalStateException("Path calculations are enabled -- use addPath()");
        }
        this.pathCounter += amount;
        return this.pathCounter;
    }

    public boolean hasPaths() {
        if (this.hasTrackPaths()) {
            return !this.tracker.paths.isEmpty();
        }
        return this.pathCounter > 0L;
    }

    public void clearPaths() {
        if (this.hasTrackPaths()) {
            this.tracker.paths.clear();
        } else {
            this.pathCounter = 0L;
        }
        log.trace("Cleared paths on {}", (Object)this);
    }

    public long pathCount() {
        if (this.hasTrackPaths()) {
            return this.tracker.paths.size();
        }
        return this.pathCounter;
    }

    public void startPath() {
        if (this.hasTrackPaths()) {
            this.clearPaths();
            ArrayList<MicroElement> startPath = new ArrayList<MicroElement>();
            startPath.add(this.tracker.microVersion);
            this.tracker.paths.add(startPath);
        } else {
            this.pathCounter = 1L;
        }
    }

    public static abstract class MicroElement {
        protected final long id;

        public MicroElement(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public int hashCode() {
            return Long.valueOf(this.id).hashCode();
        }

        public boolean equals(Object object) {
            return object.getClass().equals(this.getClass()) && this.id == ((MicroElement)object).getId();
        }
    }

    protected static class Tracker {
        final boolean trackPaths;
        final List<List<MicroElement>> paths;
        final MicroElement microVersion;

        public Tracker(MicroElement microVersion) {
            this.trackPaths = true;
            this.microVersion = microVersion;
            this.paths = new ArrayList<List<MicroElement>>();
        }

        public Tracker(List<List<MicroElement>> paths, MicroElement microVersion) {
            this.trackPaths = true;
            this.microVersion = microVersion;
            this.paths = paths;
        }

        private Tracker() {
            this.trackPaths = false;
            this.paths = null;
            this.microVersion = null;
        }
    }
}

