/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.graphdb.schema.PropertyKeyDefinition;
import com.thinkaurelius.titan.graphdb.schema.RelationTypeDefinition;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusRelation;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import javax.annotation.Nullable;

public class FaunusPropertyKey<T>
extends FaunusRelationType
implements PropertyKey {
    public static final FaunusPropertyKey<Long> COUNT = new FaunusPropertyKey<Long>(new PropertyKeyDefinition("_count", -1L, Cardinality.SINGLE, Long.class), new Function<FaunusElement, Long>(){

        @Nullable
        public Long apply(@Nullable FaunusElement element) {
            if (element instanceof FaunusPathElement) {
                return ((FaunusPathElement)element).pathCount();
            }
            return 0L;
        }
    });
    public static final FaunusPropertyKey<Object> ID = new FaunusPropertyKey<Object>(new PropertyKeyDefinition("id", -1L, Cardinality.SINGLE, Long.class), new Function<FaunusElement, Object>(){

        @Nullable
        public Object apply(@Nullable FaunusElement element) {
            return element.getId();
        }
    });
    public static final FaunusPropertyKey<Long> _ID = new FaunusPropertyKey<Long>(new PropertyKeyDefinition("_id", -1L, Cardinality.SINGLE, Long.class), new Function<FaunusElement, Long>(){

        @Nullable
        public Long apply(@Nullable FaunusElement element) {
            return element.getLongId();
        }
    });
    public static final FaunusPropertyKey<String> LABEL = new FaunusPropertyKey<String>(new PropertyKeyDefinition("label", -1L, Cardinality.SINGLE, String.class), new Function<FaunusElement, String>(){

        @Nullable
        public String apply(@Nullable FaunusElement element) {
            if (element instanceof FaunusVertex) {
                return ((FaunusVertex)element).getLabel();
            }
            if (element instanceof FaunusRelation) {
                return ((FaunusRelation)((Object)element)).getType().getName();
            }
            return null;
        }
    });
    public static final FaunusPropertyKey VALUE = new FaunusPropertyKey(new PropertyKeyDefinition("_value", -1L, Cardinality.SINGLE, Object.class), false);
    private final PropertyKeyDefinition definition;
    private final Function<FaunusElement, T> implicitFunction;

    public FaunusPropertyKey(PropertyKeyDefinition definition, boolean isHidden) {
        this(definition, isHidden, false);
    }

    public FaunusPropertyKey(PropertyKeyDefinition definition, boolean isHidden, boolean isUnchecked) {
        super((RelationTypeDefinition)definition, isHidden, isUnchecked);
        this.definition = definition;
        this.implicitFunction = null;
    }

    public FaunusPropertyKey(PropertyKeyDefinition definition, Function<FaunusElement, T> implicitFunction) {
        super((RelationTypeDefinition)definition, false);
        Preconditions.checkArgument((definition.getCardinality() == Cardinality.SINGLE ? 1 : 0) != 0);
        this.definition = definition;
        this.implicitFunction = implicitFunction;
    }

    public Class<?> getDataType() {
        return this.definition.getDataType();
    }

    public Cardinality getCardinality() {
        return this.definition.getCardinality();
    }

    public boolean isPropertyKey() {
        return true;
    }

    public boolean isEdgeLabel() {
        return false;
    }

    public boolean isImplicit() {
        return this.implicitFunction != null;
    }

    public T computeImplicit(FaunusElement element) {
        Preconditions.checkArgument((boolean)this.isImplicit());
        return (T)this.implicitFunction.apply((Object)element);
    }
}

