/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.util.ReadArrayBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.database.serialize.StandardSerializer;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusProperty;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusRelation;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexLabel;
import com.thinkaurelius.titan.hadoop.LifeCycleElement;
import com.thinkaurelius.titan.hadoop.SimpleFaunusEdge;
import com.thinkaurelius.titan.hadoop.SimpleFaunusProperty;
import com.thinkaurelius.titan.hadoop.SimpleFaunusRelation;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.StandardFaunusProperty;
import com.thinkaurelius.titan.hadoop.StandardFaunusRelation;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaunusSerializer {
    private static volatile Serializer standardSerializer;
    private final FaunusSchemaManager types;
    private final boolean trackState;
    private final boolean trackPaths;
    private final Configuration configuration;
    private static final Logger log;

    public FaunusSerializer(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.types = FaunusSchemaManager.getTypeManager(configuration);
        this.configuration = configuration;
        this.trackState = (Boolean)configuration.get(TitanHadoopConfiguration.PIPELINE_TRACK_STATE, new String[0]);
        this.trackPaths = (Boolean)configuration.get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0]);
    }

    public void writeVertex(FaunusVertex vertex, DataOutput out) throws IOException {
        WritableUtils.writeVLong((DataOutput)out, (long)vertex.id);
        Schema schema = new Schema();
        vertex.updateSchema(schema);
        schema.writeSchema(out);
        this.writePathElement(vertex, schema, out);
        this.writeEdges(vertex, (SetMultimap<FaunusRelationType, FaunusRelation>)vertex.inAdjacency, out, Direction.IN, schema);
        FaunusVertexLabel vl = vertex.getVertexLabel();
        out.writeUTF(vl.isDefault() ? "" : vl.getName());
    }

    public void readVertex(FaunusVertex vertex, DataInput in) throws IOException {
        WritableUtils.readVLong((DataInput)in);
        Schema schema = this.readSchema(in);
        this.readPathElement(vertex, schema, in);
        vertex.inAdjacency = this.readEdges(vertex, in, Direction.IN, schema);
        String labelName = in.readUTF();
        vertex.setVertexLabel(StringUtils.isBlank((CharSequence)labelName) ? FaunusVertexLabel.DEFAULT_VERTEXLABEL : this.types.getVertexLabel(labelName));
    }

    public void writeEdge(StandardFaunusEdge edge, DataOutput out) throws IOException {
        this.writePathElement(edge, out);
        WritableUtils.writeVLong((DataOutput)out, (long)edge.inVertex);
        WritableUtils.writeVLong((DataOutput)out, (long)edge.outVertex);
        this.writeFaunusType(edge.getType(), out);
    }

    public void readEdge(StandardFaunusEdge edge, DataInput in) throws IOException {
        this.readPathElement(edge, in);
        edge.inVertex = WritableUtils.readVLong((DataInput)in);
        edge.outVertex = WritableUtils.readVLong((DataInput)in);
        edge.setLabel((FaunusEdgeLabel)this.readFaunusType(in));
    }

    public void writeProperty(StandardFaunusProperty property, DataOutput out) throws IOException {
        this.writePathElement(property, out);
        WritableUtils.writeVLong((DataOutput)out, (long)property.vertexid);
        this.serializeObject(out, property.getValue());
        this.writeFaunusType(property.getType(), out);
    }

    public void readProperty(StandardFaunusProperty property, DataInput in) throws IOException {
        this.readPathElement(property, in);
        property.vertexid = WritableUtils.readVLong((DataInput)in);
        property.value = this.deserializeObject(in);
        property.setKey((FaunusPropertyKey)this.readFaunusType(in));
    }

    private void readPathElement(FaunusPathElement element, DataInput in) throws IOException {
        this.readPathElement(element, null, in);
    }

    private void writePathElement(FaunusPathElement element, DataOutput out) throws IOException {
        this.writePathElement(element, null, out);
    }

    private void readPathElement(FaunusPathElement element, Schema schema, DataInput in) throws IOException {
        this.readElement(element, schema, in);
        if (this.trackPaths) {
            List<List<FaunusPathElement.MicroElement>> paths = this.readElementPaths(in);
            element.tracker = new FaunusPathElement.Tracker(paths, element instanceof FaunusVertex ? new FaunusVertex.MicroVertex(element.id) : new StandardFaunusEdge.MicroEdge(element.id));
            log.trace("readPathElement element={} paths={}", (Object)element, paths);
        } else {
            element.pathCounter = WritableUtils.readVLong((DataInput)in);
            element.tracker = FaunusPathElement.DEFAULT_TRACK;
        }
    }

    private void writePathElement(FaunusPathElement element, Schema schema, DataOutput out) throws IOException {
        this.writeElement(element, schema, out);
        if (this.trackPaths) {
            this.writeElementPaths(element.tracker.paths, out);
        } else {
            WritableUtils.writeVLong((DataOutput)out, (long)element.pathCounter);
        }
    }

    private void readElement(FaunusElement element, Schema schema, DataInput in) throws IOException {
        element.id = WritableUtils.readVLong((DataInput)in);
        if (this.trackState) {
            element.setLifeCycle(in.readByte());
        }
        element.outAdjacency = this.readEdges(element, in, Direction.OUT, schema);
    }

    private void writeElement(FaunusElement element, Schema schema, DataOutput out) throws IOException {
        Preconditions.checkArgument((this.trackState || !element.isRemoved() ? 1 : 0) != 0);
        WritableUtils.writeVLong((DataOutput)out, (long)element.id);
        if (this.trackState) {
            out.writeByte(element.getLifeCycle());
        }
        this.writeEdges(element, element.outAdjacency, out, Direction.OUT, schema);
    }

    private void serializeObject(DataOutput out, Object value) throws IOException {
        com.thinkaurelius.titan.graphdb.database.serialize.DataOutput o = this.getStandardSerializer().getDataOutput(40);
        o.writeClassAndObject(value);
        StaticBuffer buffer = o.getStaticBuffer();
        WritableUtils.writeVInt((DataOutput)out, (int)buffer.length());
        out.write((byte[])buffer.as(StaticBuffer.ARRAY_FACTORY));
    }

    private Object deserializeObject(DataInput in) throws IOException {
        int byteLength = WritableUtils.readVInt((DataInput)in);
        byte[] bytes = new byte[byteLength];
        in.readFully(bytes);
        ReadArrayBuffer buffer = new ReadArrayBuffer(bytes);
        return this.getStandardSerializer().readClassAndObject((ReadBuffer)buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Serializer getStandardSerializer() {
        if (null != standardSerializer) return standardSerializer;
        Class<FaunusSerializer> clazz = FaunusSerializer.class;
        synchronized (FaunusSerializer.class) {
            if (null != standardSerializer) return standardSerializer;
            int maxOutputBufSize = (Integer)this.configuration.get(TitanHadoopConfiguration.KRYO_MAX_OUTPUT_SIZE, new String[0]);
            standardSerializer = new StandardSerializer(true, maxOutputBufSize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return standardSerializer;
        }
    }

    private <T extends FaunusRelation> Iterable<T> filterDeletedRelations(Iterable<T> elements) {
        if (this.trackState) {
            return elements;
        }
        return Iterables.filter(elements, (Predicate)new Predicate<T>(){

            public boolean apply(@Nullable T element) {
                return !element.isRemoved();
            }
        });
    }

    private SetMultimap<FaunusRelationType, FaunusRelation> readEdges(FaunusElement element, DataInput in, Direction direction, Schema schema) throws IOException {
        HashMultimap adjacency = HashMultimap.create();
        int numTypes = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < numTypes; ++i) {
            FaunusRelationType type = schema == null ? this.readFaunusType(in) : schema.getType(WritableUtils.readVLong((DataInput)in));
            int size = WritableUtils.readVInt((DataInput)in);
            for (int j = 0; j < size; ++j) {
                LifeCycleElement relation;
                if (element instanceof FaunusVertex) {
                    if (type.isEdgeLabel()) {
                        StandardFaunusEdge edge = new StandardFaunusEdge(this.configuration);
                        edge.setLabel((FaunusEdgeLabel)type);
                        this.readPathElement(edge, schema, in);
                        long otherId = WritableUtils.readVLong((DataInput)in);
                        switch (direction) {
                            case IN: {
                                edge.inVertex = element.getLongId();
                                edge.outVertex = otherId;
                                break;
                            }
                            case OUT: {
                                edge.outVertex = element.getLongId();
                                edge.inVertex = otherId;
                                break;
                            }
                            default: {
                                throw ExceptionFactory.bothIsNotSupported();
                            }
                        }
                        relation = edge;
                        log.trace("readEdges edge={} paths={}", (Object)edge, edge.tracker.paths);
                    } else {
                        assert (type.isPropertyKey() && direction == Direction.OUT);
                        StandardFaunusProperty property = new StandardFaunusProperty(this.configuration);
                        property.setKey((FaunusPropertyKey)type);
                        this.readPathElement(property, schema, in);
                        property.value = this.deserializeObject(in);
                        relation = property;
                    }
                } else {
                    byte lifecycle;
                    byte by = lifecycle = this.trackState ? (byte)in.readByte() : (byte)-1;
                    if (type.isEdgeLabel()) {
                        relation = new SimpleFaunusEdge((FaunusEdgeLabel)type, new FaunusVertex(this.configuration, WritableUtils.readVLong((DataInput)in)));
                    } else {
                        assert (type.isPropertyKey() && direction == Direction.OUT);
                        relation = new SimpleFaunusProperty((FaunusPropertyKey)type, this.deserializeObject(in));
                    }
                    if (this.trackState) {
                        relation.setLifeCycle(lifecycle);
                    }
                }
                adjacency.put((Object)type, (Object)relation);
            }
        }
        if (adjacency.isEmpty()) {
            return FaunusElement.EMPTY_ADJACENCY;
        }
        return adjacency;
    }

    private void writeEdges(FaunusElement element, SetMultimap<FaunusRelationType, FaunusRelation> edges, DataOutput out, Direction direction, Schema schema) throws IOException {
        HashMap counts = Maps.newHashMap();
        int typeCount = 0;
        for (FaunusRelationType type : edges.keySet()) {
            int count = IterablesUtil.size(this.filterDeletedRelations(edges.get((Object)type)));
            counts.put(type, count);
            if (count <= 0) continue;
            ++typeCount;
        }
        WritableUtils.writeVInt((DataOutput)out, (int)typeCount);
        for (FaunusRelationType type : edges.keySet()) {
            if ((Integer)counts.get((Object)type) == 0) continue;
            if (schema == null) {
                this.writeFaunusType(type, out);
            } else {
                WritableUtils.writeVLong((DataOutput)out, (long)schema.getTypeId(type));
            }
            WritableUtils.writeVInt((DataOutput)out, (int)((Integer)counts.get((Object)type)));
            Iterable subset = this.filterDeletedRelations(edges.get((Object)type));
            for (FaunusRelation rel : subset) {
                if (element instanceof FaunusVertex) {
                    assert (rel instanceof StandardFaunusRelation);
                    this.writePathElement((StandardFaunusRelation)rel, schema, out);
                } else {
                    assert (rel instanceof SimpleFaunusRelation);
                    if (this.trackState) {
                        out.writeByte(((SimpleFaunusRelation)rel).getLifeCycle());
                    }
                }
                if (rel.isEdge()) {
                    WritableUtils.writeVLong((DataOutput)out, (long)((FaunusEdge)rel).getVertexId(direction.opposite()));
                    continue;
                }
                this.serializeObject(out, ((FaunusProperty)rel).getValue());
            }
        }
    }

    private void writeElementPaths(List<List<FaunusPathElement.MicroElement>> paths, DataOutput out) throws IOException {
        if (null == paths) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        } else {
            WritableUtils.writeVInt((DataOutput)out, (int)paths.size());
            for (List<FaunusPathElement.MicroElement> path : paths) {
                WritableUtils.writeVInt((DataOutput)out, (int)path.size());
                for (FaunusPathElement.MicroElement element : path) {
                    if (element instanceof FaunusVertex.MicroVertex) {
                        out.writeChar(118);
                    } else {
                        out.writeChar(101);
                    }
                    WritableUtils.writeVLong((DataOutput)out, (long)element.getId());
                }
            }
        }
    }

    private List<List<FaunusPathElement.MicroElement>> readElementPaths(DataInput in) throws IOException {
        int pathsSize = WritableUtils.readVInt((DataInput)in);
        if (pathsSize == 0) {
            return new ArrayList<List<FaunusPathElement.MicroElement>>();
        }
        ArrayList<List<FaunusPathElement.MicroElement>> paths = new ArrayList<List<FaunusPathElement.MicroElement>>(pathsSize);
        for (int i = 0; i < pathsSize; ++i) {
            int pathSize = WritableUtils.readVInt((DataInput)in);
            ArrayList<FaunusPathElement.MicroElement> path = new ArrayList<FaunusPathElement.MicroElement>(pathSize);
            for (int j = 0; j < pathSize; ++j) {
                char type = in.readChar();
                if (type == 'v') {
                    path.add(new FaunusVertex.MicroVertex(WritableUtils.readVLong((DataInput)in)));
                    continue;
                }
                path.add(new StandardFaunusEdge.MicroEdge(WritableUtils.readVLong((DataInput)in)));
            }
            paths.add(path);
        }
        return paths;
    }

    private void writeFaunusType(FaunusRelationType type, DataOutput out) throws IOException {
        out.writeByte(type.isPropertyKey() ? 0 : 1);
        out.writeUTF(type.getName());
    }

    private FaunusRelationType readFaunusType(DataInput in) throws IOException {
        byte type = in.readByte();
        String typeName = in.readUTF();
        assert (type == 0 || type == 1);
        if (type == 0) {
            return this.types.getOrCreatePropertyKey(typeName);
        }
        return this.types.getOrCreateEdgeLabel(typeName);
    }

    private Schema readSchema(DataInput in) throws IOException {
        int size = WritableUtils.readVInt((DataInput)in);
        Schema schema = new Schema(size);
        for (int i = 0; i < size; ++i) {
            schema.add(this.readFaunusType(in), WritableUtils.readVLong((DataInput)in));
        }
        return schema;
    }

    static {
        log = LoggerFactory.getLogger(FaunusSerializer.class);
        WritableComparator.define(FaunusPathElement.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(FaunusPathElement.class);
        }

        public int compare(byte[] element1, int start1, int length1, byte[] element2, int start2, int length2) {
            try {
                return Long.valueOf(Comparator.readVLong((byte[])element1, (int)start1)).compareTo(Comparator.readVLong((byte[])element2, (int)start2));
            }
            catch (IOException e) {
                return -1;
            }
        }

        public int compare(WritableComparable a, WritableComparable b) {
            if (a instanceof FaunusElement && b instanceof FaunusElement) {
                return Long.valueOf(((FaunusElement)a).getLongId()).compareTo(((FaunusElement)b).getLongId());
            }
            return super.compare(a, b);
        }
    }

    class Schema {
        private final BiMap<FaunusRelationType, Long> localTypes;
        private long count = 1L;

        private Schema() {
            this(8);
        }

        private Schema(int size) {
            this.localTypes = HashBiMap.create((int)size);
        }

        void add(String type) {
            this.add(FaunusSerializer.this.types.getRelationType(type));
        }

        void add(FaunusRelationType type) {
            if (!this.localTypes.containsKey((Object)type)) {
                this.localTypes.put((Object)type, (Object)this.count++);
            }
        }

        void addAll(Iterable<FaunusRelationType> types) {
            for (FaunusRelationType type : types) {
                this.add(type);
            }
        }

        long getTypeId(FaunusRelationType type) {
            Long id = (Long)this.localTypes.get((Object)type);
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)("Type is not part of the schema: " + (Object)((Object)type)));
            return id;
        }

        FaunusRelationType getType(long id) {
            FaunusRelationType type = (FaunusRelationType)((Object)this.localTypes.inverse().get((Object)id));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("Type is not part of the schema: " + id));
            return type;
        }

        private void add(FaunusRelationType type, long index) {
            Preconditions.checkArgument((!this.localTypes.containsValue((Object)index) ? 1 : 0) != 0);
            this.localTypes.put((Object)type, (Object)index);
            this.count = index + 1L;
        }

        private void writeSchema(DataOutput out) throws IOException {
            WritableUtils.writeVInt((DataOutput)out, (int)this.localTypes.size());
            for (Map.Entry entry : this.localTypes.entrySet()) {
                FaunusSerializer.this.writeFaunusType((FaunusRelationType)((Object)entry.getKey()), out);
                WritableUtils.writeVLong((DataOutput)out, (long)((Long)entry.getValue()));
            }
        }
    }
}

