/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusProperty;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusSerializer;
import com.thinkaurelius.titan.hadoop.FaunusVertexLabel;
import com.thinkaurelius.titan.hadoop.FaunusVertexQuery;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.StandardFaunusProperty;
import com.thinkaurelius.titan.hadoop.StandardFaunusRelation;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaunusVertex
extends FaunusPathElement
implements TitanVertex {
    private FaunusVertexLabel vertexLabel = FaunusVertexLabel.DEFAULT_VERTEXLABEL;
    private static final Logger log = LoggerFactory.getLogger(FaunusVertex.class);

    public FaunusVertex() {
        this((Configuration)ModifiableHadoopConfiguration.immutableWithResources());
    }

    public FaunusVertex(Configuration configuration) {
        this(configuration, -1L);
    }

    public FaunusVertex(Configuration configuration, long id) {
        super(configuration, id);
    }

    public FaunusVertex(Configuration configuration, DataInput in) throws IOException {
        super(configuration, -1L);
        this.readFields(in);
    }

    public void addAll(FaunusVertex vertex) {
        this.id = vertex.getLongId();
        this.initializeAdjacency(Direction.BOTH);
        this.inAdjacency.putAll((Multimap)vertex.inAdjacency);
        this.outAdjacency.putAll((Multimap)vertex.outAdjacency);
        this.getPaths(vertex, false);
        this.lifecycle = vertex.getLifeCycle();
        this.addEdges(Direction.BOTH, vertex);
    }

    @Override
    void updateSchema(FaunusSerializer.Schema schema) {
        super.updateSchema(schema);
        for (TitanRelation edge : this.query().queryAll().relations()) {
            assert (edge instanceof StandardFaunusRelation);
            ((StandardFaunusRelation)edge).updateSchema(schema);
        }
    }

    public void setVertexLabel(FaunusVertexLabel label) {
        this.vertexLabel = label;
    }

    public void setVertexLabel(String label) {
        this.setVertexLabel(this.getTypeManager().getVertexLabel(label));
    }

    public String getLabel() {
        return this.vertexLabel.getName();
    }

    public FaunusVertexLabel getVertexLabel() {
        return this.vertexLabel;
    }

    @Override
    public void setProperty(FaunusRelationType type, Object value) {
        Preconditions.checkArgument((boolean)type.isPropertyKey(), (Object)("Expected property key: " + (Object)((Object)type)));
        super.setRelation(new StandardFaunusProperty(this, (FaunusPropertyKey)type, value));
    }

    public FaunusProperty addProperty(FaunusProperty property) {
        return (FaunusProperty)super.addRelation(property);
    }

    public TitanProperty addProperty(PropertyKey key, Object value) {
        Preconditions.checkArgument((boolean)(key instanceof FaunusPropertyKey));
        return this.addProperty(new StandardFaunusProperty(this, (FaunusPropertyKey)key, value));
    }

    public FaunusProperty addProperty(String key, Object value) {
        FaunusPropertyKey type = this.getTypeManager().getOrCreatePropertyKey(key);
        return (FaunusProperty)this.addProperty(type, value);
    }

    public Iterable<TitanProperty> getProperties() {
        return this.query().properties();
    }

    public Iterable<TitanProperty> getProperties(PropertyKey key) {
        return ((FaunusVertexQuery)this.query().type((RelationType)key)).properties();
    }

    public Iterable<TitanProperty> getProperties(String key) {
        return ((FaunusVertexQuery)this.query().keys(new String[]{key})).properties();
    }

    public long getPropertyCount() {
        return Iterables.size(this.getProperties());
    }

    public <T> Iterable<T> getPropertyValues(String key) {
        FaunusPropertyKey type = this.getTypeManager().getOrCreatePropertyKey(key);
        return Iterables.transform(((FaunusVertexQuery)this.query().type((RelationType)type)).properties(), (Function)new Function<TitanProperty, T>(){

            @Nullable
            public T apply(@Nullable TitanProperty prop) {
                return prop.getValue();
            }
        });
    }

    public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
        return ((FaunusVertexQuery)((FaunusVertexQuery)this.query().direction(direction)).labels(labels)).vertices();
    }

    public Iterable<TitanEdge> getTitanEdges(Direction d, EdgeLabel ... labels) {
        return ((FaunusVertexQuery)((FaunusVertexQuery)this.query().direction(d)).types((RelationType[])labels)).titanEdges();
    }

    public Iterable<Edge> getEdges(Direction direction, String ... labels) {
        return ((FaunusVertexQuery)((FaunusVertexQuery)this.query().direction(direction)).labels(labels)).edges();
    }

    public Iterable<TitanEdge> getEdges() {
        return this.query().titanEdges();
    }

    public Iterable<TitanRelation> getRelations() {
        return this.query().relations();
    }

    public long getEdgeCount() {
        return this.query().count();
    }

    public boolean isConnected() {
        return !Iterables.isEmpty(this.getEdges());
    }

    public Set<FaunusEdgeLabel> getEdgeLabels(Direction direction) {
        return Sets.newHashSet((Iterable)Iterables.transform(this.query().titanEdges(), (Function)new Function<TitanEdge, FaunusEdgeLabel>(){

            @Nullable
            public FaunusEdgeLabel apply(@Nullable TitanEdge edge) {
                return (FaunusEdgeLabel)edge.getType();
            }
        }));
    }

    private void addEdges(List<StandardFaunusEdge> edges) {
        for (FaunusEdge faunusEdge : edges) {
            super.addRelation(faunusEdge);
        }
    }

    public StandardFaunusEdge addEdge(Direction dir, StandardFaunusEdge edge) {
        return this.addEdge(edge);
    }

    public StandardFaunusEdge addEdge(StandardFaunusEdge edge) {
        return (StandardFaunusEdge)super.addRelation(edge);
    }

    public void addEdges(Direction direction, FaunusVertex vertex) {
        for (TitanEdge edge : ((FaunusVertexQuery)vertex.query().direction(direction)).titanEdges()) {
            log.trace("Copying edge {} from vertex {} to vertex {}", new Object[]{edge, vertex, this});
            this.addEdge((StandardFaunusEdge)edge);
        }
    }

    public FaunusEdge addEdge(String label, Vertex inVertex) {
        return this.addEdge(label, (TitanVertex)inVertex);
    }

    public FaunusEdge addEdge(Direction direction, String label, long otherVertexId) {
        if (direction == Direction.OUT) {
            return this.addEdge(new StandardFaunusEdge(this.configuration, this.getLongId(), otherVertexId, label));
        }
        if (direction == Direction.IN) {
            return this.addEdge(new StandardFaunusEdge(this.configuration, otherVertexId, this.getLongId(), label));
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public FaunusEdge addEdge(EdgeLabel label, TitanVertex vertex) {
        return this.addEdge(new StandardFaunusEdge(this.configuration, this.getLongId(), vertex.getLongId(), (FaunusEdgeLabel)label));
    }

    public FaunusEdge addEdge(String label, TitanVertex vertex) {
        return this.addEdge(this.getTypeManager().getOrCreateEdgeLabel(label), vertex);
    }

    public void removeEdgesToFrom(Set<Long> ids) {
        Iterator<TitanEdge> iterator = this.query().titanEdges().iterator();
        while (iterator.hasNext()) {
            TitanEdge next = iterator.next();
            if (!ids.contains(next.getOtherVertex((TitanVertex)this).getLongId())) continue;
            iterator.remove();
        }
    }

    private void removeAllEdges(Direction dir, FaunusRelationType ... types) {
        if (types == null || types.length == 0) {
            return;
        }
        Iterator<TitanEdge> iterator = ((FaunusVertexQuery)((FaunusVertexQuery)this.query().direction(dir)).types((RelationType[])types)).titanEdges().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public void removeEdges(Tokens.Action action, Direction direction, String ... stringLabels) {
        FaunusRelationType[] labels = new FaunusEdgeLabel[stringLabels.length];
        for (int i = 0; i < stringLabels.length; ++i) {
            labels[i] = this.getTypeManager().getOrCreateEdgeLabel(stringLabels[i]);
        }
        if (action.equals((Object)Tokens.Action.KEEP)) {
            for (Direction dir : Direction.proper) {
                if (direction != Direction.BOTH && direction != dir) continue;
                if (labels.length > 0) {
                    Set<FaunusEdgeLabel> removal = this.getEdgeLabels(dir);
                    removal.removeAll(Arrays.asList(labels));
                    this.removeAllEdges(dir, removal.toArray(new FaunusRelationType[0]));
                    continue;
                }
                if (direction != dir) continue;
                this.removeAllEdges(dir.opposite(), this.getEdgeLabels(dir.opposite()).toArray(new FaunusRelationType[0]));
            }
        } else {
            assert (action.equals((Object)Tokens.Action.DROP));
            if (labels.length == 0) {
                this.removeAllEdges(direction, this.getEdgeLabels(direction).toArray(new FaunusRelationType[0]));
            } else {
                this.removeAllEdges(direction, labels);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        new FaunusSerializer(this.configuration).writeVertex(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        new FaunusSerializer(this.configuration).readVertex(this, in);
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public static class MicroVertex
    extends FaunusPathElement.MicroElement {
        private static final String V1 = "v[";
        private static final String V2 = "]";

        public MicroVertex(long id) {
            super(id);
        }

        public String toString() {
            return V1 + this.id + V2;
        }
    }
}

