/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.QueryDescription;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.schema.SchemaInspector;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.DirectionCondition;
import com.thinkaurelius.titan.graphdb.query.condition.IncidenceCondition;
import com.thinkaurelius.titan.graphdb.query.condition.IncidenceDirectionCondition;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.query.condition.RelationTypeCondition;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQueryBuilder;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusRelation;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.SimpleFaunusProperty;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaunusVertexQuery
extends BaseVertexCentricQueryBuilder<FaunusVertexQuery>
implements TitanVertexQuery<FaunusVertexQuery> {
    private FaunusPathElement baseElement = null;
    private static final Logger log = LoggerFactory.getLogger(FaunusVertexQuery.class);
    private boolean queryAll;
    private static final SystemFilterCondition FILTER_HIDDEN_AND_REMOVED = new SystemFilterCondition();

    public FaunusVertexQuery(FaunusPathElement element) {
        this(element.getTypeManager());
        this.baseElement = element;
    }

    protected FaunusVertexQuery(FaunusSchemaManager typeManager) {
        super((SchemaInspector)typeManager);
    }

    public FaunusVertexQuery queryAll() {
        this.queryAll = true;
        return this.getThis();
    }

    protected FaunusVertexQuery getThis() {
        return this;
    }

    protected TitanVertex getVertex(long vertexid) {
        return new FaunusVertex(this.baseElement.getFaunusConf(), vertexid);
    }

    protected And<TitanRelation> getCondition(FaunusElement element, RelationCategory returnType) {
        FaunusSchemaManager typeManager = element.getTypeManager();
        if (!(element instanceof FaunusVertex)) {
            Preconditions.checkArgument((this.dir != Direction.IN ? 1 : 0) != 0, (String)"Illegal direction for element: %s", (Object[])new Object[]{this.dir});
            this.dir = Direction.OUT;
        }
        And conditions = new And(this.constraints.size() + 4);
        if (this.types.length > 0) {
            Or typeConstraints = new Or(this.types.length);
            for (String type : this.types) {
                FaunusRelationType rt = typeManager.getRelationType(type);
                if (rt == null) continue;
                typeConstraints.add((Condition)new RelationTypeCondition((RelationType)rt));
            }
            if (typeConstraints.isEmpty()) {
                return null;
            }
            conditions.add((Condition)typeConstraints);
        }
        for (PredicateCondition constraint : this.constraints) {
            FaunusRelationType type = typeManager.getRelationType((String)constraint.getKey());
            if (type == null) {
                if (constraint.getPredicate() == Cmp.EQUAL && constraint.getValue() == null) continue;
                return null;
            }
            conditions.add((Condition)new PredicateCondition((Object)type, constraint.getPredicate(), constraint.getValue()));
        }
        conditions.add((Condition)returnType);
        Preconditions.checkArgument((returnType == RelationCategory.EDGE || this.adjacentVertex == null ? 1 : 0) != 0, (Object)"Adjacent vertex constraints only applies when querying for edges");
        if (element instanceof FaunusVertex) {
            if (this.dir != Direction.BOTH) {
                conditions.add((Condition)new DirectionCondition((TitanVertex)((FaunusVertex)element), this.dir));
            }
            if (this.adjacentVertex != null) {
                conditions.add((Condition)new IncidenceCondition((TitanVertex)((FaunusVertex)element), this.adjacentVertex));
            }
        } else if (this.adjacentVertex != null) {
            conditions.add((Condition)new IncidenceDirectionCondition(this.dir.opposite(), this.adjacentVertex));
        }
        if (!this.queryAll) {
            conditions.add((Condition)FILTER_HIDDEN_AND_REMOVED);
        }
        return conditions;
    }

    protected Iterable<FaunusRelation> getRelations(FaunusElement element, RelationCategory returnType) {
        FaunusSchemaManager typeManager = element.getTypeManager();
        And<TitanRelation> condition = this.getCondition(element, returnType);
        if (condition == null) {
            return Collections.EMPTY_LIST;
        }
        Iterable<FaunusRelation> result = null;
        for (Direction direction : Direction.proper) {
            if (this.dir != direction && this.dir != Direction.BOTH) continue;
            SetMultimap<FaunusRelationType, FaunusRelation> adjacency = element.getAdjacency(direction);
            if (this.types.length == 0) {
                if (result == null) {
                    result = adjacency.values();
                    continue;
                }
                result = Iterables.concat((Iterable)result, (Iterable)adjacency.values());
                continue;
            }
            for (String type : this.types) {
                FaunusPropertyKey key;
                Object value;
                FaunusRelationType rt = typeManager.getRelationType(type);
                if (rt == null) continue;
                Collection rels = rt.isPropertyKey() && ((FaunusPropertyKey)rt).isImplicit() ? ((value = (key = (FaunusPropertyKey)rt).computeImplicit(element)) != null ? Lists.newArrayList((Object[])new FaunusRelation[]{new SimpleFaunusProperty(key, value)}) : Collections.EMPTY_LIST) : adjacency.get((Object)rt);
                result = result == null ? rels : Iterables.concat((Iterable)result, (Iterable)rels);
            }
        }
        result = new FilterIterable((Condition)condition, element, result, this.dir);
        if (!this.orders.isEmpty()) {
            ArrayList allRels = Lists.newArrayList((Iterable)result);
            Collections.sort(allRels, this.orders);
            result = new RemoveOriginalIterable(allRels, element, this.dir);
        }
        if (this.limit != Integer.MAX_VALUE) {
            result = Iterables.limit((Iterable)result, (int)this.limit);
        }
        return result;
    }

    protected Predicate<FaunusRelation> getFilter(FaunusElement element, RelationCategory returnType) {
        final And<TitanRelation> condition = this.getCondition(element, returnType);
        if (condition == null) {
            return Predicates.alwaysFalse();
        }
        if (this.limit == Integer.MAX_VALUE) {
            return new Predicate<FaunusRelation>(){

                public boolean apply(@Nullable FaunusRelation faunusRelation) {
                    return condition.evaluate((TitanElement)faunusRelation);
                }
            };
        }
        final HashSet matchingRels = Sets.newHashSet(this.getRelations(element, returnType));
        return new Predicate<FaunusRelation>(){

            public boolean apply(@Nullable FaunusRelation faunusRelation) {
                return matchingRels.contains(faunusRelation);
            }
        };
    }

    protected Iterable<FaunusRelation> getRelations(RelationCategory returnType) {
        Preconditions.checkState((this.baseElement != null ? 1 : 0) != 0, (Object)"Query not correctly initialized");
        return this.getRelations(this.baseElement, returnType);
    }

    public Iterable<Edge> edges() {
        return this.getRelations(RelationCategory.EDGE);
    }

    public Iterable<TitanEdge> titanEdges() {
        return this.getRelations(RelationCategory.EDGE);
    }

    public Iterable<TitanProperty> properties() {
        this.dir = Direction.OUT;
        return this.getRelations(RelationCategory.PROPERTY);
    }

    public Iterable<TitanRelation> relations() {
        return this.getRelations(RelationCategory.RELATION);
    }

    public Iterable<Vertex> vertices() {
        return Iterables.transform(this.titanEdges(), (Function)new Function<TitanEdge, Vertex>(){

            @Nullable
            public Vertex apply(@Nullable TitanEdge edge) {
                if (FaunusVertexQuery.this.dir != Direction.BOTH) {
                    return edge.getVertex(FaunusVertexQuery.this.dir.opposite());
                }
                assert (FaunusVertexQuery.this.baseElement instanceof FaunusVertex);
                return edge.getOtherVertex((TitanVertex)((FaunusVertex)FaunusVertexQuery.this.baseElement));
            }
        });
    }

    public VertexList vertexIds() {
        FaunusVertexList list = new FaunusVertexList();
        for (Vertex v : this.vertices()) {
            list.add((FaunusVertex)v);
        }
        return list;
    }

    public long count() {
        return Iterables.size(this.titanEdges());
    }

    public long propertyCount() {
        return Iterables.size(this.properties());
    }

    public QueryDescription describeForEdges() {
        throw new UnsupportedOperationException();
    }

    public QueryDescription describeForProperties() {
        throw new UnsupportedOperationException();
    }

    private static class FilterIterable
    implements Iterable<FaunusRelation> {
        private final Condition<TitanRelation> condition;
        private final FaunusElement element;
        private final Iterable<FaunusRelation> original;
        private final Direction dir;

        private FilterIterable(Condition<TitanRelation> condition, FaunusElement element, Iterable<FaunusRelation> original, Direction dir) {
            this.condition = condition;
            this.element = element;
            this.original = original;
            this.dir = dir;
        }

        @Override
        public Iterator<FaunusRelation> iterator() {
            return new Iterator<FaunusRelation>(){
                private final Iterator<FaunusRelation> iter;
                private FaunusRelation next;
                private FaunusRelation current;
                private boolean reachedEnd;
                {
                    this.iter = FilterIterable.this.original.iterator();
                    this.next = null;
                    this.current = null;
                    this.reachedEnd = false;
                }

                @Override
                public boolean hasNext() {
                    while (this.next == null) {
                        if (!this.iter.hasNext()) {
                            return false;
                        }
                        FaunusRelation candidate = this.iter.next();
                        if (!FilterIterable.this.condition.evaluate((TitanElement)candidate)) continue;
                        this.next = candidate;
                    }
                    if (this.next == null) {
                        this.reachedEnd = true;
                    }
                    return this.next != null;
                }

                @Override
                public FaunusRelation next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    assert (this.next != null);
                    this.current = this.next;
                    this.next = null;
                    return this.current;
                }

                @Override
                public void remove() {
                    if (this.next == null && !this.reachedEnd) {
                        this.current.updateLifeCycle(ElementLifeCycle.Event.REMOVED);
                        if (this.current.isNew()) {
                            this.iter.remove();
                            if (FilterIterable.this.dir.equals((Object)Direction.BOTH) || FilterIterable.this.dir.equals((Object)Direction.IN)) {
                                ((FilterIterable)FilterIterable.this).element.inAdjacency.remove((Object)this.current.getType(), (Object)this.current);
                            }
                            if (FilterIterable.this.dir.equals((Object)Direction.BOTH) || FilterIterable.this.dir.equals((Object)Direction.OUT)) {
                                ((FilterIterable)FilterIterable.this).element.outAdjacency.remove((Object)this.current.getType(), (Object)this.current);
                            }
                        }
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    FilterIterable.this.element.updateLifeCycle(ElementLifeCycle.Event.REMOVED_RELATION);
                }
            };
        }
    }

    private static class RemoveOriginalIterable
    implements Iterable<FaunusRelation> {
        private final Iterable<FaunusRelation> original;
        private final FaunusElement element;
        private final Direction dir;

        private RemoveOriginalIterable(Iterable<FaunusRelation> original, FaunusElement element, Direction dir) {
            this.original = original;
            this.element = element;
            this.dir = dir;
        }

        @Override
        public Iterator<FaunusRelation> iterator() {
            return new Iterator<FaunusRelation>(){
                private FaunusRelation current = null;
                private final Iterator<FaunusRelation> iter = RemoveOriginalIterable.access$700(RemoveOriginalIterable.this).iterator();

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public FaunusRelation next() {
                    this.current = this.iter.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    this.current.updateLifeCycle(ElementLifeCycle.Event.REMOVED);
                    if (this.current.isNew()) {
                        if (RemoveOriginalIterable.this.dir.equals((Object)Direction.BOTH) || RemoveOriginalIterable.this.dir.equals((Object)Direction.IN)) {
                            log.trace("edge removal: edge={} direction={} (in)", (Object)this.current, (Object)RemoveOriginalIterable.this.dir);
                            ((RemoveOriginalIterable)RemoveOriginalIterable.this).element.inAdjacency.remove((Object)this.current.getType(), (Object)this.current);
                        }
                        if (RemoveOriginalIterable.this.dir.equals((Object)Direction.BOTH) || RemoveOriginalIterable.this.dir.equals((Object)Direction.OUT)) {
                            log.trace("edge removal: edge={} direction={} (out)", (Object)this.current, (Object)RemoveOriginalIterable.this.dir);
                            ((RemoveOriginalIterable)RemoveOriginalIterable.this).element.outAdjacency.remove((Object)this.current.getType(), (Object)this.current);
                        }
                    }
                    RemoveOriginalIterable.this.element.updateLifeCycle(ElementLifeCycle.Event.REMOVED_RELATION);
                }
            };
        }

        static /* synthetic */ Iterable access$700(RemoveOriginalIterable x0) {
            return x0.original;
        }
    }

    private static class SystemFilterCondition
    extends Literal<TitanRelation>
    implements Condition<TitanRelation> {
        private SystemFilterCondition() {
        }

        public boolean evaluate(TitanRelation relation) {
            FaunusRelation rel = (FaunusRelation)relation;
            return !rel.getType().isHiddenType() && !rel.isRemoved();
        }
    }

    private static class FaunusVertexList
    implements VertexList {
        private boolean isSorted = false;
        private final List<FaunusVertex> list = new ArrayList<FaunusVertex>();

        private FaunusVertexList() {
        }

        public int size() {
            return this.list.size();
        }

        public FaunusVertex get(int pos) {
            return this.list.get(pos);
        }

        public boolean add(FaunusVertex vertex) {
            this.isSorted = false;
            return this.list.add(vertex);
        }

        public void sort() {
            Collections.sort(this.list);
            this.isSorted = true;
        }

        public boolean isSorted() {
            return this.isSorted;
        }

        public VertexList subList(int fromPosition, int length) {
            FaunusVertexList newList = new FaunusVertexList();
            newList.list.addAll(this.list.subList(fromPosition, fromPosition + length));
            return newList;
        }

        public LongArrayList getIDs() {
            LongArrayList arr = new LongArrayList(this.size());
            for (FaunusVertex v : this.list) {
                arr.add(v.getLongId());
            }
            return arr;
        }

        public long getID(int pos) {
            return this.get(pos).getLongId();
        }

        public Iterator<TitanVertex> iterator() {
            return this.list.iterator();
        }
    }
}

