/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.SimpleFaunusRelation;
import com.tinkerpop.blueprints.Direction;

public class SimpleFaunusEdge
extends SimpleFaunusRelation
implements FaunusEdge {
    private final FaunusEdgeLabel label;
    private final FaunusVertex vertex;

    public SimpleFaunusEdge(FaunusEdgeLabel label, FaunusVertex vertex) {
        Preconditions.checkArgument((boolean)label.isUnidirected(), (String)"Invalid edge label: %s", (Object[])new Object[]{label});
        this.label = label;
        this.vertex = vertex;
    }

    @Override
    protected Object otherValue() {
        return this.vertex;
    }

    public EdgeLabel getEdgeLabel() {
        return this.label;
    }

    public TitanVertex getVertex(Direction dir) {
        if (dir != Direction.IN) {
            throw new UnsupportedOperationException();
        }
        return this.vertex;
    }

    @Override
    public long getVertexId(Direction dir) {
        if (dir != Direction.IN) {
            throw new UnsupportedOperationException();
        }
        return this.vertex.getLongId();
    }

    public String getLabel() {
        return this.label.getName();
    }

    public TitanVertex getOtherVertex(TitanVertex vertex) {
        throw new UnsupportedOperationException();
    }

    public boolean isDirected() {
        return this.label.isDirected();
    }

    public boolean isUnidirected() {
        return this.label.isUnidirected();
    }

    @Override
    public FaunusRelationType getType() {
        return this.label;
    }
}

