/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.hadoop.FaunusProperty;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusSerializer;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusRelation;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFaunusProperty
extends StandardFaunusRelation
implements FaunusProperty {
    protected long vertexid;
    protected Object value;
    private static final Logger log = LoggerFactory.getLogger(StandardFaunusProperty.class);

    public StandardFaunusProperty() {
        this((Configuration)ModifiableHadoopConfiguration.immutableWithResources());
    }

    public StandardFaunusProperty(Configuration configuration) {
        super(configuration, -1L, FaunusPropertyKey.VALUE);
    }

    public StandardFaunusProperty(Configuration configuration, DataInput in) throws IOException {
        super(configuration, -1L, FaunusPropertyKey.VALUE);
        this.readFields(in);
    }

    public StandardFaunusProperty(FaunusVertex vertex, FaunusPropertyKey type, Object value) {
        this(-1L, vertex, type, value);
    }

    public StandardFaunusProperty(long id, FaunusVertex vertex, String type, Object value) {
        this(id, vertex, vertex.getTypeManager().getOrCreatePropertyKey(type), value);
    }

    public StandardFaunusProperty(long id, FaunusVertex vertex, FaunusPropertyKey type, Object value) {
        this(vertex.getFaunusConf(), id, vertex.getLongId(), type, value);
    }

    public StandardFaunusProperty(Configuration config, long id, long vertex, FaunusPropertyKey type, Object value) {
        super(config, id, type);
        Preconditions.checkArgument((vertex >= 0L ? 1 : 0) != 0, (String)"Vertex id %d", (Object[])new Object[]{vertex});
        Preconditions.checkNotNull((Object)value, (Object)"property value must be non-null");
        Preconditions.checkArgument((!type.isImplicit() ? 1 : 0) != 0, (Object)("Cannot set implicit properties: " + (Object)((Object)type)));
        Preconditions.checkArgument((AttributeUtil.hasGenericDataType((PropertyKey)type) || type.getDataType().isInstance(value) ? 1 : 0) != 0, (String)"Value does not match data type: %s", (Object[])new Object[]{value});
        this.value = value;
        this.vertexid = vertex;
        log.debug("Initialized property {}", (Object)this);
    }

    public Object getValue() {
        return this.value;
    }

    public PropertyKey getPropertyKey() {
        return (PropertyKey)this.getType();
    }

    public TitanVertex getVertex() {
        return this.getVertex(0);
    }

    @Override
    public TitanVertex getVertex(int pos) {
        Preconditions.checkArgument((pos == 0 ? 1 : 0) != 0, (String)"Invalid position: %s", (Object[])new Object[]{pos});
        return new FaunusVertex(this.getFaunusConf(), this.vertexid);
    }

    final void setKey(FaunusPropertyKey key) {
        Preconditions.checkNotNull((Object)((Object)key));
        this.setType(key);
    }

    public void write(DataOutput out) throws IOException {
        new FaunusSerializer(this.getFaunusConf()).writeProperty(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        new FaunusSerializer(this.getFaunusConf()).readProperty(this, in);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.vertexid).append(this.getLongId()).append((Object)this.getType()).append(this.value).toHashCode();
    }

    @Override
    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !(oth instanceof TitanProperty)) {
            return false;
        }
        TitanProperty p = (TitanProperty)oth;
        if (this.hasId() || p.hasId()) {
            return this.getLongId() == p.getLongId();
        }
        return this.getType().equals(p.getPropertyKey()) && this.value.equals(p.getValue()) && this.vertexid == p.getVertex().getLongId();
    }

    public String toString() {
        return this.getTypeName() + "->" + (null != this.value ? this.value.toString() : null);
    }
}

