/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.compat;

import com.thinkaurelius.titan.hadoop.compat.HadoopCompat;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCompatLoader {
    private static final Logger log = LoggerFactory.getLogger(HadoopCompatLoader.class);
    public static final HadoopCompat DEFAULT_COMPAT = HadoopCompatLoader.getCompat();

    public static HadoopCompat getCompat() {
        String ver = VersionInfo.getVersion();
        log.debug("Read Hadoop VersionInfo string {}", (Object)ver);
        String pkgName = HadoopCompatLoader.class.getPackage().getName();
        String className = ver.startsWith("1.") ? pkgName + ".h1.Hadoop1Compat" : pkgName + ".h2.Hadoop2Compat";
        log.debug("Attempting to load class {} and instantiate with nullary constructor", (Object)className);
        try {
            Constructor<?> ctor = Class.forName(className).getConstructor(new Class[0]);
            log.debug("Invoking constructor {}", ctor);
            return (HadoopCompat)ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

