/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.compat.h1;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class MemoryMapper<A, B, C, D>
extends Mapper<A, B, C, D> {

    public class MemoryMapContext
    extends Mapper.Context {
        private static final String DASH = "-";
        private static final String EMPTY = "";
        private final Configuration currentConfiguration;
        private Writable key;
        private Writable value;
        private Writable tempKey;
        private Writable tempValue;
        private Mapper.Context context;
        private Configuration globalConfiguration;

        public MemoryMapContext(Mapper.Context context) throws IOException, InterruptedException {
            super((Mapper)MemoryMapper.this, context.getConfiguration(), context.getTaskAttemptID() == null ? new TaskAttemptID() : context.getTaskAttemptID(), null, null, context.getOutputCommitter(), null, context.getInputSplit());
            this.currentConfiguration = new Configuration();
            this.key = null;
            this.value = null;
            this.tempKey = null;
            this.tempValue = null;
            this.context = context;
            this.globalConfiguration = context.getConfiguration();
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            this.key = (Writable)key;
            this.value = (Writable)value;
        }

        public Writable getCurrentKey() {
            this.tempKey = this.key;
            this.key = null;
            return this.tempKey;
        }

        public Writable getCurrentValue() {
            this.tempValue = this.value;
            this.value = null;
            return this.tempValue;
        }

        public boolean nextKeyValue() {
            return this.key != null && this.value != null;
        }

        public Counter getCounter(String groupName, String counterName) {
            return this.context.getCounter(groupName, counterName);
        }

        public Counter getCounter(Enum counterName) {
            return this.context.getCounter(counterName);
        }

        public Configuration getConfiguration() {
            return this.currentConfiguration;
        }

        public void setContext(Mapper.Context context) {
            this.context = context;
        }

        public void stageConfiguration(int step) {
            String key;
            this.currentConfiguration.clear();
            for (Map.Entry entry : this.globalConfiguration) {
                key = (String)entry.getKey();
                if (key.matches(".*-[0-9]+")) continue;
                this.currentConfiguration.set(key, (String)entry.getValue());
            }
            for (Map.Entry entry : this.globalConfiguration) {
                key = (String)entry.getKey();
                if (!key.endsWith(DASH + step)) continue;
                this.currentConfiguration.set(key.replace(DASH + step, EMPTY), (String)entry.getValue());
            }
        }
    }
}

