/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.compat.h2;

import com.thinkaurelius.titan.graphdb.configuration.TitanConstants;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompiler;
import com.thinkaurelius.titan.hadoop.config.HBaseAuthHelper;
import com.thinkaurelius.titan.hadoop.mapreduce.AbstractHadoopCompiler;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop2Compiler
extends AbstractHadoopCompiler
implements HadoopCompiler {
    private static final String ARROW = " > ";
    private static final String MAPREDUCE_MAP_OUTPUT_COMPRESS = "mapreduce.map.output.compress";
    private static final String MAPREDUCE_MAP_OUTPUT_COMPRESS_CODEC = "mapreduce.map.output.compress.codec";
    public static final Logger logger = LoggerFactory.getLogger(Hadoop2Compiler.class);
    private State state = State.NONE;
    static final String JOB_JAR = "titan-hadoop-2-" + TitanConstants.VERSION + "-job.jar";
    private static final String MAPRED_JAR = "mapred.jar";

    @Override
    protected Logger getLog() {
        return logger;
    }

    public Hadoop2Compiler(HadoopGraph graph) {
        super(graph);
    }

    @Override
    protected String getMapReduceJarConfigKey() {
        return MAPRED_JAR;
    }

    @Override
    protected String getDefaultMapReduceJar() {
        return JOB_JAR;
    }

    private String makeClassName(Class klass) {
        return klass.getCanonicalName().replace(klass.getPackage().getName() + ".", "");
    }

    @Override
    public void addMapReduce(Class<? extends Mapper> mapper, Class<? extends Reducer> combiner, Class<? extends Reducer> reducer, Class<? extends WritableComparable> mapOutputKey, Class<? extends WritableComparable> mapOutputValue, Class<? extends WritableComparable> reduceOutputKey, Class<? extends WritableComparable> reduceOutputValue, Configuration configuration) {
        this.addMapReduce(mapper, combiner, reducer, null, mapOutputKey, mapOutputValue, reduceOutputKey, reduceOutputValue, configuration);
    }

    @Override
    public void addMapReduce(Class<? extends Mapper> mapper, Class<? extends Reducer> combiner, Class<? extends Reducer> reducer, Class<? extends WritableComparator> comparator, Class<? extends WritableComparable> mapOutputKey, Class<? extends WritableComparable> mapOutputValue, Class<? extends WritableComparable> reduceOutputKey, Class<? extends WritableComparable> reduceOutputValue, Configuration configuration) {
        Configuration mergedConf = Hadoop2Compiler.overlayConfiguration(this.getConf(), configuration);
        try {
            Job job;
            if (State.NONE == this.state || State.REDUCER == this.state) {
                job = Job.getInstance((Configuration)mergedConf);
                job.setJobName(this.makeClassName(mapper) + ARROW + this.makeClassName(reducer));
                HBaseAuthHelper.setHBaseAuthToken(mergedConf, job);
                this.jobs.add(job);
            } else {
                job = (Job)this.jobs.get(this.jobs.size() - 1);
                job.setJobName(job.getJobName() + ARROW + this.makeClassName(mapper) + ARROW + this.makeClassName(reducer));
            }
            job.setNumReduceTasks(this.getConf().getInt("mapreduce.job.reduces", this.getConf().getInt("mapreduce.tasktracker.reduce.tasks.maximum", 1)));
            ChainMapper.addMapper((Job)job, mapper, NullWritable.class, FaunusVertex.class, mapOutputKey, mapOutputValue, (Configuration)mergedConf);
            ChainReducer.setReducer((Job)job, reducer, mapOutputKey, mapOutputValue, reduceOutputKey, reduceOutputValue, (Configuration)mergedConf);
            if (null != comparator) {
                job.setSortComparatorClass(comparator);
            }
            if (null != combiner) {
                job.setCombinerClass(combiner);
            }
            if (null == job.getConfiguration().get(MAPREDUCE_MAP_OUTPUT_COMPRESS, null)) {
                job.getConfiguration().setBoolean(MAPREDUCE_MAP_OUTPUT_COMPRESS, true);
            }
            if (null == job.getConfiguration().get(MAPREDUCE_MAP_OUTPUT_COMPRESS_CODEC, null)) {
                job.getConfiguration().setClass(MAPREDUCE_MAP_OUTPUT_COMPRESS_CODEC, DefaultCodec.class, CompressionCodec.class);
            }
            this.state = State.REDUCER;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void addMap(Class<? extends Mapper> mapper, Class<? extends WritableComparable> mapOutputKey, Class<? extends WritableComparable> mapOutputValue, Configuration configuration) {
        Configuration mergedConf = Hadoop2Compiler.overlayConfiguration(this.getConf(), configuration);
        try {
            Job job;
            if (State.NONE == this.state) {
                job = Job.getInstance((Configuration)mergedConf);
                job.setNumReduceTasks(0);
                job.setJobName(this.makeClassName(mapper));
                HBaseAuthHelper.setHBaseAuthToken(mergedConf, job);
                this.jobs.add(job);
            } else {
                job = (Job)this.jobs.get(this.jobs.size() - 1);
                job.setJobName(job.getJobName() + ARROW + this.makeClassName(mapper));
            }
            if (State.MAPPER == this.state || State.NONE == this.state) {
                ChainMapper.addMapper((Job)job, mapper, NullWritable.class, FaunusVertex.class, mapOutputKey, mapOutputValue, (Configuration)mergedConf);
                job.setOutputKeyClass(mapOutputKey);
                job.setOutputValueClass(mapOutputValue);
                this.state = State.MAPPER;
                logger.info("Added mapper " + job.getJobName() + " via ChainMapper with output (" + mapOutputKey + "," + mapOutputValue + "); current state is " + (Object)((Object)this.state));
            } else {
                ChainReducer.addMapper((Job)job, mapper, NullWritable.class, FaunusVertex.class, mapOutputKey, mapOutputValue, (Configuration)mergedConf);
                this.state = State.REDUCER;
                logger.info("Added mapper " + job.getJobName() + " via ChainReducer with output (" + mapOutputKey + "," + mapOutputValue + "); current state is " + (Object)((Object)this.state));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void completeSequence() {
    }

    private static Configuration overlayConfiguration(Configuration base, Configuration overrides) {
        Configuration mergedConf = new Configuration(base);
        for (Map.Entry ent : overrides) {
            mergedConf.set((String)ent.getKey(), (String)ent.getValue());
        }
        return mergedConf;
    }

    static enum State {
        MAPPER,
        REDUCER,
        NONE;

    }
}

