/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.util.TitanSchemaAwareMapper;
import com.tinkerpop.blueprints.Direction;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class EdgeListInputMapReduce {

    public static class Reduce
    extends Reducer<LongWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private Configuration faunusConf;

        public void setup(Reducer.Context context) {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
        }

        public void reduce(LongWritable key, Iterable<FaunusVertex> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            for (FaunusVertex value : values) {
                vertex.addEdges(Direction.BOTH, value);
                vertex.addAllProperties(value.getPropertyCollection());
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_CREATED, 1L);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_PROPERTIES_CREATED, vertex.getPropertyCollection().size());
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_CREATED, Iterables.size(vertex.getEdges(Direction.OUT, new String[0])));
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_CREATED, Iterables.size(vertex.getEdges(Direction.IN, new String[0])));
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, FaunusVertex, LongWritable, FaunusVertex> {
        private Configuration faunusConf;

        public void setup(Reducer.Context context) {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
        }

        public void reduce(LongWritable key, Iterable<FaunusVertex> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            for (FaunusVertex value : values) {
                vertex.addEdges(Direction.BOTH, value);
                vertex.addAllProperties(value.getPropertyCollection());
            }
            context.write((Object)key, (Object)vertex);
        }
    }

    public static class Map
    extends TitanSchemaAwareMapper<NullWritable, FaunusElement, LongWritable, FaunusVertex> {
        private final HashMap<Long, FaunusVertex> map = new HashMap();
        private static final int MAX_MAP_SIZE = 5000;
        private final LongWritable longWritable = new LongWritable();
        private int counter = 0;
        private Configuration faunusConf;

        @Override
        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
        }

        public void map(NullWritable key, FaunusElement value, Mapper.Context context) throws IOException, InterruptedException {
            if (value instanceof StandardFaunusEdge) {
                long outId = ((StandardFaunusEdge)value).getVertexId(Direction.OUT);
                long inId = ((StandardFaunusEdge)value).getVertexId(Direction.IN);
                FaunusVertex vertex = this.map.get(outId);
                if (null == vertex) {
                    vertex = new FaunusVertex(this.faunusConf, outId);
                    this.map.put(outId, vertex);
                }
                vertex.addEdge(Direction.OUT, (StandardFaunusEdge)WritableUtils.clone((Writable)((StandardFaunusEdge)value), (org.apache.hadoop.conf.Configuration)HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context)));
                ++this.counter;
                vertex = this.map.get(inId);
                if (null == vertex) {
                    vertex = new FaunusVertex(this.faunusConf, inId);
                    this.map.put(inId, vertex);
                }
                vertex.addEdge(Direction.IN, (StandardFaunusEdge)WritableUtils.clone((Writable)((StandardFaunusEdge)value), (org.apache.hadoop.conf.Configuration)HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context)));
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_PROCESSED, 1L);
                ++this.counter;
            } else {
                long id = value.getLongId();
                FaunusVertex vertex = this.map.get(id);
                if (null == vertex) {
                    vertex = new FaunusVertex(this.faunusConf, id);
                    this.map.put(id, vertex);
                }
                vertex.addAllProperties(value.getPropertyCollection());
                vertex.addEdges(Direction.BOTH, (FaunusVertex)WritableUtils.clone((Writable)((FaunusVertex)value), (org.apache.hadoop.conf.Configuration)HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context)));
                ++this.counter;
            }
            if (this.counter > 5000) {
                this.flush(context);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.flush(context);
        }

        private void flush(Mapper.Context context) throws IOException, InterruptedException {
            for (FaunusVertex vertex : this.map.values()) {
                this.longWritable.set(vertex.getLongId());
                context.write((Object)this.longWritable, (Object)vertex);
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_EMITTED, 1L);
            }
            this.map.clear();
            this.counter = 0;
        }
    }

    public static enum Counters {
        EDGES_PROCESSED,
        VERTICES_EMITTED,
        IN_EDGES_CREATED,
        OUT_EDGES_CREATED,
        VERTICES_CREATED,
        VERTEX_PROPERTIES_CREATED;

    }
}

