/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class EdgeListRecordWriter
extends RecordWriter<NullWritable, FaunusVertex> {
    protected DataOutputStream out;
    private static final String UTF8 = "UTF-8";
    private static final byte[] NEWLINE;
    private static final byte[] TAB;

    public EdgeListRecordWriter(DataOutputStream out) {
        this.out = out;
    }

    public void write(NullWritable key, FaunusVertex vertex) throws IOException {
        if (null != vertex) {
            byte[] id = vertex.getId().toString().getBytes(UTF8);
            for (Edge edge : vertex.getEdges(Direction.OUT, new String[0])) {
                this.out.write(id);
                this.out.write(TAB);
                this.out.write(edge.getVertex(Direction.IN).getId().toString().getBytes(UTF8));
                this.out.write(TAB);
                this.out.write(edge.getLabel().getBytes(UTF8));
                this.out.write(NEWLINE);
            }
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    static {
        try {
            NEWLINE = "\n".getBytes(UTF8);
            TAB = "\t".getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Can not find UTF-8 encoding");
        }
    }
}

