/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist.rdf;

import com.google.common.base.Predicate;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import javax.annotation.Nullable;
import org.openrdf.rio.RDFFormat;

public class RDFConfig {
    public static final String URI = "uri";
    public static final String CONTEXT = "context";
    public static final String NAME = "name";
    public static final ConfigNamespace ROOT_NS = new ConfigNamespace(null, "rdf", "RDF MapReduce format options");
    public static final ConfigOption<Syntax> RDF_FORMAT = new ConfigOption(ROOT_NS, "format", "The format/syntax/dialect of the RDF input file(s)", ConfigOption.Type.LOCAL, Syntax.class);
    public static final ConfigOption<Boolean> RDF_USE_LOCALNAME = new ConfigOption(ROOT_NS, "use-localname", "Whether to tolerate fragments when parsing RDF input", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<Boolean> RDF_LITERAL_AS_PROPERTY = new ConfigOption(ROOT_NS, "literal-as-property", "Whether to turn RDF triples where the object is a literal value into properties on the subject, where the property name is the predicate and the property value is the literal object.", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<String[]> RDF_AS_PROPERTIES = new ConfigOption(ROOT_NS, "as-properties", "A comma-separated list of predicate URIs for which matching triples will be converted into properties instead of edges", ConfigOption.Type.LOCAL, String[].class, (Object)new String[0], (Predicate)new Predicate<String[]>(){

        public boolean apply(@Nullable String[] input) {
            return null != input;
        }
    });
    public static final ConfigOption<String> RDF_BASE_URI = new ConfigOption(ROOT_NS, "base-uri", "The URI used to resolve any relative URI references encountered in the input", ConfigOption.Type.LOCAL, (Object)"http://thinkaurelius.com#");

    public static enum Syntax {
        RDF_XML(RDFFormat.RDFXML),
        N_TRIPLES(RDFFormat.NTRIPLES),
        TURTLE(RDFFormat.TURTLE),
        N3(RDFFormat.N3),
        TRIX(RDFFormat.TRIX),
        TRIG(RDFFormat.TRIG);

        private final RDFFormat fmt;

        private Syntax(RDFFormat fmt) {
            this.fmt = fmt;
        }

        public RDFFormat getRDFFormat() {
            return this.fmt;
        }
    }
}

