/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.graphson;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.formats.graphson.HadoopGraphSONUtility;
import com.tinkerpop.blueprints.Vertex;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GraphSONRecordWriter
extends RecordWriter<NullWritable, FaunusVertex> {
    private static final String UTF8 = "UTF-8";
    private static final byte[] NEWLINE;
    private final DataOutputStream out;
    private final HadoopGraphSONUtility graphsonUtil;

    public GraphSONRecordWriter(HadoopGraphSONUtility graphsonUtil, DataOutputStream out) {
        this.graphsonUtil = graphsonUtil;
        this.out = out;
    }

    public void write(NullWritable key, FaunusVertex vertex) throws IOException {
        if (null != vertex) {
            this.out.write(this.graphsonUtil.toJSON((Vertex)vertex).toString().getBytes(UTF8));
            this.out.write(NEWLINE);
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    static {
        try {
            NEWLINE = "\n".getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Can not find UTF-8 encoding");
        }
    }
}

