/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.hbase;

import com.thinkaurelius.titan.diskstorage.hbase.HBaseStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.formats.hbase.TitanHBaseRecordReader;
import com.thinkaurelius.titan.hadoop.formats.util.TitanInputFormat;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetupCommon;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanHBaseInputFormat
extends TitanInputFormat {
    private static final Logger log = LoggerFactory.getLogger(TitanHBaseInputFormat.class);
    private final TableInputFormat tableInputFormat = new TableInputFormat();
    private byte[] edgestoreFamily;

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.tableInputFormat.getSplits(jobContext);
    }

    public RecordReader<NullWritable, FaunusVertex> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new TitanHBaseRecordReader(this, this.vertexQuery, (TableRecordReader)this.tableInputFormat.createRecordReader(inputSplit, taskAttemptContext), this.edgestoreFamily);
    }

    @Override
    public void setConf(Configuration config) {
        super.setConf(config);
        config.set("hbase.mapreduce.inputtable", (String)this.inputConf.get(HBaseStoreManager.HBASE_TABLE, new String[0]));
        config.set("hbase.zookeeper.quorum", ((String[])this.inputConf.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]))[0]);
        if (this.inputConf.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            config.set("hbase.zookeeper.property.clientPort", String.valueOf(this.inputConf.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])));
        }
        config.set("autotype", "none");
        log.debug("hbase.security.authentication={}", (Object)config.get("hbase.security.authentication"));
        Scan scanner = new Scan();
        if (((Boolean)this.inputConf.get(HBaseStoreManager.SHORT_CF_NAMES, new String[0])).booleanValue()) {
            scanner.addFamily("e".getBytes());
            this.edgestoreFamily = Bytes.toBytes((String)"e");
        } else {
            scanner.addFamily("edgestore".getBytes());
            this.edgestoreFamily = Bytes.toBytes((String)"edgestore");
        }
        scanner.setFilter(this.getColumnFilter(TitanHadoopSetupCommon.getDefaultSliceQuery()));
        try {
            Method converter = TableMapReduceUtil.class.getDeclaredMethod("convertScanToString", Scan.class);
            converter.setAccessible(true);
            config.set("hbase.mapreduce.scan", (String)converter.invoke(null, scanner));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tableInputFormat.setConf(config);
    }

    private Filter getColumnFilter(SliceQuery query) {
        return null;
    }

    public Configuration getConf() {
        return this.tableInputFormat.getConf();
    }
}

