/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.hbase;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexQueryFilter;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.hbase.TitanHBaseHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.hbase.TitanHBaseInputFormat;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TitanHBaseRecordReader
extends RecordReader<NullWritable, FaunusVertex> {
    private TableRecordReader reader;
    private TitanHBaseInputFormat inputFormat;
    private TitanHBaseHadoopGraph graph;
    private FaunusVertexQueryFilter vertexQuery;
    private Configuration configuration;
    private FaunusVertex vertex;
    private final byte[] edgestoreFamilyBytes;

    public TitanHBaseRecordReader(TitanHBaseInputFormat inputFormat, FaunusVertexQueryFilter vertexQuery, TableRecordReader reader, byte[] edgestoreFamilyBytes) {
        this.inputFormat = inputFormat;
        this.vertexQuery = vertexQuery;
        this.reader = reader;
        this.edgestoreFamilyBytes = edgestoreFamilyBytes;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.graph = new TitanHBaseHadoopGraph(this.inputFormat.getGraphSetup());
        this.reader.initialize(inputSplit, taskAttemptContext);
        this.configuration = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration(taskAttemptContext));
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.reader.nextKeyValue()) {
            FaunusVertex temp = this.graph.readHadoopVertex(this.configuration, this.reader.getCurrentKey().copyBytes(), (NavigableMap)this.reader.getCurrentValue().getMap().get(this.edgestoreFamilyBytes));
            if (null == temp) continue;
            this.vertex = temp;
            this.vertexQuery.filterRelationsOf(this.vertex);
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public FaunusVertex getCurrentValue() throws IOException, InterruptedException {
        return this.vertex;
    }

    public void close() throws IOException {
        this.graph.close();
        this.reader.close();
    }

    public float getProgress() {
        return this.reader.getProgress();
    }
}

