/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusProperty;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.util.system.IOUtils;
import com.tinkerpop.gremlin.groovy.jsr223.DefaultImportCustomizerProvider;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import com.tinkerpop.gremlin.groovy.jsr223.ImportCustomizerProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderScriptWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoaderScriptWrapper.class);
    private static final String TASK_IO_CONTEXT = "org.apache.hadoop.mapreduce.TaskInputOutputContext";
    private static final DefaultImportCustomizerProvider importCustomizer = new DefaultImportCustomizerProvider((Set)ImmutableSet.of((Object)FaunusVertex.class.getCanonicalName(), (Object)FaunusEdge.class.getCanonicalName(), (Object)FaunusProperty.class.getCanonicalName(), (Object)TitanGraph.class.getCanonicalName(), (Object)TitanVertex.class.getCanonicalName(), (Object)TitanEdge.class.getCanonicalName(), (Object[])new String[]{TitanProperty.class.getCanonicalName(), Logger.class.getCanonicalName(), "org.apache.hadoop.mapreduce.TaskInputOutputContext"}), (Set)ImmutableSet.of());
    static final String EDGE_METHOD_NAME = "getOrCreateEdge";
    static final String VERTEX_METHOD_NAME = "getOrCreateVertex";
    static final String VERTEX_PROP_METHOD_NAME = "getOrCreateVertexProperty";
    private final GremlinGroovyScriptEngine loaderEngine;
    private final CompiledScript vertexMethod;
    private final CompiledScript vpropMethod;
    private final CompiledScript edgeMethod;
    private static final ImmutableMap<String, String> vertexArguments = ImmutableMap.of((Object)"faunusVertex", (Object)FaunusVertex.class.getCanonicalName(), (Object)"graph", (Object)TitanGraph.class.getCanonicalName(), (Object)"context", (Object)"org.apache.hadoop.mapreduce.TaskInputOutputContext", (Object)"log", (Object)Logger.class.getCanonicalName());
    private static final ImmutableMap<String, String> vpropArguments = ImmutableMap.of((Object)"titanProperty", (Object)TitanProperty.class.getCanonicalName(), (Object)"vertex", (Object)TitanVertex.class.getCanonicalName(), (Object)"graph", (Object)TitanGraph.class.getCanonicalName(), (Object)"context", (Object)"org.apache.hadoop.mapreduce.TaskInputOutputContext", (Object)"log", (Object)Logger.class.getCanonicalName());
    private static final ImmutableMap<String, String> edgeArguments;

    public LoaderScriptWrapper(FileSystem fs, Path scriptPath) throws IOException {
        String scriptString = LoaderScriptWrapper.getScriptString(fs, scriptPath);
        this.loaderEngine = new GremlinGroovyScriptEngine((ImportCustomizerProvider)importCustomizer);
        this.vertexMethod = LoaderScriptWrapper.getVertexMethod(scriptString, this.loaderEngine);
        this.vpropMethod = LoaderScriptWrapper.getVPropMethod(scriptString, this.loaderEngine);
        this.edgeMethod = LoaderScriptWrapper.getEdgeMethod(scriptString, this.loaderEngine);
        if (null == this.vertexMethod && null == this.vpropMethod && null == this.edgeMethod) {
            throw new RuntimeException("No methods could be compiled from the loader script " + scriptPath + ".  See Slf4j log output for debugging info.");
        }
    }

    public boolean hasVertexMethod() {
        return null != this.vertexMethod;
    }

    public boolean hasVPropMethod() {
        return null != this.vpropMethod;
    }

    public boolean hasEdgeMethod() {
        return null != this.edgeMethod;
    }

    public TitanVertex getVertex(FaunusVertex faunusVertex, TitanGraph graph, Mapper.Context context) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("faunusVertex", (Object)faunusVertex);
        bindings.put("graph", (Object)graph);
        bindings.put("context", (Object)context);
        bindings.put("log", (Object)LOGGER);
        HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_LOADER_SCRIPT_CALLS, 1L);
        try {
            TitanVertex tv = (TitanVertex)this.vertexMethod.eval(bindings);
            LOGGER.debug("Compiled vertex loader script returned {}", (Object)tv);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_LOADER_SCRIPT_RETURNS, 1L);
            return tv;
        }
        catch (ScriptException e) {
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_LOADER_SCRIPT_EXCEPTIONS, 1L);
            throw new RuntimeException(e);
        }
    }

    public void getVProp(TitanProperty titanProperty, TitanVertex vertex, TitanGraph graph, Mapper.Context context) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("titanProperty", (Object)titanProperty);
        bindings.put("vertex", (Object)vertex);
        bindings.put("graph", (Object)graph);
        bindings.put("context", (Object)context);
        bindings.put("log", (Object)LOGGER);
        HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_PROP_LOADER_SCRIPT_CALLS, 1L);
        try {
            this.vpropMethod.eval(bindings);
            LOGGER.debug("Compiled property loader method invoked");
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_PROP_LOADER_SCRIPT_RETURNS, 1L);
        }
        catch (ScriptException e) {
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_PROP_LOADER_SCRIPT_EXCEPTIONS, 1L);
            throw new RuntimeException(e);
        }
    }

    public TitanEdge getEdge(FaunusEdge faunusEdge, TitanVertex in, TitanVertex out, TitanGraph graph, Mapper.Context context) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("faunusEdge", (Object)faunusEdge);
        bindings.put("inVertex", (Object)in);
        bindings.put("outVertex", (Object)out);
        bindings.put("graph", (Object)graph);
        bindings.put("context", (Object)context);
        bindings.put("log", (Object)LOGGER);
        HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGE_LOADER_SCRIPT_CALLS, 1L);
        try {
            TitanEdge edge = (TitanEdge)this.edgeMethod.eval(bindings);
            LOGGER.debug("Compiled edge method returned {}", (Object)edge);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGE_LOADER_SCRIPT_RETURNS, 1L);
            return edge;
        }
        catch (ScriptException e) {
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGE_LOADER_SCRIPT_EXCEPTIONS, 1L);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getScriptString(FileSystem fs, Path scriptPath) throws IOException {
        String string;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)fs.open(scriptPath));
            StringWriter wr = new StringWriter();
            org.apache.commons.io.IOUtils.copy((Reader)isr, (Writer)wr);
            string = wr.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)isr);
        return string;
    }

    private static CompiledScript getVertexMethod(String script, GremlinGroovyScriptEngine loaderEngine) {
        return LoaderScriptWrapper.getMethod(script, loaderEngine, VERTEX_METHOD_NAME, vertexArguments);
    }

    private static CompiledScript getVPropMethod(String script, GremlinGroovyScriptEngine loaderEngine) {
        return LoaderScriptWrapper.getMethod(script, loaderEngine, VERTEX_PROP_METHOD_NAME, vpropArguments);
    }

    private static CompiledScript getEdgeMethod(String script, GremlinGroovyScriptEngine loaderEngine) {
        return LoaderScriptWrapper.getMethod(script, loaderEngine, EDGE_METHOD_NAME, edgeArguments);
    }

    private static CompiledScript getMethod(String script, GremlinGroovyScriptEngine loaderEngine, String methodName, Map<String, String> args) {
        CompiledScript compiled = null;
        StringBuilder metaString = new StringBuilder();
        metaString.append(script);
        StringBuilder callString = new StringBuilder();
        callString.append(metaString.toString());
        String argTypeString = Joiner.on((String)",").join(args.values());
        metaString.append("\n");
        metaString.append(String.format("metaClass.getMetaMethod('%s', %s) != null", methodName, argTypeString));
        String argNameString = Joiner.on((String)",").join(args.keySet());
        String invocation = String.format("%s(%s)", methodName, argNameString);
        callString.append("\n");
        callString.append(invocation);
        try {
            LOGGER.debug("Check script:\n{}", (Object)metaString.toString());
            LOGGER.debug("Loader script:\n{}", (Object)callString.toString());
            CompiledScript checkScript = loaderEngine.compile(metaString.toString());
            Boolean s = (Boolean)checkScript.eval();
            if (null != s && s.booleanValue()) {
                compiled = loaderEngine.compile(callString.toString());
            }
            LOGGER.info("Tested whether script contained method {}: {}/{}", new Object[]{invocation, s, compiled});
        }
        catch (RuntimeException e) {
            LOGGER.info("Custom loader script does not define {}", (Object)invocation, (Object)e);
        }
        catch (ScriptException e) {
            LOGGER.info("Custom loader script does not define {}", (Object)invocation, (Object)e);
        }
        return compiled;
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)"faunusEdge", (Object)FaunusEdge.class.getCanonicalName());
        b.put((Object)"inVertex", (Object)TitanVertex.class.getCanonicalName());
        b.put((Object)"outVertex", (Object)TitanVertex.class.getCanonicalName());
        b.put((Object)"graph", (Object)TitanGraph.class.getCanonicalName());
        b.put((Object)"context", (Object)TASK_IO_CONTEXT);
        b.put((Object)"log", (Object)Logger.class.getCanonicalName());
        edgeArguments = b.build();
    }

    public static enum Counters {
        VERTEX_LOADER_SCRIPT_CALLS,
        VERTEX_LOADER_SCRIPT_EXCEPTIONS,
        VERTEX_LOADER_SCRIPT_RETURNS,
        EDGE_LOADER_SCRIPT_CALLS,
        EDGE_LOADER_SCRIPT_EXCEPTIONS,
        EDGE_LOADER_SCRIPT_RETURNS,
        VERTEX_PROP_LOADER_SCRIPT_CALLS,
        VERTEX_PROP_LOADER_SCRIPT_EXCEPTIONS,
        VERTEX_PROP_LOADER_SCRIPT_RETURNS;

    }
}

