/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.hadoop.FaunusEdge;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusProperty;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexLabel;
import com.thinkaurelius.titan.hadoop.FaunusVertexQuery;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.StandardFaunusProperty;
import com.thinkaurelius.titan.hadoop.StandardFaunusRelation;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.util.LoaderScriptWrapper;
import com.thinkaurelius.titan.hadoop.formats.util.TitanOutputFormat;
import com.tinkerpop.blueprints.Direction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanGraphOutputMapReduce {
    public static final Logger LOGGER = LoggerFactory.getLogger(TitanGraphOutputMapReduce.class);
    public static final String TITAN_ID = "_bId0192834";
    public static final String ID_MAP_KEY = "_iDMaPKeY";
    private static final String HADOOP_VERTEX = "hadoopVertex";
    private static final String HADOOP_EDGE = "hadoopEdge";
    private static final String TITAN_OUT_VERTEX = "titanOutVertex";
    private static final String TITAN_IN_VERTEX = "titanInVertex";
    private static final String GRAPH = "graph";
    private static final String MAP_CONTEXT = "mapContext";

    public static TitanGraph generateGraph(ModifiableHadoopConfiguration titanConf) {
        Class<OutputFormat> format = titanConf.getClass(TitanHadoopConfiguration.OUTPUT_FORMAT, OutputFormat.class, OutputFormat.class);
        if (TitanOutputFormat.class.isAssignableFrom(format)) {
            ModifiableConfiguration mc = titanConf.getOutputConf();
            boolean present = mc.has(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0]);
            LOGGER.trace("Keyspace in_config=" + present + " value=" + (String)mc.get(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0]));
            TitanGraph g = TitanFactory.open((BasicConfiguration)mc);
            return g;
        }
        throw new RuntimeException("The provide graph output format is not a supported TitanOutputFormat: " + format.getName());
    }

    private static Object getValue(TitanRelation relation, TitanGraph graph) {
        if (relation.isProperty()) {
            return ((TitanProperty)relation).getValue();
        }
        return graph.getVertex(((TitanEdge)relation).getVertex(Direction.IN).getLongId());
    }

    private static TitanRelation getCreateOrDeleteRelation(TitanGraph graph, boolean trackState, Direction dir, FaunusVertex faunusVertex, TitanVertex titanVertex, StandardFaunusRelation faunusRelation, Mapper.Context context) {
        TitanRelation titanRelation;
        assert (dir == Direction.IN || dir == Direction.OUT);
        if (trackState && (faunusRelation.isModified() || faunusRelation.isRemoved())) {
            Map<Long, Long> idMap = TitanGraphOutputMapReduce.getIdMap(faunusVertex);
            titanRelation = TitanGraphOutputMapReduce.getIncidentRelation(graph, dir, titanVertex, faunusRelation, faunusRelation.isEdge() ? idMap.get(((FaunusEdge)((Object)faunusRelation)).getVertexId(dir.opposite())) : null);
            if (null == titanRelation) {
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.NULL_RELATIONS_IGNORED, 1L);
                return null;
            }
            if (faunusRelation.isRemoved()) {
                titanRelation.remove();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, faunusRelation.isEdge() ? Counters.EDGES_REMOVED : Counters.VERTEX_PROPERTIES_REMOVED, 1L);
                return null;
            }
        } else {
            if (trackState && faunusRelation.isLoaded()) {
                return null;
            }
            assert (faunusRelation.isNew());
            if (faunusRelation.isEdge()) {
                StandardFaunusEdge faunusEdge = (StandardFaunusEdge)faunusRelation;
                TitanVertex otherVertex = TitanGraphOutputMapReduce.getOtherTitanVertex(faunusVertex, faunusEdge, dir.opposite(), graph);
                titanRelation = dir == Direction.IN ? otherVertex.addEdge(faunusEdge.getLabel(), titanVertex) : titanVertex.addEdge(faunusEdge.getLabel(), otherVertex);
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_ADDED, 1L);
            } else {
                StandardFaunusProperty faunusProperty = (StandardFaunusProperty)faunusRelation;
                assert (dir == Direction.OUT);
                titanRelation = titanVertex.addProperty(faunusProperty.getTypeName(), faunusProperty.getValue());
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_PROPERTIES_ADDED, 1L);
            }
        }
        TitanGraphOutputMapReduce.synchronizeRelationProperties(graph, faunusRelation, titanRelation, context);
        return titanRelation;
    }

    private static TitanRelation synchronizeRelationProperties(TitanGraph graph, StandardFaunusRelation faunusRelation, TitanRelation titanRelation, Mapper.Context context) {
        if (faunusRelation.isModified() || faunusRelation.isNew()) {
            for (TitanRelation faunusProp : faunusRelation.query().queryAll().relations()) {
                if (!faunusProp.isRemoved()) continue;
                titanRelation.removeProperty(faunusProp.getType().getName());
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGE_PROPERTIES_REMOVED, 1L);
            }
            for (TitanRelation faunusProp : faunusRelation.query().queryAll().relations()) {
                if (!faunusProp.isNew()) continue;
                Object value = faunusProp.isProperty() ? ((FaunusProperty)faunusProp).getValue() : graph.getVertex(((FaunusEdge)faunusProp).getVertexId(Direction.IN));
                titanRelation.setProperty(faunusProp.getType().getName(), value);
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGE_PROPERTIES_ADDED, 1L);
            }
        }
        return titanRelation;
    }

    private static TitanVertex getOtherTitanVertex(FaunusVertex faunusVertex, FaunusEdge faunusEdge, Direction otherDir, TitanGraph graph) {
        Map<Long, Long> idMap = TitanGraphOutputMapReduce.getIdMap(faunusVertex);
        Long othervertexid = faunusEdge.getVertexId(otherDir);
        if (null != idMap && idMap.containsKey(othervertexid)) {
            othervertexid = idMap.get(othervertexid);
        }
        TitanVertex otherVertex = (TitanVertex)graph.getVertex((Object)othervertexid);
        return otherVertex;
    }

    private static Map<Long, Long> getIdMap(FaunusVertex faunusVertex) {
        Map idMap = (Map)faunusVertex.getProperty(ID_MAP_KEY);
        if (null == idMap) {
            idMap = ImmutableMap.of();
        }
        return idMap;
    }

    private static TitanRelation getIncidentRelation(TitanGraph graph, Direction dir, TitanVertex titanVertex, final StandardFaunusRelation faunusRelation, Long otherTitanVertexId) {
        TitanVertexQuery qb = titanVertex.query().direction(dir).types(new RelationType[]{graph.getRelationType(faunusRelation.getTypeName())});
        if (faunusRelation.isEdge()) {
            TitanVertex otherVertex;
            if (otherTitanVertexId != null) {
                otherVertex = (TitanVertex)graph.getVertex((Object)otherTitanVertexId);
            } else {
                StandardFaunusEdge edge = (StandardFaunusEdge)faunusRelation;
                otherVertex = graph.getVertex(edge.getVertexId(dir.opposite()));
            }
            if (otherVertex != null) {
                qb.adjacent(otherVertex);
            } else {
                return null;
            }
        }
        TitanRelation titanRelation = (TitanRelation)Iterables.getFirst((Iterable)Iterables.filter((Iterable)(faunusRelation.isEdge() ? qb.titanEdges() : qb.properties()), (Predicate)new Predicate<TitanRelation>(){

            public boolean apply(@Nullable TitanRelation rel) {
                return rel.getLongId() == faunusRelation.getLongId();
            }
        }), null);
        assert (titanRelation == null || titanRelation.getLongId() == faunusRelation.getLongId());
        return titanRelation;
    }

    public static class EdgeMap
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private TitanGraph graph;
        private boolean trackState;
        private ModifiableHadoopConfiguration faunusConf;
        private LoaderScriptWrapper loaderScript;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.graph = TitanGraphOutputMapReduce.generateGraph(this.faunusConf);
            this.trackState = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getBoolean(Tokens.TITAN_HADOOP_PIPELINE_TRACK_STATE, false);
            if (this.faunusConf.has(TitanHadoopConfiguration.OUTPUT_LOADER_SCRIPT_FILE, new String[0])) {
                Path scriptPath = new Path(this.faunusConf.get(TitanHadoopConfiguration.OUTPUT_LOADER_SCRIPT_FILE, new String[0]));
                FileSystem scriptFS = FileSystem.get((Configuration)HadoopCompatLoader.DEFAULT_COMPAT.getJobContextConfiguration((JobContext)context));
                this.loaderScript = new LoaderScriptWrapper(scriptFS, scriptPath);
            }
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                for (TitanEdge edge : ((FaunusVertexQuery)value.query().queryAll().direction(Direction.IN)).titanEdges()) {
                    this.getCreateOrDeleteEdge(value, (StandardFaunusEdge)edge, context);
                }
            }
            catch (Exception e) {
                this.graph.rollback();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_TRANSACTIONS, 1L);
                throw new IOException(e.getMessage(), e);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.graph.commit();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.SUCCESSFUL_TRANSACTIONS, 1L);
            }
            catch (Exception e) {
                LOGGER.error("Could not commit transaction during Reduce.cleanup(): ", (Throwable)e);
                this.graph.rollback();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_TRANSACTIONS, 1L);
                throw new IOException(e.getMessage(), e);
            }
            this.graph.shutdown();
        }

        public TitanEdge getCreateOrDeleteEdge(FaunusVertex faunusVertex, StandardFaunusEdge faunusEdge, Mapper.Context context) throws InterruptedException {
            Direction dir = Direction.IN;
            TitanVertex titanVertex = (TitanVertex)this.graph.getVertex(faunusVertex.getProperty(TitanGraphOutputMapReduce.TITAN_ID));
            if (null != this.loaderScript && this.loaderScript.hasEdgeMethod()) {
                TitanEdge te = this.loaderScript.getEdge(faunusEdge, titanVertex, TitanGraphOutputMapReduce.getOtherTitanVertex(faunusVertex, faunusEdge, dir.opposite(), this.graph), this.graph, context);
                TitanGraphOutputMapReduce.synchronizeRelationProperties(this.graph, faunusEdge, (TitanRelation)te, context);
                return te;
            }
            return (TitanEdge)TitanGraphOutputMapReduce.getCreateOrDeleteRelation(this.graph, this.trackState, dir, faunusVertex, titanVertex, faunusEdge, context);
        }
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder<FaunusVertex>, NullWritable, FaunusVertex> {
        public void reduce(LongWritable key, Iterable<Holder<FaunusVertex>> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusElement faunusVertex = null;
            HashMap idMap = new HashMap();
            for (Holder<FaunusVertex> holder : values) {
                if (holder.getTag() == 's') {
                    idMap.put(holder.get().getLongId(), holder.get().getProperty(TitanGraphOutputMapReduce.TITAN_ID));
                    continue;
                }
                faunusVertex = holder.get();
            }
            if (null != faunusVertex) {
                faunusVertex.setProperty(TitanGraphOutputMapReduce.ID_MAP_KEY, idMap);
                context.write((Object)NullWritable.get(), (Object)faunusVertex);
            } else {
                LOGGER.warn("No source vertex: hadoopVertex[" + key.get() + "]");
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.NULL_VERTICES_IGNORED, 1L);
            }
        }
    }

    public static class VertexMap
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Holder<FaunusVertex>> {
        private TitanGraph graph;
        private boolean trackState;
        private ModifiableHadoopConfiguration faunusConf;
        private LoaderScriptWrapper loaderScript;
        private final Holder<FaunusVertex> vertexHolder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.graph = TitanGraphOutputMapReduce.generateGraph(this.faunusConf);
            this.trackState = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getBoolean(Tokens.TITAN_HADOOP_PIPELINE_TRACK_STATE, false);
            if (this.faunusConf.has(TitanHadoopConfiguration.OUTPUT_LOADER_SCRIPT_FILE, new String[0])) {
                Path scriptPath = new Path(this.faunusConf.get(TitanHadoopConfiguration.OUTPUT_LOADER_SCRIPT_FILE, new String[0]));
                FileSystem scriptFS = FileSystem.get((Configuration)HadoopCompatLoader.DEFAULT_COMPAT.getJobContextConfiguration((JobContext)context));
                this.loaderScript = new LoaderScriptWrapper(scriptFS, scriptPath);
            }
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                TitanVertex titanVertex = this.getCreateOrDeleteVertex(value, context);
                if (null != titanVertex) {
                    FaunusVertex shellVertex = new FaunusVertex((com.thinkaurelius.titan.diskstorage.configuration.Configuration)this.faunusConf, value.getLongId());
                    shellVertex.setProperty(TitanGraphOutputMapReduce.TITAN_ID, (Object)titanVertex.getLongId());
                    for (TitanEdge edge : ((FaunusVertexQuery)value.query().direction(Direction.OUT)).titanEdges()) {
                        if (this.trackState && !edge.isNew()) continue;
                        this.longWritable.set(edge.getVertex(Direction.IN).getLongId());
                        context.write((Object)this.longWritable, this.vertexHolder.set('s', shellVertex));
                    }
                    this.longWritable.set(value.getLongId());
                    value.setProperty(TitanGraphOutputMapReduce.TITAN_ID, (Object)titanVertex.getLongId());
                    context.write((Object)this.longWritable, this.vertexHolder.set('v', value));
                }
            }
            catch (Exception e) {
                this.graph.rollback();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_TRANSACTIONS, 1L);
                throw new IOException(e.getMessage(), e);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.graph.commit();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.SUCCESSFUL_TRANSACTIONS, 1L);
            }
            catch (Exception e) {
                LOGGER.error("Could not commit transaction during Map.cleanup(): ", (Throwable)e);
                this.graph.rollback();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.FAILED_TRANSACTIONS, 1L);
                throw new IOException(e.getMessage(), e);
            }
            this.graph.shutdown();
        }

        public TitanVertex getCreateOrDeleteVertex(FaunusVertex faunusVertex, Mapper.Context context) throws InterruptedException {
            TitanVertex titanVertex;
            if (this.trackState && faunusVertex.isRemoved()) {
                TitanVertex titanVertex2 = this.graph.getVertex(faunusVertex.getLongId());
                if (null == titanVertex2) {
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.NULL_VERTICES_IGNORED, 1L);
                } else {
                    titanVertex2.remove();
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_REMOVED, 1L);
                }
                return null;
            }
            if (faunusVertex.isNew()) {
                titanVertex = this.getTitanVertex(faunusVertex, context);
            } else {
                titanVertex = this.graph.getVertex(faunusVertex.getLongId());
                if (titanVertex == null) {
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.NULL_VERTICES_IGNORED, 1L);
                    return null;
                }
            }
            if (faunusVertex.isNew() || faunusVertex.isModified()) {
                for (TitanProperty p : faunusVertex.query().queryAll().properties()) {
                    if (null != this.loaderScript && this.loaderScript.hasVPropMethod()) {
                        this.loaderScript.getVProp(p, titanVertex, this.graph, context);
                        continue;
                    }
                    TitanGraphOutputMapReduce.getCreateOrDeleteRelation(this.graph, this.trackState, Direction.OUT, faunusVertex, titanVertex, (StandardFaunusProperty)p, context);
                }
            }
            return titanVertex;
        }

        private TitanVertex getTitanVertex(FaunusVertex faunusVertex, Mapper.Context context) {
            if (null != this.loaderScript && this.loaderScript.hasVertexMethod()) {
                return this.loaderScript.getVertex(faunusVertex, this.graph, context);
            }
            BaseVertexLabel titanLabel = BaseVertexLabel.DEFAULT_VERTEXLABEL;
            FaunusVertexLabel faunusLabel = faunusVertex.getVertexLabel();
            if (!faunusLabel.isDefault()) {
                titanLabel = this.graph.getVertexLabel(faunusLabel.getName());
            }
            TitanVertex tv = this.graph.addVertexWithLabel((VertexLabel)titanLabel);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_ADDED, 1L);
            return tv;
        }
    }

    public static enum Counters {
        VERTICES_ADDED,
        VERTICES_REMOVED,
        VERTEX_PROPERTIES_ADDED,
        VERTEX_PROPERTIES_REMOVED,
        EDGES_ADDED,
        EDGES_REMOVED,
        EDGE_PROPERTIES_ADDED,
        EDGE_PROPERTIES_REMOVED,
        NULL_VERTEX_EDGES_IGNORED,
        NULL_VERTICES_IGNORED,
        NULL_RELATIONS_IGNORED,
        SUCCESSFUL_TRANSACTIONS,
        FAILED_TRANSACTIONS;

    }
}

