/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class BackFilterMapReduce {
    public static org.apache.hadoop.conf.Configuration createConfiguration(Class<? extends Element> klass, int step) {
        ModifiableHadoopConfiguration c = ModifiableHadoopConfiguration.withoutResources();
        c.set(TitanHadoopConfiguration.BACK_FILTER_STEP, step, new String[0]);
        c.set(TitanHadoopConfiguration.BACK_FILTER_CLASS, klass.getCanonicalName(), new String[0]);
        c.set(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, true, new String[0]);
        return c.getHadoopConfiguration();
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, FaunusVertex> {
        private Configuration faunusConf;

        public void setup(Reducer.Context context) {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((FaunusVertex)holder.get());
                    continue;
                }
                if (tag == 'p') {
                    vertex.getPaths((FaunusElement)holder.get(), true);
                    continue;
                }
                vertex.getPaths((FaunusElement)holder.get(), false);
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, Holder, LongWritable, Holder> {
        private final Holder<FaunusVertex> holder = new Holder();
        private Configuration faunusConf;

        public void setup(Reducer.Context context) {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            int outTag = 120;
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((FaunusVertex)holder.get());
                    outTag = 118;
                    continue;
                }
                if (tag == 'p') {
                    vertex.getPaths((FaunusElement)holder.get(), true);
                    continue;
                }
                vertex.getPaths((FaunusElement)holder.get(), false);
            }
            context.write((Object)key, this.holder.set((char)outTag, vertex));
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Holder> {
        private int step;
        private boolean isVertex;
        private final Holder<FaunusPathElement> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();
        private Configuration faunusConf;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.step = (Integer)this.faunusConf.get(TitanHadoopConfiguration.BACK_FILTER_STEP, new String[0]);
            String configuredClassname = (String)this.faunusConf.get(TitanHadoopConfiguration.BACK_FILTER_CLASS, new String[0]);
            this.isVertex = Vertex.class.getCanonicalName().equals(configuredClassname);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    for (List<FaunusPathElement.MicroElement> path : value.getPaths()) {
                        if (path.get(this.step) instanceof StandardFaunusEdge.MicroEdge) {
                            throw new IOException("Back does not support backing up to previous edges");
                        }
                        long backElementId = path.get(this.step).getId();
                        this.longWritable.set(backElementId);
                        FaunusVertex vertex = new FaunusVertex(this.faunusConf, backElementId);
                        vertex.addPath(path, false);
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                    }
                    value.clearPaths();
                }
            } else {
                StandardFaunusEdge edge;
                for (Edge e : value.getEdges(Direction.OUT, new String[0])) {
                    edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    for (List<FaunusPathElement.MicroElement> path : edge.getPaths()) {
                        if (path.get(this.step) instanceof StandardFaunusEdge.MicroEdge) {
                            throw new IOException("Back does not support backing up to previous edges");
                        }
                        long backElementId = path.get(this.step).getId();
                        this.longWritable.set(backElementId);
                        FaunusVertex vertex = new FaunusVertex(this.faunusConf, backElementId);
                        vertex.addPath(path, false);
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                    }
                    edge.clearPaths();
                }
                for (Edge e : value.getEdges(Direction.IN, new String[0])) {
                    edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    edge.clearPaths();
                }
            }
            this.longWritable.set(value.getLongId());
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }
    }
}

