/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.CounterMap;
import com.tinkerpop.blueprints.Direction;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkMapReduce {
    public static final String NO_WEIGHT_KEY = "_";

    public static org.apache.hadoop.conf.Configuration createConfiguration(Direction direction, String label, int step, String mergeWeightKey) {
        ModifiableHadoopConfiguration c = ModifiableHadoopConfiguration.withoutResources();
        c.set(TitanHadoopConfiguration.LINK_STEP, step, new String[0]);
        c.set(TitanHadoopConfiguration.LINK_DIRECTION, direction, new String[0]);
        c.set(TitanHadoopConfiguration.LINK_LABEL, label, new String[0]);
        if (null == mergeWeightKey) {
            c.set(TitanHadoopConfiguration.LINK_MERGE_DUPLICATES, false, new String[0]);
            c.set(TitanHadoopConfiguration.LINK_MERGE_WEIGHT_KEY, NO_WEIGHT_KEY, new String[0]);
        } else {
            c.set(TitanHadoopConfiguration.LINK_MERGE_DUPLICATES, true, new String[0]);
            c.set(TitanHadoopConfiguration.LINK_MERGE_WEIGHT_KEY, mergeWeightKey, new String[0]);
        }
        c.set(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, true, new String[0]);
        return c.getHadoopConfiguration();
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, FaunusVertex> {
        private Direction direction;
        private Configuration faunusConf;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.direction = ((Direction)this.faunusConf.get(TitanHadoopConfiguration.LINK_DIRECTION, new String[0])).opposite();
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            long edgesCreated = 0L;
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((FaunusVertex)holder.get());
                    continue;
                }
                if (tag == 'e') {
                    vertex.addEdge(this.direction, (StandardFaunusEdge)holder.get());
                    ++edgesCreated;
                    continue;
                }
                vertex.addEdges(Direction.BOTH, (FaunusVertex)holder.get());
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
            if (this.direction.equals((Object)Direction.OUT)) {
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_CREATED, edgesCreated);
            } else {
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_CREATED, edgesCreated);
            }
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, Holder, LongWritable, Holder> {
        private Direction direction;
        private Configuration faunusConf;
        private static final Logger log = LoggerFactory.getLogger(Combiner.class);
        private final Holder<FaunusVertex> holder = new Holder();

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            if (!this.faunusConf.has(TitanHadoopConfiguration.LINK_DIRECTION, new String[0])) {
                Iterator it = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).iterator();
                log.error("Broken configuration missing {}", TitanHadoopConfiguration.LINK_DIRECTION);
                log.error("---- Start config dump ----");
                while (it.hasNext()) {
                    Map.Entry ent = (Map.Entry)it.next();
                    log.error("k:{} -> v:{}", ent.getKey(), ent.getValue());
                }
                log.error("---- End config dump   ----");
                throw new NullPointerException();
            }
            this.direction = ((Direction)this.faunusConf.get(TitanHadoopConfiguration.LINK_DIRECTION, new String[0])).opposite();
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            long edgesCreated = 0L;
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            int outTag = 120;
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((FaunusVertex)holder.get());
                    outTag = 118;
                    continue;
                }
                if (tag == 'e') {
                    vertex.addEdge(this.direction, (StandardFaunusEdge)holder.get());
                    ++edgesCreated;
                    continue;
                }
                vertex.addEdges(Direction.BOTH, (FaunusVertex)holder.get());
            }
            context.write((Object)key, this.holder.set((char)outTag, vertex));
            if (this.direction.equals((Object)Direction.OUT)) {
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_CREATED, edgesCreated);
            } else {
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_CREATED, edgesCreated);
            }
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Holder> {
        private Direction direction;
        private String label;
        private int step;
        private final Holder<FaunusPathElement> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();
        private boolean mergeDuplicates;
        private String mergeWeightKey;
        private Configuration faunusConf;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            if (!((Boolean)this.faunusConf.get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0])).booleanValue()) {
                throw new IllegalStateException(LinkMapReduce.class.getSimpleName() + " requires that paths be enabled");
            }
            this.step = (Integer)this.faunusConf.get(TitanHadoopConfiguration.LINK_STEP, new String[0]);
            this.direction = (Direction)this.faunusConf.get(TitanHadoopConfiguration.LINK_DIRECTION, new String[0]);
            this.label = (String)this.faunusConf.get(TitanHadoopConfiguration.LINK_LABEL, new String[0]);
            this.mergeDuplicates = (Boolean)this.faunusConf.get(TitanHadoopConfiguration.LINK_MERGE_DUPLICATES, new String[0]);
            this.mergeWeightKey = (String)this.faunusConf.get(TitanHadoopConfiguration.LINK_MERGE_WEIGHT_KEY, new String[0]);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            long valueId = value.getLongId();
            if (value.hasPaths()) {
                long edgesCreated = 0L;
                if (this.mergeDuplicates) {
                    CounterMap<Long> map = new CounterMap<Long>();
                    for (List<FaunusPathElement.MicroElement> list : value.getPaths()) {
                        map.incr(list.get(this.step).getId(), 1L);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        long linkElementId = (Long)entry.getKey();
                        StandardFaunusEdge edge = this.direction.equals((Object)Direction.IN) ? new StandardFaunusEdge(this.faunusConf, linkElementId, valueId, this.label) : new StandardFaunusEdge(this.faunusConf, valueId, linkElementId, this.label);
                        if (!this.mergeWeightKey.equals(LinkMapReduce.NO_WEIGHT_KEY)) {
                            edge.setProperty(this.mergeWeightKey, entry.getValue());
                        }
                        value.addEdge(this.direction, edge);
                        ++edgesCreated;
                        this.longWritable.set(linkElementId);
                        context.write((Object)this.longWritable, this.holder.set('e', edge));
                    }
                } else {
                    for (List<FaunusPathElement.MicroElement> path : value.getPaths()) {
                        long l = path.get(this.step).getId();
                        StandardFaunusEdge edge = this.direction.equals((Object)Direction.IN) ? new StandardFaunusEdge(this.faunusConf, l, valueId, this.label) : new StandardFaunusEdge(this.faunusConf, valueId, l, this.label);
                        value.addEdge(this.direction, edge);
                        ++edgesCreated;
                        this.longWritable.set(l);
                        context.write((Object)this.longWritable, this.holder.set('e', edge));
                    }
                }
                if (this.direction.equals((Object)Direction.OUT)) {
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_CREATED, edgesCreated);
                } else {
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_CREATED, edgesCreated);
                }
            }
            this.longWritable.set(valueId);
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }
    }

    public static enum Counters {
        IN_EDGES_CREATED,
        OUT_EDGES_CREATED;

    }
}

