/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.FaunusGremlinScriptEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.ScriptEngine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ScriptMap {
    public static final String CLASS = Tokens.makeNamespace(ScriptMap.class) + ".class";
    public static final String SCRIPT_PATH = Tokens.makeNamespace(ScriptMap.class) + ".scriptPath";
    public static final String SCRIPT_ARGS = Tokens.makeNamespace(ScriptMap.class) + ".scriptArgs";
    private static final String ARGS = "args";
    private static final String V = "v";
    private static final String SETUP_ARGS = "setup(args)";
    private static final String MAP_V_ARGS = "map(v,args)";
    private static final String CLEANUP_ARGS = "cleanup(args)";

    public static Configuration createConfiguration(String scriptUri, String ... args) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.set(SCRIPT_PATH, scriptUri);
        configuration.setStrings(SCRIPT_ARGS, args);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private final ScriptEngine engine = new FaunusGremlinScriptEngine();
        private SafeMapperOutputs outputs;
        private Text textWritable = new Text();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration cfg = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
            FileSystem fs = FileSystem.get((Configuration)cfg);
            try {
                this.engine.eval(new InputStreamReader((InputStream)fs.open(new Path(cfg.get(SCRIPT_PATH)))));
                this.engine.put(ScriptMap.ARGS, cfg.getStrings(SCRIPT_ARGS));
                this.engine.eval(ScriptMap.SETUP_ARGS);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.hasPaths()) {
                Object result;
                try {
                    this.engine.put(ScriptMap.V, value);
                    result = this.engine.eval(ScriptMap.MAP_V_ARGS);
                }
                catch (Exception e) {
                    throw new InterruptedException(e.getMessage());
                }
                this.textWritable.set(null == result ? "null" : result.toString());
                this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)this.textWritable);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.engine.eval(ScriptMap.CLEANUP_ARGS);
            }
            catch (Exception e) {
                throw new InterruptedException(e.getMessage());
            }
            this.outputs.close();
        }
    }
}

