/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticesEdgesMapReduce {
    private static final Logger log = LoggerFactory.getLogger(VerticesEdgesMapReduce.class);

    public static org.apache.hadoop.conf.Configuration createConfiguration(Direction direction, String ... labels) {
        ModifiableHadoopConfiguration c = ModifiableHadoopConfiguration.withoutResources();
        c.set(TitanHadoopConfiguration.VERTICES_EDGES_DIRECTION, direction, new String[0]);
        c.set(TitanHadoopConfiguration.VERTICES_EDGES_LABELS, labels, new String[0]);
        return c.getHadoopConfiguration();
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, FaunusVertex> {
        private Direction direction;
        private String[] labels;
        private Configuration faunusConf;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.direction = (Direction)this.faunusConf.get(TitanHadoopConfiguration.VERTICES_EDGES_DIRECTION, new String[0]);
            if (!this.direction.equals((Object)Direction.BOTH)) {
                this.direction = this.direction.opposite();
            }
            this.labels = (String[])this.faunusConf.get(TitanHadoopConfiguration.VERTICES_EDGES_LABELS, new String[0]);
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = new FaunusVertex(this.faunusConf, key.get());
            ArrayList<StandardFaunusEdge> edges = new ArrayList<StandardFaunusEdge>();
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((FaunusVertex)holder.get());
                    continue;
                }
                edges.add((StandardFaunusEdge)holder.get());
            }
            for (Edge e : vertex.getEdges(this.direction, this.labels)) {
                StandardFaunusEdge fe = (StandardFaunusEdge)e;
                for (StandardFaunusEdge edge : edges) {
                    if (fe.getLongId() != edge.getLongId()) continue;
                    fe.getPaths(edge, false);
                    break;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("{}.reduce: edge={} pathCount={}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), fe, fe.pathCount()});
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Holder> {
        private Direction direction;
        private String[] labels;
        private boolean trackPaths;
        private Configuration faunusConf;
        private final Holder<FaunusPathElement> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getJobContextConfiguration((JobContext)context));
            this.direction = (Direction)this.faunusConf.get(TitanHadoopConfiguration.VERTICES_EDGES_DIRECTION, new String[0]);
            this.labels = (String[])this.faunusConf.get(TitanHadoopConfiguration.VERTICES_EDGES_LABELS, new String[0]);
            this.trackPaths = (Boolean)this.faunusConf.get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0]);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (log.isTraceEnabled()) {
                log.trace("{}.map: trackPaths={}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.trackPaths);
            }
            if (value.hasPaths()) {
                List<List<FaunusPathElement.MicroElement>> paths;
                StandardFaunusEdge shellEdge;
                StandardFaunusEdge edge;
                long edgesTraversed = 0L;
                if (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge e : value.getEdges(Direction.IN, this.labels)) {
                        edge = (StandardFaunusEdge)e;
                        shellEdge = new StandardFaunusEdge(this.faunusConf, edge.getLongId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel());
                        if (this.trackPaths) {
                            paths = this.clonePaths(value, new StandardFaunusEdge.MicroEdge(edge.getLongId()));
                            edge.addPaths(paths, false);
                            shellEdge.addPaths(paths, false);
                        } else {
                            edge.getPaths(value, false);
                            shellEdge.getPaths(value, false);
                        }
                        this.longWritable.set(edge.getVertexId(Direction.OUT));
                        context.write((Object)this.longWritable, this.holder.set('p', shellEdge));
                        ++edgesTraversed;
                    }
                }
                if (this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge e : value.getEdges(Direction.OUT, this.labels)) {
                        edge = (StandardFaunusEdge)e;
                        shellEdge = new StandardFaunusEdge(this.faunusConf, edge.getLongId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel());
                        if (this.trackPaths) {
                            paths = this.clonePaths(value, new StandardFaunusEdge.MicroEdge(edge.getLongId()));
                            edge.addPaths(paths, false);
                            shellEdge.addPaths(paths, false);
                            log.trace("shellEdge pathCount={} for edgelabel={}", (Object)shellEdge.pathCount(), (Object)e.getLabel());
                        } else {
                            edge.getPaths(value, false);
                            shellEdge.getPaths(value, false);
                        }
                        this.longWritable.set(edge.getVertexId(Direction.IN));
                        context.write((Object)this.longWritable, this.holder.set('p', shellEdge));
                        ++edgesTraversed;
                    }
                }
                value.clearPaths();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_TRAVERSED, edgesTraversed);
            }
            this.longWritable.set(value.getLongId());
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }

        private List<List<FaunusPathElement.MicroElement>> clonePaths(FaunusVertex vertex, StandardFaunusEdge.MicroEdge edge) {
            ArrayList<List<FaunusPathElement.MicroElement>> paths = new ArrayList<List<FaunusPathElement.MicroElement>>();
            for (List<FaunusPathElement.MicroElement> path : vertex.getPaths()) {
                ArrayList<FaunusPathElement.MicroElement> p = new ArrayList<FaunusPathElement.MicroElement>();
                p.addAll(path);
                p.add(edge);
                paths.add(p);
            }
            return paths;
        }
    }

    public static enum Counters {
        EDGES_TRAVERSED;

    }
}

