/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.util;

import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompiler;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;

public class SafeMapperOutputs {
    private final MultipleOutputs outputs;
    private final Mapper.Context context;
    private final boolean testing;

    public SafeMapperOutputs(Mapper.Context context) {
        this.context = context;
        this.outputs = new MultipleOutputs((TaskInputOutputContext)this.context);
        this.testing = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getBoolean(HadoopCompiler.TESTING, false);
    }

    public void write(String type, Writable key, Writable value) throws IOException, InterruptedException {
        if (this.testing) {
            if (type.equals("sideeffect")) {
                this.context.write((Object)key, (Object)value);
            }
        } else {
            this.outputs.write(type, (Object)key, (Object)value);
        }
    }

    public void close() throws IOException, InterruptedException {
        this.outputs.close();
    }
}

