/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.tinkerpop.gremlin;

import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.HadoopPipeline;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.FaunusGremlinScriptEngine;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;

public class InlineScriptExecutor {
    public static void main(String[] args) throws Exception {
        String file;
        String script;
        if (args.length < 1 || args.length > 3 || args.length == 1 && args[0].contains("-h")) {
            System.out.println("Faunus Usage:");
            System.out.println("  arg1: Faunus graph configuration file (optional): defaults to bin/titan-hadoop.properties");
            System.out.println("  arg2: HadoopGremlin script: 'g.V.step.step...'");
            System.out.println("  arg3: Overriding configurations (optional): '-Dmapred.map.tasks=14 mapred.reduce.tasks=6'");
            System.exit(-1);
        }
        Properties fileConfiguration = new Properties();
        Properties commandLineConfiguration = new Properties();
        if (args.length == 1) {
            script = args[0];
            file = "bin/titan-hadoop.properties";
        } else if (args.length == 2) {
            if (args[1].startsWith("-D")) {
                script = args[0];
                file = "bin/titan-hadoop.properties";
                for (String property : args[1].substring(2).trim().split(" ")) {
                    commandLineConfiguration.put(property.split("=")[0], property.split("=")[1]);
                }
            } else {
                file = args[0];
                script = args[1];
            }
        } else {
            file = args[0];
            script = args[1];
            for (String property : args[2].substring(2).trim().split(" ")) {
                commandLineConfiguration.put(property.split("=")[0], property.split("=")[1]);
            }
        }
        fileConfiguration.load(new FileInputStream(file));
        Configuration conf = new Configuration();
        for (Map.Entry<Object, Object> entry : fileConfiguration.entrySet()) {
            conf.set(entry.getKey().toString(), entry.getValue().toString());
        }
        for (Map.Entry<Object, Object> entry : commandLineConfiguration.entrySet()) {
            conf.set(entry.getKey().toString(), entry.getValue().toString());
        }
        FaunusGremlinScriptEngine scriptEngine = new FaunusGremlinScriptEngine();
        scriptEngine.put("g", (Object)new HadoopGraph(conf));
        Object result = scriptEngine.eval(script);
        if (result.getClass().equals(HadoopPipeline.class)) {
            ((HadoopPipeline)result).submit(script, true);
        }
        System.exit(0);
    }
}

