/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Shape;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfigurable;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.util.system.IOUtils;
import com.tinkerpop.pipes.util.structures.Pair;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BooleanFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.vector.PointVectorStrategy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
implements IndexProvider {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndex.class);
    private static final String DOCID = "_____elementid";
    private static final String GEOID = "_____geo";
    private static final int MAX_STRING_FIELD_LEN = 256;
    private static final Version LUCENE_VERSION = Version.LUCENE_41;
    private static final IndexFeatures LUCENE_FEATURES = new IndexFeatures.Builder().supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.STRING}).build();
    private static final int GEO_MAX_LEVELS = 11;
    private final Analyzer analyzer = new StandardAnalyzer(LUCENE_VERSION);
    private final Map<String, IndexWriter> writers = new HashMap<String, IndexWriter>(4);
    private final ReentrantLock writerLock = new ReentrantLock();
    private Map<String, SpatialStrategy> spatial = new ConcurrentHashMap<String, SpatialStrategy>(12);
    private SpatialContext ctx = SpatialContext.GEO;
    private final String basePath;

    public LuceneIndex(Configuration config) {
        String dir = (String)config.get(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]);
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(directory.exists() && directory.isDirectory() && directory.canWrite())) {
            throw new IllegalArgumentException("Cannot access or write to directory: " + dir);
        }
        this.basePath = directory.getAbsolutePath();
        log.debug("Configured Lucene to use base directory [{}]", (Object)this.basePath);
    }

    private Directory getStoreDirectory(String store) throws BackendException {
        Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((String)store), (String)"Invalid store name: %s", (Object[])new Object[]{store});
        String dir = this.basePath + File.separator + store;
        try {
            File path = new File(dir);
            if (!path.exists()) {
                path.mkdirs();
            }
            if (!(path.exists() && path.isDirectory() && path.canWrite())) {
                throw new PermanentBackendException("Cannot access or write to directory: " + dir);
            }
            log.debug("Opening store directory [{}]", (Object)path);
            return FSDirectory.open((File)path);
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not open directory: " + dir, (Throwable)e);
        }
    }

    private IndexWriter getWriter(String store) throws BackendException {
        Preconditions.checkArgument((boolean)this.writerLock.isHeldByCurrentThread());
        IndexWriter writer = this.writers.get(store);
        if (writer == null) {
            IndexWriterConfig iwc = new IndexWriterConfig(LUCENE_VERSION, this.analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            try {
                writer = new IndexWriter(this.getStoreDirectory(store), iwc);
                this.writers.put(store, writer);
            }
            catch (IOException e) {
                throw new PermanentBackendException("Could not create writer", (Throwable)e);
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpatialStrategy getSpatialStrategy(String key) {
        SpatialStrategy strategy = this.spatial.get(key);
        if (strategy == null) {
            Map<String, SpatialStrategy> map = this.spatial;
            synchronized (map) {
                if (this.spatial.containsKey(key)) {
                    return this.spatial.get(key);
                }
                strategy = new PointVectorStrategy(this.ctx, key);
                this.spatial.put(key, strategy);
            }
        }
        return strategy;
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        Preconditions.checkArgument((map == Mapping.DEFAULT || AttributeUtil.isString((Class)dataType) ? 1 : 0) != 0, (String)"Specified illegal mapping [%s] for data type [%s]", (Object[])new Object[]{map, dataType});
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        Transaction ltx = (Transaction)tx;
        this.writerLock.lock();
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                this.mutateStores(stores, informations);
            }
            ltx.postCommit();
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not update Lucene index", (Throwable)e);
        }
        finally {
            this.writerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mutateStores(Map.Entry<String, Map<String, IndexMutation>> stores, KeyInformation.IndexRetriever informations) throws IOException, BackendException {
        DirectoryReader reader = null;
        try {
            String storename = stores.getKey();
            IndexWriter writer = this.getWriter(storename);
            reader = DirectoryReader.open((IndexWriter)writer, (boolean)true);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                String docid = entry.getKey();
                IndexMutation mutation = entry.getValue();
                if (mutation.isDeleted()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Deleted entire document [{}]", (Object)docid);
                    }
                    writer.deleteDocuments(new Term(DOCID, docid));
                    continue;
                }
                Pair<Document, Map<String, Shape>> docAndGeo = this.retrieveOrCreate(docid, searcher);
                Document doc = (Document)docAndGeo.getA();
                Map geofields = (Map)docAndGeo.getB();
                Preconditions.checkNotNull((Object)doc);
                for (IndexEntry del : mutation.getDeletions()) {
                    Preconditions.checkArgument((!del.hasMetaData() ? 1 : 0) != 0, (String)"Lucene index does not support indexing meta data: %s", (Object[])new Object[]{del});
                    String key = del.field;
                    if (doc.getField(key) == null) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Removing field [{}] on document [{}]", (Object)key, (Object)docid);
                    }
                    doc.removeFields(key);
                    geofields.remove(key);
                }
                this.addToDocument(storename, docid, doc, mutation.getAdditions(), geofields, informations);
                writer.updateDocument(new Term(DOCID, docid), (Iterable)doc);
            }
            writer.commit();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        this.writerLock.lock();
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                String store = stores.getKey();
                IndexWriter writer = this.getWriter(store);
                DirectoryReader reader = DirectoryReader.open((IndexWriter)writer, (boolean)true);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                    String docID = entry.getKey();
                    List<IndexEntry> content = entry.getValue();
                    if (content == null || content.isEmpty()) {
                        if (log.isTraceEnabled()) {
                            log.trace("Deleting document [{}]", (Object)docID);
                        }
                        writer.deleteDocuments(new Term(DOCID, docID));
                        continue;
                    }
                    Pair<Document, Map<String, Shape>> docAndGeo = this.retrieveOrCreate(docID, searcher);
                    this.addToDocument(store, docID, (Document)docAndGeo.getA(), content, (Map)docAndGeo.getB(), informations);
                    writer.updateDocument(new Term(DOCID, docID), (Iterable)docAndGeo.getA());
                }
                writer.commit();
            }
            tx.commit();
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not update Lucene index", (Throwable)e);
        }
        finally {
            this.writerLock.unlock();
        }
    }

    private Pair<Document, Map<String, Shape>> retrieveOrCreate(String docID, IndexSearcher searcher) throws IOException {
        Document doc;
        TopDocs hits = searcher.search((Query)new TermQuery(new Term(DOCID, docID)), 10);
        HashMap geofields = Maps.newHashMap();
        if (hits.scoreDocs.length > 1) {
            throw new IllegalArgumentException("More than one document found for document id: " + docID);
        }
        if (hits.scoreDocs.length == 0) {
            if (log.isTraceEnabled()) {
                log.trace("Creating new document for [{}]", (Object)docID);
            }
            doc = new Document();
            doc.add((IndexableField)new StringField(DOCID, docID, Field.Store.YES));
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Updating existing document for [{}]", (Object)docID);
            }
            int docId = hits.scoreDocs[0].doc;
            doc = searcher.doc(docId);
            for (IndexableField field : doc.getFields()) {
                if (!field.stringValue().startsWith(GEOID)) continue;
                geofields.put(field.name(), this.ctx.readShape(field.stringValue().substring(GEOID.length())));
            }
        }
        return new Pair((Object)doc, (Object)geofields);
    }

    private void addToDocument(String store, String docID, Document doc, List<IndexEntry> content, Map<String, Shape> geofields, KeyInformation.IndexRetriever informations) {
        Preconditions.checkNotNull((Object)doc);
        for (IndexEntry indexEntry : content) {
            Preconditions.checkArgument((!indexEntry.hasMetaData() ? 1 : 0) != 0, (String)"Lucene index does not support indexing meta data: %s", (Object[])new Object[]{indexEntry});
            if (log.isTraceEnabled()) {
                log.trace("Adding field [{}] on document [{}]", (Object)indexEntry.field, (Object)docID);
            }
            if (doc.getField(indexEntry.field) != null) {
                doc.removeFields(indexEntry.field);
            }
            if (indexEntry.value instanceof Number) {
                Object field = AttributeUtil.isWholeNumber((Number)((Number)indexEntry.value)) ? new LongField(indexEntry.field, ((Number)indexEntry.value).longValue(), Field.Store.YES) : new DoubleField(indexEntry.field, ((Number)indexEntry.value).doubleValue(), Field.Store.YES);
                doc.add((IndexableField)field);
                continue;
            }
            if (AttributeUtil.isString((Object)indexEntry.value)) {
                TextField field;
                String str = (String)indexEntry.value;
                Mapping mapping = Mapping.getMapping((String)store, (String)indexEntry.field, (KeyInformation.IndexRetriever)informations);
                switch (mapping) {
                    case DEFAULT: 
                    case TEXT: {
                        field = new TextField(indexEntry.field, str, Field.Store.YES);
                        break;
                    }
                    case STRING: {
                        field = new StringField(indexEntry.field, str, Field.Store.YES);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal mapping specified: " + mapping);
                    }
                }
                doc.add((IndexableField)field);
                continue;
            }
            if (indexEntry.value instanceof Geoshape) {
                Shape shape = ((Geoshape)indexEntry.value).convert2Spatial4j();
                geofields.put(indexEntry.field, shape);
                doc.add((IndexableField)new StoredField(indexEntry.field, GEOID + this.ctx.toString(shape)));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type: " + indexEntry.value);
        }
        for (Map.Entry entry : geofields.entrySet()) {
            if (log.isTraceEnabled()) {
                log.trace("Updating geo-indexes for key {}", entry.getKey());
            }
            for (Field f : this.getSpatialStrategy((String)entry.getKey()).createIndexableFields((Shape)entry.getValue())) {
                doc.add((IndexableField)f);
            }
        }
    }

    private static Sort getSortOrder(IndexQuery query) {
        Sort sort = new Sort();
        List orders = query.getOrder();
        if (!orders.isEmpty()) {
            SortField[] fields = new SortField[orders.size()];
            for (int i = 0; i < orders.size(); ++i) {
                IndexQuery.OrderEntry order = (IndexQuery.OrderEntry)orders.get(i);
                SortField.Type sortType = null;
                Class datatype = order.getDatatype();
                if (AttributeUtil.isString((Class)datatype)) {
                    sortType = SortField.Type.STRING;
                } else if (AttributeUtil.isWholeNumber((Class)datatype)) {
                    sortType = SortField.Type.LONG;
                } else if (AttributeUtil.isDecimal((Class)datatype)) {
                    sortType = SortField.Type.DOUBLE;
                } else {
                    Preconditions.checkArgument((boolean)false, (String)"Unsupported order specified on field [%s] with datatype [%s]", (Object[])new Object[]{order.getKey(), datatype});
                }
                fields[i] = new SortField(order.getKey(), sortType, order.getOrder() == Order.DESC);
            }
            sort.setSort(fields);
        }
        return sort;
    }

    public List<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        SearchParams searchParams = this.convertQuery(query.getCondition(), informations.get(query.getStore()));
        try {
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return ImmutableList.of();
            }
            Query q = searchParams.getQuery();
            if (null == q) {
                q = new MatchAllDocsQuery();
            }
            Filter f = searchParams.getFilter();
            long time = System.currentTimeMillis();
            TopFieldDocs docs = searcher.search(q, f, query.hasLimit() ? query.getLimit() : 0x7FFFFFFE, LuceneIndex.getSortOrder(query));
            log.debug("Executed query [{}] and filter [{}] in {} ms", new Object[]{q, f, System.currentTimeMillis() - time});
            ArrayList<String> result = new ArrayList<String>(docs.scoreDocs.length);
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                result.add(searcher.doc(docs.scoreDocs[i].doc).getField(DOCID).stringValue());
            }
            return result;
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not execute Lucene query", (Throwable)e);
        }
    }

    private static final Filter numericFilter(String key, Cmp relation, Number value) {
        switch (relation) {
            case EQUAL: {
                return AttributeUtil.isWholeNumber((Number)value) ? NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)value.longValue(), (boolean)true, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)value.doubleValue(), (boolean)true, (boolean)true);
            }
            case NOT_EQUAL: {
                BooleanFilter q = new BooleanFilter();
                if (AttributeUtil.isWholeNumber((Number)value)) {
                    q.add((Filter)NumericRangeFilter.newLongRange((String)key, (Long)Long.MIN_VALUE, (Long)value.longValue(), (boolean)true, (boolean)false), BooleanClause.Occur.SHOULD);
                    q.add((Filter)NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)Long.MAX_VALUE, (boolean)false, (boolean)true), BooleanClause.Occur.SHOULD);
                } else {
                    q.add((Filter)NumericRangeFilter.newDoubleRange((String)key, (Double)Double.MIN_VALUE, (Double)value.doubleValue(), (boolean)true, (boolean)false), BooleanClause.Occur.SHOULD);
                    q.add((Filter)NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)Double.MAX_VALUE, (boolean)false, (boolean)true), BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            case LESS_THAN: {
                return AttributeUtil.isWholeNumber((Number)value) ? NumericRangeFilter.newLongRange((String)key, (Long)Long.MIN_VALUE, (Long)value.longValue(), (boolean)true, (boolean)false) : NumericRangeFilter.newDoubleRange((String)key, (Double)Double.MIN_VALUE, (Double)value.doubleValue(), (boolean)true, (boolean)false);
            }
            case LESS_THAN_EQUAL: {
                return AttributeUtil.isWholeNumber((Number)value) ? NumericRangeFilter.newLongRange((String)key, (Long)Long.MIN_VALUE, (Long)value.longValue(), (boolean)true, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)Double.MIN_VALUE, (Double)value.doubleValue(), (boolean)true, (boolean)true);
            }
            case GREATER_THAN: {
                return AttributeUtil.isWholeNumber((Number)value) ? NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)Long.MAX_VALUE, (boolean)false, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)Double.MAX_VALUE, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_EQUAL: {
                return AttributeUtil.isWholeNumber((Number)value) ? NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)Long.MAX_VALUE, (boolean)true, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)Double.MAX_VALUE, (boolean)true, (boolean)true);
            }
        }
        throw new IllegalArgumentException("Unexpected relation: " + relation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SearchParams convertQuery(Condition<?> condition, KeyInformation.StoreRetriever informations) {
        SearchParams params = new SearchParams();
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            TitanPredicate titanPredicate = atom.getPredicate();
            if (value instanceof Number) {
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + titanPredicate));
                Preconditions.checkArgument((boolean)(value instanceof Number));
                params.addFilter(LuceneIndex.numericFilter(key, (Cmp)titanPredicate, (Number)value));
                return params;
            } else if (value instanceof String) {
                Mapping map = Mapping.getMapping((KeyInformation)informations.get(key));
                if (!(map != Mapping.DEFAULT && map != Mapping.TEXT || titanPredicate.toString().startsWith("CONTAINS"))) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS queries and not: " + titanPredicate);
                }
                if (map == Mapping.STRING && titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + titanPredicate);
                }
                if (titanPredicate == Text.CONTAINS) {
                    value = ((String)value).toLowerCase();
                    BooleanFilter b = new BooleanFilter();
                    for (String term : Text.tokenize((String)((String)value))) {
                        b.add((Filter)new TermsFilter(new Term[]{new Term(key, term)}), BooleanClause.Occur.MUST);
                    }
                    params.addFilter((Filter)b);
                    return params;
                } else if (titanPredicate == Text.CONTAINS_PREFIX) {
                    value = ((String)value).toLowerCase();
                    params.addFilter((Filter)new PrefixFilter(new Term(key, (String)value)));
                    return params;
                } else if (titanPredicate == Text.PREFIX) {
                    params.addFilter((Filter)new PrefixFilter(new Term(key, (String)value)));
                    return params;
                } else if (titanPredicate == Text.REGEX) {
                    RegexpQuery rq = new RegexpQuery(new Term(key, (String)value));
                    params.addQuery((Query)rq);
                    return params;
                } else if (titanPredicate == Text.CONTAINS_REGEX) {
                    RegexpQuery rq = new RegexpQuery(new Term(key, ".*" + value + ".*"));
                    params.addQuery((Query)rq);
                    return params;
                } else if (titanPredicate == Cmp.EQUAL) {
                    params.addFilter((Filter)new TermsFilter(new Term[]{new Term(key, (String)value)}));
                    return params;
                } else {
                    if (titanPredicate != Cmp.NOT_EQUAL) throw new IllegalArgumentException("Relation is not supported for string value: " + titanPredicate);
                    BooleanFilter q = new BooleanFilter();
                    q.add((Filter)new TermsFilter(new Term[]{new Term(key, (String)value)}), BooleanClause.Occur.MUST_NOT);
                    params.addFilter((Filter)q);
                }
                return params;
            } else {
                if (!(value instanceof Geoshape)) throw new IllegalArgumentException("Unsupported type: " + value);
                Preconditions.checkArgument((titanPredicate == Geo.WITHIN ? 1 : 0) != 0, (Object)("Relation is not supported for geo value: " + titanPredicate));
                Shape shape = ((Geoshape)value).convert2Spatial4j();
                SpatialArgs args = new SpatialArgs(SpatialOperation.IsWithin, shape);
                params.addFilter(this.getSpatialStrategy(key).makeFilter(args));
            }
            return params;
        } else if (condition instanceof Not) {
            SearchParams childParams = this.convertQuery(((Not)condition).getChild(), informations);
            params.addParams(childParams, BooleanClause.Occur.MUST_NOT);
            return params;
        } else if (condition instanceof And) {
            for (Condition c : condition.getChildren()) {
                SearchParams childParams = this.convertQuery(c, informations);
                params.addParams(childParams, BooleanClause.Occur.MUST);
            }
            return params;
        } else {
            if (!(condition instanceof Or)) throw new IllegalArgumentException("Invalid condition: " + condition);
            for (Condition c : condition.getChildren()) {
                SearchParams childParams = this.convertQuery(c, informations);
                params.addParams(childParams, BooleanClause.Occur.SHOULD);
            }
        }
        return params;
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        Query q;
        try {
            q = new QueryParser(LUCENE_VERSION, "_all", this.analyzer).parse(query.getQuery());
        }
        catch (ParseException e) {
            throw new PermanentBackendException("Could not parse raw query: " + query.getQuery(), (Throwable)e);
        }
        try {
            int adjustedLimit;
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return ImmutableList.of();
            }
            long time = System.currentTimeMillis();
            int offset = query.getOffset();
            int n = adjustedLimit = query.hasLimit() ? query.getLimit() : 0x7FFFFFFE;
            adjustedLimit = adjustedLimit < 0x7FFFFFFE - offset ? (adjustedLimit += offset) : 0x7FFFFFFE;
            TopDocs docs = searcher.search(q, adjustedLimit);
            log.debug("Executed query [{}] in {} ms", (Object)q, (Object)(System.currentTimeMillis() - time));
            ArrayList<RawQuery.Result<String>> result = new ArrayList<RawQuery.Result<String>>(docs.scoreDocs.length);
            for (int i = offset; i < docs.scoreDocs.length; ++i) {
                result.add((RawQuery.Result<String>)new RawQuery.Result((Object)searcher.doc(docs.scoreDocs[i].doc).getField(DOCID).stringValue(), (double)docs.scoreDocs[i].score));
            }
            return result;
        }
        catch (IOException e) {
            throw new TemporaryBackendException("Could not execute Lucene query", (Throwable)e);
        }
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new Transaction(config);
    }

    public boolean supports(KeyInformation information, TitanPredicate titanPredicate) {
        if (information.getCardinality() != Cardinality.SINGLE) {
            return false;
        }
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (mapping != Mapping.DEFAULT && !AttributeUtil.isString((Class)dataType)) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            if (titanPredicate instanceof Cmp) {
                return true;
            }
        } else {
            if (dataType == Geoshape.class) {
                return titanPredicate == Geo.WITHIN;
            }
            if (AttributeUtil.isString((Class)dataType)) {
                switch (mapping) {
                    case DEFAULT: 
                    case TEXT: {
                        return titanPredicate == Text.CONTAINS || titanPredicate == Text.CONTAINS_PREFIX;
                    }
                    case STRING: {
                        return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL || titanPredicate == Text.PREFIX || titanPredicate == Text.REGEX;
                    }
                }
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        if (information.getCardinality() != Cardinality.SINGLE) {
            return false;
        }
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        return Number.class.isAssignableFrom(dataType) || dataType == Geoshape.class ? mapping == Mapping.DEFAULT : AttributeUtil.isString((Class)dataType) && (mapping == Mapping.DEFAULT || mapping == Mapping.STRING || mapping == Mapping.TEXT);
    }

    public String mapKey2Field(String key, KeyInformation information) {
        Preconditions.checkArgument((!StringUtils.containsAny((String)key, (char[])new char[]{' '}) ? 1 : 0) != 0, (String)"Invalid key name provided: %s", (Object[])new Object[]{key});
        return key;
    }

    public IndexFeatures getFeatures() {
        return LUCENE_FEATURES;
    }

    public void close() throws BackendException {
        try {
            for (IndexWriter w : this.writers.values()) {
                w.close();
            }
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not close writers", (Throwable)e);
        }
    }

    public void clearStorage() throws BackendException {
        try {
            FileUtils.deleteDirectory((File)new File(this.basePath));
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not delete lucene directory: " + this.basePath, (Throwable)e);
        }
    }

    private static class SearchParams {
        private BooleanQuery q = new BooleanQuery();
        private BooleanFilter f = new BooleanFilter();

        private SearchParams() {
        }

        private void addFilter(Filter newFilter) {
            this.addFilter(newFilter, BooleanClause.Occur.MUST);
        }

        private void addFilter(Filter newFilter, BooleanClause.Occur occur) {
            this.f.add(newFilter, occur);
        }

        private void addQuery(Query newQuery) {
            this.addQuery(newQuery, BooleanClause.Occur.MUST);
        }

        private void addQuery(Query newQuery, BooleanClause.Occur occur) {
            this.q.add(newQuery, occur);
        }

        private void addParams(SearchParams other, BooleanClause.Occur occur) {
            Filter otherFilter;
            Query otherQuery = other.getQuery();
            if (null != otherQuery) {
                this.addQuery(otherQuery, occur);
            }
            if (null != (otherFilter = other.getFilter())) {
                this.addFilter(otherFilter, occur);
            }
        }

        private Query getQuery() {
            if (0 == this.q.clauses().size()) {
                return null;
            }
            return this.q;
        }

        private Filter getFilter() {
            if (0 == this.f.clauses().size()) {
                return null;
            }
            return this.f;
        }
    }

    private class Transaction
    implements BaseTransactionConfigurable {
        private final BaseTransactionConfig config;
        private final Set<String> updatedStores = Sets.newHashSet();
        private final Map<String, IndexSearcher> searchers = new HashMap<String, IndexSearcher>(4);

        private Transaction(BaseTransactionConfig config) {
            this.config = config;
        }

        private synchronized IndexSearcher getSearcher(String store) throws BackendException {
            IndexSearcher searcher = this.searchers.get(store);
            if (searcher == null) {
                DirectoryReader reader = null;
                try {
                    reader = DirectoryReader.open((Directory)LuceneIndex.this.getStoreDirectory(store));
                    searcher = new IndexSearcher((IndexReader)reader);
                }
                catch (IndexNotFoundException e) {
                    searcher = null;
                }
                catch (IOException e) {
                    throw new PermanentBackendException("Could not open index reader on store: " + store, (Throwable)e);
                }
                this.searchers.put(store, searcher);
            }
            return searcher;
        }

        public void postCommit() throws BackendException {
            this.close();
            this.searchers.clear();
        }

        public void commit() throws BackendException {
            this.close();
        }

        public void rollback() throws BackendException {
            this.close();
        }

        private void close() throws BackendException {
            try {
                for (IndexSearcher searcher : this.searchers.values()) {
                    if (searcher == null) continue;
                    searcher.getIndexReader().close();
                }
            }
            catch (IOException e) {
                throw new PermanentBackendException("Could not close searcher", (Throwable)e);
            }
        }

        public BaseTransactionConfig getConfiguration() {
            return this.config;
        }
    }
}

