/*
 * Decompiled with CFR 0.152.
 */
package com.sdk;

import com.alibaba.fastjson.JSONObject;
import com.sdk.utils.HttpClient;
import com.sdk.utils.LoggerUtil;
import com.sdk.utils.SignUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.AbstractHttpMessage;

public class OpenSDk {
    private static final int Request_Get = 0;
    private static final int Request_Post = 1;
    private static String SERVER_ADDRESS;
    private static final String PayPrepay = "/payment/prepay";
    private static final String QueryAccessToken = "/appUsers/access_token";
    private static final String RefreshAccessToken = "/appUsers/refresh_token";
    private static final String QueryCode = "/appUsers/code";
    private static final String QueryUserInfo = "/appUsers/user_info";
    private static final String QueryAppToken = "/app/token";
    private static String APPUID;
    private static String APPSECRET;

    public void init(String serveraddress, String appUid, String appSecret) {
        if (this.isEmpty(serveraddress)) {
            LoggerUtil.error("\u521d\u59cb\u5316\u5f02\u5e38:serveraddress");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:serveraddress\u4e3a\u7a7a");
        }
        if (this.isEmpty(appSecret)) {
            LoggerUtil.error("\u521d\u59cb\u5316\u5f02\u5e38:appSecret");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:appSecret \u4e3a\u7a7a");
        }
        SERVER_ADDRESS = serveraddress;
        APPUID = appUid;
        APPSECRET = appSecret;
    }

    public String QueryUserInfo(String accessToken, String openId) {
        LoggerUtil.info("[QueryUserInfo] openId:{" + openId + "},accessToken:{" + accessToken + "}");
        String ret = "";
        if (this.isEmpty(openId)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:openId \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:openId \u4e3a\u7a7a");
        }
        if (this.isEmpty(accessToken)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:accessToken \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:accessToken \u4e3a\u7a7a");
        }
        Map<String, String> params = this.queryParams(accessToken, openId);
        String jsonParam = JSONObject.toJSONString(params);
        try {
            ret = HttpClient.postDataJson(SERVER_ADDRESS + QueryUserInfo, jsonParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerUtil.error(e.getMessage());
            return OpenSDk.getMyError("101111", "\u8bf7\u6c42\u5f02\u5e38");
        }
        return ret;
    }

    public String QueryUserAccessToken(String code) {
        LoggerUtil.info("[QueryUserAccessToken] code:{" + code + "},appUid:{" + APPUID + "}");
        String ret = "";
        if (this.isEmpty(code)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:code \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:code \u4e3a\u7a7a");
        }
        Map<String, String> params = this.queryParams(code);
        String jsonParam = JSONObject.toJSONString(params);
        try {
            ret = HttpClient.postDataJson(SERVER_ADDRESS + QueryAccessToken, jsonParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerUtil.error(e.getMessage());
            return OpenSDk.getMyError("101111", "\u8bf7\u6c42\u5f02\u5e38");
        }
        return ret;
    }

    public String QueryAppAccessToken() {
        LoggerUtil.info("[QueryAppAccessToken] appUid:{" + APPUID + "}");
        String ret = "";
        if (this.isEmpty(APPUID)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:APPUID \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:APPUID \u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String nonceStr = RandomStringUtils.randomAlphanumeric((int)8);
        long timeStamp = System.currentTimeMillis();
        params.put("appUid", APPUID);
        params.put("timestamp", String.valueOf(timeStamp));
        params.put("nonceStr", nonceStr);
        String computed_sign = SignUtil.getSign(params, APPSECRET);
        params.put("sign", computed_sign);
        String jsonParam = JSONObject.toJSONString(params);
        try {
            ret = HttpClient.postDataJson(SERVER_ADDRESS + QueryAppToken, jsonParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerUtil.error(e.getMessage());
            return OpenSDk.getMyError("101111", "\u8bf7\u6c42\u5f02\u5e38");
        }
        return ret;
    }

    public String RefreshAccessToken(String refreshToken) {
        LoggerUtil.info("[RefreshAccessToken] appUid:{" + APPUID + "},refreshToken:{" + refreshToken + "}");
        String ret = "";
        if (this.isEmpty(APPUID)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:APPUID \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:APPUID \u4e3a\u7a7a");
        }
        if (this.isEmpty(refreshToken)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:refreshToken \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:refreshToken \u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String nonceStr = RandomStringUtils.randomAlphanumeric((int)8);
        long timeStamp = System.currentTimeMillis();
        params.put("appId", APPUID);
        params.put("refreshToken", refreshToken);
        String jsonParam = JSONObject.toJSONString(params);
        try {
            ret = HttpClient.postDataJson(SERVER_ADDRESS + RefreshAccessToken, jsonParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerUtil.error(e.getMessage());
            return OpenSDk.getMyError("101111", "\u8bf7\u6c42\u5f02\u5e38");
        }
        return ret;
    }

    public Map<String, String> queryParams(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        String nonceStr = RandomStringUtils.randomAlphanumeric((int)8);
        long timeStamp = System.currentTimeMillis();
        params.put("appUid", APPUID);
        params.put("code", code);
        params.put("timestamp", String.valueOf(timeStamp));
        params.put("nonceStr", nonceStr);
        String computed_sign = SignUtil.getSign(params, APPSECRET);
        params.put("sign", computed_sign);
        return params;
    }

    public Map<String, String> queryParams(String accessToken, String openId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accessToken", accessToken);
        params.put("openId", openId);
        return params;
    }

    public String createOrder(String openUid, String accessToken, String orderSn, String totalFee, String exchange, String body, String notifyUrl, String currency) {
        LoggerUtil.info("[createOrder] accessToken:{" + accessToken + "} openUid:{" + openUid + "},appUid:{" + APPUID + "},orderSn{" + orderSn + "},totalFee:{" + totalFee + "},exchange:{" + exchange + "},body:{" + body + "},notifyUrl:{" + notifyUrl + "}");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appUid", APPUID);
        params.put("openUid", openUid);
        params.put("outTradeNo", orderSn);
        long timeStamp = System.currentTimeMillis();
        params.put("timestamp", String.valueOf(timeStamp));
        String nonceStr = RandomStringUtils.randomAlphanumeric((int)8);
        params.put("totalFee", totalFee);
        params.put("currency", currency);
        params.put("exchange", exchange);
        params.put("nonceStr", nonceStr);
        params.put("accessToken", accessToken);
        params.put("body", body);
        params.put("notifyUrl", notifyUrl);
        String sign = SignUtil.getSign(params, APPSECRET);
        params.put("sign", sign);
        String jsonParam = JSONObject.toJSONString(params);
        String ret = "";
        try {
            ret = HttpClient.postDataJson(SERVER_ADDRESS + PayPrepay, jsonParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerUtil.error(e.getMessage());
            return OpenSDk.getMyError("101111", "\u8bf7\u6c42\u5f02\u5e38");
        }
        return ret;
    }

    public boolean notifyValidate(String outTradeNo, String totalFee, String currency, String payAt, String result, String timestamp, String scode, String sign) {
        LoggerUtil.info("[notifyValidate] outTradeNo:{" + outTradeNo + "},appUid:{" + APPUID + "},result{" + result + "},totalFee:{" + totalFee + "},payAt:{" + payAt + "},scode:{" + scode + "},sign:{" + sign + "}");
        boolean flag = true;
        if (this.isEmpty(APPUID)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:appUid \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:appUid \u4e3a\u7a7a");
        }
        if (this.isEmpty(outTradeNo)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:outTradeNo \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:outTradeNo \u4e3a\u7a7a");
        }
        if (this.isEmpty(totalFee)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:totalFee \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:totalFee \u4e3a\u7a7a");
        }
        if (this.isEmpty(currency)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:currency \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:currency \u4e3a\u7a7a");
        }
        if (this.isEmpty(payAt)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:payAt \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:payAt \u4e3a\u7a7a");
        }
        if (this.isEmpty(result)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:result \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:result \u4e3a\u7a7a");
        }
        if (this.isEmpty(timestamp)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:timestamp \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:timestamp \u4e3a\u7a7a");
        }
        if (this.isEmpty(scode)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:scode \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:scode \u4e3a\u7a7a");
        }
        if (this.isEmpty(sign)) {
            LoggerUtil.error("\u5fc5\u9009\u53c2\u6570:sign \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:sign \u4e3a\u7a7a");
        }
        if (!this.verifyNotify(APPUID, outTradeNo, result, totalFee, currency, payAt, timestamp, scode, sign, APPSECRET).booleanValue()) {
            LoggerUtil.error("\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef ");
            flag = false;
        }
        return flag;
    }

    private static String getMyError(String code, String msg) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("code:" + code);
        stringBuffer.append(",");
        stringBuffer.append("msg:" + msg);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private HttpRequestBase getHttpRequestBase(int get, String url) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        HttpGet mHttpRequestBase = null;
        if (get == 0) {
            mHttpRequestBase = new HttpGet(url);
        } else if (get == 1) {
            mHttpRequestBase = new HttpPost(url);
        }
        this.setHttpHeader((AbstractHttpMessage)mHttpRequestBase);
        return mHttpRequestBase;
    }

    public Boolean verifyNotify(String appUid, String outTradeNo, String result, String totalFee, String currency, String payAt, String timestamp, String scode, String sign, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appUid", appUid);
        map.put("outTradeNo", outTradeNo);
        map.put("totalFee", totalFee);
        map.put("currency", currency);
        map.put("payAt", payAt);
        map.put("result", result);
        map.put("scode", scode);
        map.put("timestamp", timestamp);
        String computedSign = SignUtil.getSign(map, appSecret);
        return sign.equals(computedSign);
    }

    private void setHttpHeader(AbstractHttpMessage httpMessage) {
        httpMessage.setHeader("Accept", "application/json");
        httpMessage.setHeader("Content-Type", "application/json;charset=utf-8");
    }

    private boolean isEmpty(String str) {
        return "".equals(str) || str == null;
    }
}

