/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.utils;

import com.sdk.utils.HttpResult;
import com.sdk.utils.LoggerUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.CodingErrorAction;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    private static CloseableHttpClient client = null;
    private static HttpClient _instance = new HttpClient();
    private static PoolingHttpClientConnectionManager connManager = null;

    public static String getSend(String url) {
        return HttpClient.getSend(url, "UTF-8", "");
    }

    public static synchronized HttpClient getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postRestData(String url, String xmlData, Date curDate) {
        LoggerUtil.info("\u8bf7\u6c42rest\u5730\u5740:" + url);
        LoggerUtil.info("\u8bf7\u6c42rest\u5185\u5bb9:" + xmlData);
        String result = "";
        CloseableHttpClient client = null;
        String encode = "UTF-8";
        try {
            client = HttpClient.isHttpsUrl(url) ? HttpClient.registerSSL(HttpClient.getHost(url), "TLS", 8883, "https") : HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(30000).build();
            HttpPost post = new HttpPost(url);
            post.setConfig(requestConfig);
            post.setHeader("Accept", "application/xml");
            post.setHeader("Content-Type", "application/xml;charset=" + encode);
            ByteArrayEntity httpEntity = new ByteArrayEntity(xmlData.getBytes("UTF-8"));
            post.setEntity((HttpEntity)httpEntity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            Integer status = response.getStatusLine().getStatusCode();
            StringBuffer sb = new StringBuffer();
            InputStreamReader iReader = null;
            InputStream inputStream = entity.getContent();
            iReader = new InputStreamReader(inputStream, encode);
            BufferedReader reader = new BufferedReader(iReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            iReader.close();
            result = sb.toString();
            LoggerUtil.debug("rest\u8fd4\u56de\u7ed3\u679c :" + result + ",status:" + status);
        }
        catch (Exception e) {
            LoggerUtil.error("HttpClientConnect\u8bf7\u6c42rest\u5730\u5740\u9519\u8bef," + e.getCause());
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postRestData(String url, String xmlData, String accountId, Date curDate) {
        String result = "";
        CloseableHttpClient client = null;
        String encode = "UTF-8";
        try {
            client = HttpClient.isHttpsUrl(url) ? HttpClient.registerSSL(HttpClient.getHost(url), "TLS", 8883, "https") : HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(20000).build();
            HttpPost post = new HttpPost(url);
            post.setConfig(requestConfig);
            post.setHeader("Accept", "application/xml");
            post.setHeader("Content-Type", "application/xml;charset=" + encode);
            ByteArrayEntity httpEntity = new ByteArrayEntity(xmlData.getBytes("UTF-8"));
            post.setEntity((HttpEntity)httpEntity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            Integer status = response.getStatusLine().getStatusCode();
            StringBuffer sb = new StringBuffer();
            InputStreamReader iReader = null;
            InputStream inputStream = entity.getContent();
            iReader = new InputStreamReader(inputStream, encode);
            BufferedReader reader = new BufferedReader(iReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            iReader.close();
            result = sb.toString();
            LoggerUtil.debug("rest\u8fd4\u56de\u7ed3\u679c :" + result + ",status:" + status);
        }
        catch (Exception e) {
            LoggerUtil.error("HttpClient\u8bf7\u6c42rest\u5730\u5740\u9519\u8bef," + e.getCause());
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    static CloseableHttpClient registerSSL(String hostname, String protocol, int port, String scheme) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance(protocol);
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length == 0) {
                    throw new IllegalArgumentException("null or zero-length certificate chain");
                }
                if (authType == null || authType.length() == 0) {
                    throw new IllegalArgumentException("null or zero-length authentication type");
                }
                boolean br = false;
                X500Principal principal = null;
                for (X509Certificate x509Certificate : chain) {
                    principal = x509Certificate.getSubjectX500Principal();
                    LoggerUtil.debug("\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\uff1a" + principal.getName());
                    if (principal == null) continue;
                    br = true;
                    return;
                }
                if (!br) {
                    LoggerUtil.error("\u670d\u52a1\u7aef\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25\uff01");
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        ctx.init(null, new TrustManager[]{tm}, new SecureRandom());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    private static boolean isHttpsUrl(String url) {
        return null != url && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("https://");
    }

    public static String getHost(String url) {
        int index = url.indexOf("//");
        String host = url.substring(index + 2);
        if ((index = host.indexOf("/")) > 0) {
            host = host.substring(0, index);
        }
        LoggerUtil.debug("host:" + host);
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postDataJson(String url, String jsonData) {
        LoggerUtil.info("\u8bf7\u6c42\u5730\u5740:" + url + "\u53d1\u9001\u5185\u5bb9:" + jsonData);
        String result = "";
        CloseableHttpClient client = null;
        String encode = "UTF-8";
        try {
            client = HttpClient.isHttpsUrl(url) ? HttpClient.registerSSL(HttpClient.getHost(url), "TLS", 8883, "https") : HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(20000).build();
            HttpPost post = new HttpPost(url);
            post.setConfig(requestConfig);
            post.setHeader("Accept", "application/json");
            post.setHeader("Content-Type", "application/json;charset=" + encode);
            ByteArrayEntity httpEntity = new ByteArrayEntity(jsonData.getBytes("UTF-8"));
            post.setEntity((HttpEntity)httpEntity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            Integer status = response.getStatusLine().getStatusCode();
            StringBuffer sb = new StringBuffer();
            InputStreamReader iReader = null;
            InputStream inputStream = entity.getContent();
            iReader = new InputStreamReader(inputStream, encode);
            BufferedReader reader = new BufferedReader(iReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            iReader.close();
            result = sb.toString();
            LoggerUtil.info("\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + status + ",result:" + result);
        }
        catch (Exception e) {
            LoggerUtil.error("HttpClient\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5730\u5740\u9519\u8bef," + e);
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postResponse(String url, String encode, String content) {
        LoggerUtil.debug("\u5411" + url + "\u53d1\u8d77\u8bf7\u6c42");
        String result = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClient.isHttpsUrl(url) ? HttpClient.registerSSL(HttpClient.getHost(url), "TLS", 8883, "https") : HttpClients.createDefault();
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost httppost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(6000).build();
            httppost.setConfig(requestConfig);
            StringEntity reqEntity = new StringEntity(content, encode);
            reqEntity.setContentType("application/xml;charset=" + encode);
            reqEntity.setContentEncoding(encode);
            httppost.setEntity((HttpEntity)reqEntity);
            httppost.setHeader("Accept", "application/xml");
            httppost.setHeader("Content-Type", "application/xml;charset=" + encode);
            response = client.execute((HttpUriRequest)httppost);
            entity = response.getEntity();
            Integer status = response.getStatusLine().getStatusCode();
            StringBuffer sb = new StringBuffer();
            InputStreamReader iReader = null;
            InputStream inputStream = entity.getContent();
            iReader = new InputStreamReader(inputStream, encode);
            BufferedReader reader = new BufferedReader(iReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            iReader.close();
            result = sb.toString();
            LoggerUtil.info("\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + status + ",result:" + result);
        }
        catch (Exception e) {
            e.fillInStackTrace();
            String exec = "HttpClientConnect\u8bf7\u6c42url\uff1a" + url + ",content:" + content + " ,\u5f02\u5e38\u4fe1\u606f" + e.getMessage();
            LoggerUtil.error("\u8bf7\u6c42\u6267\u884c\u5f02\u5e38\uff1a" + exec);
            String string = exec;
            return string;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postResponseSet(String url, String encode, String content, int timeLong) {
        LoggerUtil.debug("\u5411" + url + "\u53d1\u8d77\u8bf7\u6c42");
        String result = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClient.isHttpsUrl(url) ? HttpClient.registerSSL(HttpClient.getHost(url), "TLS", 8883, "https") : HttpClients.createDefault();
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpPost httppost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(1000 * timeLong).build();
            httppost.setConfig(requestConfig);
            StringEntity reqEntity = new StringEntity(content, encode);
            reqEntity.setContentType("application/xml;charset=" + encode);
            reqEntity.setContentEncoding(encode);
            httppost.setEntity((HttpEntity)reqEntity);
            httppost.setHeader("Accept", "application/xml");
            httppost.setHeader("Content-Type", "application/xml;charset=" + encode);
            response = client.execute((HttpUriRequest)httppost);
            entity = response.getEntity();
            Integer status = response.getStatusLine().getStatusCode();
            StringBuffer sb = new StringBuffer();
            InputStreamReader iReader = null;
            InputStream inputStream = entity.getContent();
            iReader = new InputStreamReader(inputStream, encode);
            BufferedReader reader = new BufferedReader(iReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            iReader.close();
            result = sb.toString();
            LoggerUtil.info("\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + status + ",result:" + result);
        }
        catch (Exception e) {
            e.fillInStackTrace();
            String exec = "HttpClientConnect\u8bf7\u6c42url\uff1a" + url + ",\u5f02\u5e38\u4fe1\u606f" + e.getMessage();
            LoggerUtil.error("\u8bf7\u6c42\u6267\u884c\u5f02\u5e38\uff1a" + exec);
            String string = exec;
            return string;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponse(String url, String encode, String content) {
        LoggerUtil.debug("\u5411" + url + "\u53d1\u8d77\u8bf7\u6c42");
        String result = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClient.isHttpsUrl(url) ? HttpClient.registerSSL(HttpClient.getHost(url), "TLS", 8883, "https") : HttpClients.createDefault();
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpGet httpget = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(6000).build();
            httpget.setConfig(requestConfig);
            response = client.execute((HttpUriRequest)httpget);
            System.out.println("StatusCode -> " + response.getStatusLine().getStatusCode());
            entity = response.getEntity();
            String jsonStr = EntityUtils.toString((HttpEntity)entity, (String)encode);
            httpget.releaseConnection();
            result = jsonStr;
        }
        catch (Exception e) {
            LoggerUtil.error("HttpClientConnect\u8bf7\u6c42url\uff1a" + url + ",\u5f02\u5e38" + e.getMessage());
            String string = result = "HttpClientConnect\u8bf7\u6c42url\uff1a" + url + ",\u5f02\u5e38" + e.getMessage();
            return string;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSend(String url, String encode, String content) {
        LoggerUtil.info("\u5411" + url + "\u53d1\u8d77\u8bf7\u6c42");
        String result = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClient.isHttpsUrl(url) ? HttpClient.registerSSL(HttpClient.getHost(url), "TLS", 8883, "https") : HttpClients.createDefault();
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            HttpGet httpget = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(6000).build();
            httpget.setConfig(requestConfig);
            response = client.execute((HttpUriRequest)httpget);
            LoggerUtil.info("StatusCode -> " + response.getStatusLine().getStatusCode());
            entity = response.getEntity();
            String jsonStr = EntityUtils.toString((HttpEntity)entity, (String)encode);
            httpget.releaseConnection();
            result = jsonStr;
        }
        catch (Exception e) {
            LoggerUtil.error("HttpClientConnect\u8bf7\u6c42url\uff1a" + url + ",\u5f02\u5e38" + e.getMessage());
            String string = result = "\u8bf7\u6c42url\uff1a" + url + ",\u5f02\u5e38" + e.getMessage();
            return string;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult postSend(String url, String encode, String content, int sockeTimeout, int connectTimeout, int connectReqTimeOut, String method, String action, String authorization) {
        HttpEntity entity;
        LoggerUtil.info("\u5411" + url + "\u53d1\u8d77\u8bf7\u6c42");
        Long b = System.currentTimeMillis();
        HttpPost post = new HttpPost(url);
        try {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(sockeTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectReqTimeOut).setExpectContinueEnabled(false).build();
            post.setConfig(requestConfig);
            StringEntity reqEntity = new StringEntity(content, encode);
            reqEntity.setContentType("application/xml;charset=" + encode);
            reqEntity.setContentEncoding(encode);
            post.setEntity((HttpEntity)reqEntity);
            if (StringUtils.isNotEmpty((String)action)) {
                post.setHeader("Action", action);
            }
            if (StringUtils.isNotEmpty((String)authorization)) {
                post.setHeader("Authorization", authorization);
            }
            post.setHeader("Accept", "application/" + method);
            post.setHeader("Content-Type", "application/" + method + ";charset=" + encode);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            Integer status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity, (String)encode);
                HttpResult httpResult = new HttpResult(200, result, b);
                return httpResult;
            }
            LoggerUtil.info("\u8bf7\u6c42\u5931\u8d25\u72b6\u6001\u7801\uff1a" + status);
            HttpResult httpResult = new HttpResult(status, response.getStatusLine().getReasonPhrase(), b);
            return httpResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerUtil.error("\u8bf7\u6c42\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
        }
        {
            finally {
                if (entity != null) {
                    entity.getContent().close();
                }
            }
        }
        {
            HttpResult httpResult = new HttpResult(-1, e.getMessage(), b);
            return httpResult;
        }
        finally {
            post.releaseConnection();
        }
    }

    public static void downLoadFromUrl(String urlStr, String fileName, String savePath) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        byte[] getData = HttpClient.readInputStream(inputStream);
        File saveDir = new File(savePath);
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
        File file = new File(saveDir + File.separator + fileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(getData);
        if (fos != null) {
            fos.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        System.out.println("info:" + url + " download success");
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    static {
        LoggerUtil.info("HttpClient\u521d\u59cb\u5316");
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().build();
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, null);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
            connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
            connManager.setDefaultSocketConfig(socketConfig);
            MessageConstraints messageConstraints = MessageConstraints.custom().setMaxHeaderCount(200).setMaxLineLength(2000).build();
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).setMessageConstraints(messageConstraints).build();
            connManager.setDefaultConnectionConfig(connectionConfig);
            connManager.setMaxTotal(200);
            connManager.setDefaultMaxPerRoute(20);
        }
        catch (KeyManagementException e) {
            LoggerUtil.error("KeyManagementException" + e);
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtil.error("NoSuchAlgorithmException" + e);
        }
    }
}

